@extends('admin.layouts.app')

@section('title', 'View Exam Details')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('exams.index') }}">Exams</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ $exam->name }}</li>
@endsection

@section('content')

<div class="row">
    <div class="col-12">
        <!-- Exam Header Card -->
        <div class="card mb-4 shadow-sm border-0 bg-primary text-white">
            <div class="card-body p-4">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h2 class="h3 fw-bold mb-1"><i class="bi bi-journal-check me-2"></i>{{ $exam->name }}</h2>
                        <p class="mb-0 opacity-75">
                            <i class="bi bi-layers me-1"></i> Batch: <strong>{{ $exam->batch->name }}</strong>
                            <span class="mx-2">|</span>
                            <i class="bi bi-calendar-event me-1"></i> Year: <strong>{{ $exam->start_date->format('Y') }}</strong>
                            <span class="mx-2">|</span>
                             <span class="badge bg-light text-primary">{{ ucfirst($exam->status) }}</span>
                        </p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('result-management.students', $exam) }}" class="btn btn-light shadow-sm text-primary fw-bold">
                            <i class="bi bi-pencil-square me-1"></i> Enter Results
                        </a>
                        <a href="{{ route('exams.edit', $exam) }}" class="btn btn-warning shadow-sm text-dark fw-bold">
                            <i class="bi bi-gear me-1"></i> Edit Exam
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Info Cards -->
        <div class="row g-4 mb-4">
            <!-- Template Info -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 border-start border-4 border-info">
                    <div class="card-body d-flex align-items-center">
                        <div class="rounded-circle bg-info bg-opacity-10 p-3 me-3">
                            <i class="bi bi-file-earmark-text text-info fs-3"></i>
                        </div>
                        <div>
                            <h6 class="card-subtitle text-muted small mb-1">Template Used</h6>
                            <h4 class="card-title mb-0 fw-bold">{{ $exam->examTemplate->name }}</h4>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Subject Stats -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 border-start border-success">
                    <div class="card-body d-flex align-items-center">
                         <div class="rounded-circle bg-success bg-opacity-10 p-3 me-3">
                            <i class="bi bi-book text-success fs-3"></i>
                        </div>
                        <div>
                            <h6 class="card-subtitle text-muted small mb-1">Total Subjects</h6>
                            <h4 class="card-title mb-0 fw-bold">{{ $exam->subjectRules->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Student Stats -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 border-start border-purple" style="border-left-color: #6f42c1 !important;">
                    <div class="card-body d-flex align-items-center">
                        <div class="rounded-circle p-3 me-3" style="background-color: rgba(111, 66, 193, 0.1);">
                            <i class="bi bi-people text-purple fs-3" style="color: #6f42c1;"></i>
                        </div>
                        <div>
                            <h6 class="card-subtitle text-muted small mb-1">Results Entered</h6>
                            <h4 class="card-title mb-0 fw-bold">{{ $exam->marks->unique('student_id')->count() }} <span class="fs-6 fw-normal text-muted">Students</span></h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Subject Rules Table -->
        <div class="card shadow-sm border-0">
            <div class="card-header bg-white py-3 border-0">
                <h5 class="card-title mb-0 fw-bold"><i class="bi bi-list-check me-2 text-secondary"></i>Applied Subject Rules</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="px-4 py-3 text-secondary text-uppercase small fw-bold">Subject</th>
                                <th class="px-4 py-3 text-secondary text-uppercase small fw-bold">Paper Mode</th>
                                <th class="px-4 py-3 text-secondary text-uppercase small fw-bold">Configuration</th>
                                <th class="px-4 py-3 text-secondary text-uppercase small fw-bold text-center">Total Marks</th>
                                <th class="px-4 py-3 text-secondary text-uppercase small fw-bold text-center">Pass Marks</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($exam->subjectRules as $rule)
                            <tr>
                                <td class="px-4 py-3">
                                    <div class="fw-bold text-dark">{{ $rule->subject->name }}</div>
                                    <div class="small text-muted">{{ $rule->subject->code }}</div>
                                </td>
                                <td class="px-4 py-3">
                                    @if($rule->paper_mode === 'merged')
                                        <span class="badge bg-info bg-opacity-10 text-info border border-info px-3 py-2 rounded-pill">
                                            Merged Paper
                                        </span>
                                    @else
                                        <span class="badge bg-purple bg-opacity-10 text-purple border border-purple px-3 py-2 rounded-pill" style="color: #6f42c1; border-color: #6f42c1; background-color: rgba(111, 66, 193, 0.1);">
                                            Separate Papers
                                        </span>
                                    @endif
                                </td>
                                <td class="px-4 py-3">
                                     <div class="d-flex flex-wrap gap-2">
                                        @php $config = $rule->config ?? []; @endphp
                                        @if($rule->paper_mode === 'merged')
                                            @if(($config['has_mcq'] ?? false))
                                                <span class="badge bg-light text-dark border">MCQ: {{ $config['mcq_marks'] ?? 0 }}</span>
                                            @endif
                                            @if(($config['has_cq'] ?? false))
                                                 <span class="badge bg-light text-dark border">CQ: {{ $config['cq_marks'] ?? 0 }}</span>
                                            @endif
                                            @if(($config['has_practical'] ?? false))
                                                 <span class="badge bg-light text-dark border">Prac: {{ $config['practical_marks'] ?? 0 }}</span>
                                            @endif
                                        @else
                                             <!-- Logic for separate paper display can be improved if config structure is consistent -->
                                             <span class="badge bg-light text-dark border">Paper 1</span>
                                             <span class="badge bg-light text-dark border">Paper 2</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <span class="fw-bold fs-5">{{ $rule->total_marks }}</span>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <span class="badge bg-danger bg-opacity-10 text-danger border border-danger px-3 rounded-pill">{{ $rule->pass_marks }}</span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0 py-3">
                <a href="{{ route('exams.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Back to Exams
                </a>
            </div>
        </div>
    </div>
</div>

@endsection


