@extends('frontend.layouts.app')

@section('title', 'About Us - ' . ($global_settings['college_name'] ?? 'College Name'))

@section('content')

<div class="container py-5">
    
    <div class="row g-5">
        <!-- Main Content -->
        <div class="col-lg-8 animate-up" style="animation-delay: 0.5s;">
            


            <!-- Principal's Message Detailed -->
            <div class="principal-section bg-white rounded-4 shadow-sm border border-light overflow-hidden position-relative">
                <div class="row g-0">
                    <div class="col-md-4 bg-gradient-primary position-relative overflow-hidden">
                        <!-- Simplified background for image side -->
                        <div class="h-100 d-flex align-items-center justify-content-center p-4 bg-light">
                             @php
                                $p_image = $global_settings['principal_image'] ?? null;
                                $principal_img = 'https://via.placeholder.com/400x500?text=Principal';
                                 if ($p_image) {
                                     if (Str::startsWith($p_image, 'http')) {
                                        $principal_img = $p_image;
                                    } elseif (Str::startsWith($p_image, 'storage/')) {
                                        $principal_img = asset($p_image);
                                    } else {
                                        $principal_img = asset('storage/' . $p_image);
                                    }
                                }
                            @endphp
                            <img src="{{ $principal_img }}" class="img-fluid rounded-circle shadow-lg border border-4 border-white" alt="Principal" style="width: 180px; height: 180px; object-fit: cover;">
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="p-4 p-lg-5">
                            <div class="mb-4">
                                <h3 class="fw-bold font-serif mb-1 text-dark">{{ $global_settings['principal_name'] ?? 'Principal Name' }}</h3>
                                <span class="badge bg-primary px-3 py-1 rounded-pill">Principal</span>
                            </div>
                            
                            <div class="position-relative">
                                <i class="fas fa-quote-left text-primary opacity-25 fa-3x position-absolute top-0 start-0 translate-middle-y"></i>
                                <p class="text-secondary lh-lg mb-0 pt-2" style="text-align: justify;">
                                    {!! nl2br(e($global_settings['principal_message_short'] ?? 'We welcome you to our college. Education is the most powerful weapon which you can use to change the world. We are committed to fostering an environment where students can thrive academically, socially, and morally.')) !!}
                                </p>
                            </div>
                            

                        </div>
                    </div>
                </div>
            </div>

            <!-- Excellence Highlight -->
            <div class="mt-5">
                <h2 class="font-serif fw-bold text-dark mb-4 display-6">Excellence in Education</h2>
                <p class="text-secondary lh-lg mb-4 lead" style="text-align: justify;">
                    {{ $global_settings['description'] ?? 'We are dedicated to providing the best learning environment for our students. Our campus is equipped with modern facilities and guided by experienced faculty members.' }}
                </p>
            </div>

        </div>
        
        <!-- Sidebar Info -->
        <div class="col-lg-4 animate-up" style="animation-delay: 0.6s;">
            <!-- Contact Card -->
            <div class="card border-0 shadow-sm rounded-4 mb-4 overflow-hidden">
                <div class="card-header bg-white border-0 py-3 px-4">
                    <h5 class="font-serif fw-bold mb-0 text-dark border-start border-4 border-primary ps-3">Quick Contact</h5>
                </div>
                <div class="card-body p-4 pt-2">
                    <ul class="list-unstyled mb-0">
                        <li class="d-flex mb-4">
                            <div class="flex-shrink-0">
                                <div class="bg-light rounded-circle p-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                    <i class="fas fa-map-marker-alt text-primary"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="fw-bold mb-1">Campus Address</h6>
                                <p class="text-muted small mb-0">{{ $global_settings['contact_full_address'] ?? 'College Campus' }}</p>
                            </div>
                        </li>
                        <li class="d-flex mb-4">
                            <div class="flex-shrink-0">
                                <div class="bg-light rounded-circle p-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                    <i class="fas fa-phone text-primary"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="fw-bold mb-1">Phone Number</h6>
                                <p class="text-muted small mb-0">{{ $global_settings['contact_office_phone'] ?? '+880 123 456 789' }}</p>
                            </div>
                        </li>
                        <li class="d-flex">
                            <div class="flex-shrink-0">
                                <div class="bg-light rounded-circle p-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                    <i class="fas fa-envelope text-primary"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="fw-bold mb-1">Email Address</h6>
                                <p class="text-muted small mb-0">{{ $global_settings['contact_general_email'] ?? 'info@college.edu.bd' }}</p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Stats/Fact Widget -->
             <div class="card border-0 shadow-sm rounded-4 bg-primary text-white overflow-hidden position-relative">
                <div class="position-absolute top-0 end-0 p-3 opacity-25">
                     <i class="fas fa-university fa-5x"></i>
                </div>
                <div class="card-body p-4 position-relative z-1">
                    <h4 class="font-serif fw-bold mb-3">Why Choose Us?</h4>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2"><i class="fas fa-check-circle me-2 opacity-75"></i> Experienced Faculty</li>
                        <li class="mb-2"><i class="fas fa-check-circle me-2 opacity-75"></i> Modern Labs</li>
                        <li class="mb-2"><i class="fas fa-check-circle me-2 opacity-75"></i> Digital Library</li>
                        <li class="mb-2"><i class="fas fa-check-circle me-2 opacity-75"></i> Co-curricular Activities</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .header-pattern {
        background: repeating-linear-gradient(
            45deg,
            transparent,
            transparent 10px,
            rgba(255, 255, 255, 0.1) 10px,
            rgba(255, 255, 255, 0.1) 20px
        );
    }
    
    .about-card {
        border: 1px solid rgba(0,0,0,0.05);
    }
    
    .about-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.08) !important;
    }
    
    .animate-up {
        animation: fadeInUp 0.8s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }
    
    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>
@endsection
