@extends('frontend.layouts.app')

@section('title', $notice->title . ' - Notice')

@section('content')
<div class="notice-details-wrapper py-5 position-relative overflow-hidden" style="background: #f8fafc; min-height: 80vh;">
    <!-- Decor Background -->
    <div class="position-absolute top-0 start-0 w-100 h-100 overflow-hidden" style="z-index: 0;">
        <div class="position-absolute top-0 end-0 translate-middle-y rounded-circle bg-primary opacity-5 blur-3xl" style="width: 500px; height: 500px; filter: blur(80px); opacity: 0.05;"></div>
        <div class="position-absolute bottom-0 start-0 translate-middle-x rounded-circle bg-info opacity-5 blur-3xl" style="width: 400px; height: 400px; filter: blur(60px); opacity: 0.05;"></div>
    </div>

    <div class="container position-relative z-1">
        <!-- Breadcrumb / Back Navigation -->
        <div class="mb-4 animate-up">
            <a href="{{ route('notice') }}" class="text-decoration-none text-muted small fw-bold text-uppercase ls-1 hover-primary transition">
                <i class="fas fa-arrow-left me-2"></i> Back to Notices
            </a>
        </div>

        <div class="row justify-content-center animate-up" style="animation-delay: 0.1s;">
            <div class="col-lg-10">
                <div class="card border-0 shadow-lg rounded-4 overflow-hidden position-relative bg-white">
                    <!-- Premium Header Decoration -->
                    <div class="position-absolute top-0 start-0 w-100 h-1 bg-gradient-primary"></div>
                    
                    <div class="card-body p-0">
                        <div class="row g-0">
                            <!-- Left: Content & Header -->
                            <div class="col-lg-12 p-4 p-md-5">
                                <div class="d-flex align-items-start gap-4 mb-4">
                                    <div class="d-flex flex-column align-items-center justify-content-center bg-light rounded-3 p-3 text-primary shadow-sm" style="min-width: 80px;">
                                        <span class="h2 fw-bold mb-0 font-serif">{{ date('d', strtotime($notice->published_at)) }}</span>
                                        <span class="small text-uppercase fw-bold">{{ date('M', strtotime($notice->published_at)) }}</span>
                                    </div>
                                    <div>
                                        <h1 class="h2 fw-bold font-serif text-dark mb-2">{{ $notice->title }}</h1>
                                        <div class="d-flex align-items-center gap-3 text-muted small">
                                            <span><i class="far fa-clock me-1"></i> {{ date('l, F j, Y', strtotime($notice->published_at)) }}</span>
                                            @if($notice->is_pinned)
                                                <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3"><i class="fas fa-thumbtack me-1"></i> Pinned</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="content-body text-secondary mb-5" style="font-size: 1.05rem; line-height: 1.8;">
                                    @if($notice->description)
                                        {!! nl2br(e($notice->description)) !!}
                                    @else
                                        <p class="text-muted fst-italic opacity-75">No description provided. Please view the attachment below.</p>
                                    @endif
                                </div>

                                <!-- Attachment Section -->
                                @if($notice->attachment_path)
                                    <div class="attachment-area bg-light rounded-4 p-4 mb-4 border border-light">
                                        <div class="d-flex align-items-center justify-content-between mb-3">
                                            <h5 class="fw-bold font-serif mb-0"><i class="fas fa-paperclip me-2 text-primary"></i> Attachment</h5>
                                            <a href="{{ route('notice.download', $notice->id) }}" class="btn btn-primary rounded-pill px-4 shadow-sm btn-sm fw-bold">
                                                <i class="fas fa-download me-2"></i> Download
                                            </a>
                                        </div>

                                        @php
                                            $extension = pathinfo($notice->attachment_path, PATHINFO_EXTENSION);
                                        @endphp

                                        @if(strtolower($extension) == 'pdf')
                                            <!-- PDF Embed -->
                                            <div class="ratio ratio-16x9 rounded-3 overflow-hidden shadow-sm border bg-white mb-3">
                                                <iframe src="{{ route('notice.stream', $notice->id) }}#toolbar=0&navpanes=0&scrollbar=0" allowfullscreen></iframe>
                                            </div>
                                            <div class="text-center">
                                                <a href="{{ route('notice.stream', $notice->id) }}" target="_blank" class="small text-muted text-decoration-none hover-primary">
                                                    <i class="fas fa-external-link-alt me-1"></i> Open in new tab
                                                </a>
                                            </div>
                                        @elseif(in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'webp']))
                                            <!-- Image Preview -->
                                            <div class="text-center bg-white rounded-3 p-3 border shadow-sm">
                                                <img src="{{ Storage::url($notice->attachment_path) }}" class="img-fluid rounded shadow-sm" style="max-height: 600px;" alt="Notice Attachment">
                                            </div>
                                        @else
                                            <!-- Generic File -->
                                            <div class="d-flex align-items-center p-3 bg-white rounded-3 border">
                                                <div class="bg-light rounded p-3 me-3 text-secondary">
                                                    <i class="fas fa-file-alt fa-2x"></i>
                                                </div>
                                                <div>
                                                    <h6 class="mb-1 fw-bold">Attached File</h6>
                                                    <p class="mb-0 small text-muted">Click download to view this file.</p>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .ls-1 { letter-spacing: 1px; }
    .hover-primary:hover { color: var(--bs-primary) !important; }
    .transition { transition: all 0.3s ease; }
    .bg-gradient-primary { background: linear-gradient(to right, var(--bs-primary), var(--bs-info)); }
    .blur-3xl { filter: blur(3rem); }
    
    .animate-up {
        animation: fadeInUp 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
        opacity: 0;
        transform: translateY(30px);
    }
    
    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>
@endsection
