<div class="table-container animate-up">
    <table class="table modern-table">
        <thead>
            <tr>
                <th style="width: 60%;">Description</th>
                <th style="width: 20%;" class="text-center">Date</th>
                <th style="width: 20%;" class="text-center">Action</th>
            </tr>
        </thead>
        <tbody>
            @forelse($notices as $notice)
            <tr>
                <td>
                    <div class="d-flex align-items-center">
                        @if($notice->is_pinned)
                             <i class="fas fa-thumbtack pinned-icon" title="Pinned Notice"></i>
                        @endif
                        <span class="fw-semibold text-dark">
                            {{ $notice->title }}
                        </span>
                    </div>
                </td>
                <td class="text-center">
                    <span class="notice-date">
                        {{ $notice->published_at ? \Carbon\Carbon::parse($notice->published_at)->format('d M, Y') : '--' }}
                    </span>
                </td>
                <td class="text-center">
                    @if($notice->attachment_path)
                        <div class="d-flex justify-content-center gap-2">
                             <a href="{{ route('notice.view', $notice->id) }}" target="_blank" class="action-btn btn-view" title="View File">
                                <i class="fas fa-eye"></i> View
                            </a>
                            <a href="{{ route('notice.download', $notice->id) }}" class="action-btn btn-download px-3" title="Download">
                                <i class="fas fa-download"></i>
                            </a>
                        </div>
                    @else
                        <span class="text-muted small">No file</span>
                    @endif
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="3" class="text-center py-5">
                    <div class="text-muted d-flex flex-column align-items-center">
                        <i class="far fa-folder-open fa-3x mb-3 opacity-25"></i>
                        <span class="fw-medium">No notices found at the moment.</span>
                    </div>
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

<!-- Pagination -->
<div class="mt-4 d-flex justify-content-center">
    {{ $notices->links('pagination::bootstrap-5') }}
</div>
