@extends('frontend.layouts.app')

@section('title', 'Privacy Policy - ' . ($global_settings['college_name'] ?? 'College Name'))

@section('content')
<div class="legal-page-wrapper py-5 bg-light position-relative overflow-hidden">
    <!-- Decor bg shapes -->
    <div class="position-absolute top-0 start-0 translate-middle rounded-circle bg-primary opacity-5 p-5 blur-3xl" style="width: 400px; height: 400px; filter: blur(80px);"></div>
    <div class="position-absolute bottom-0 end-0 translate-middle rounded-circle bg-info opacity-5 p-5 blur-3xl" style="width: 300px; height: 300px; filter: blur(60px);"></div>

    <div class="container py-4 position-relative z-1">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb" class="mb-5 animate-up">
             <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="{{ route('home') }}" class="text-muted text-decoration-none small text-uppercase fw-bold ls-1"><i class="fas fa-home me-1"></i> Home</a></li>
                <li class="breadcrumb-item active text-primary small text-uppercase fw-bold ls-1" aria-current="page">Privacy Policy</li>
            </ol>
        </nav>

        <div class="row justify-content-center animate-up" style="animation-delay: 0.1s;">
            <div class="col-lg-10">
                <div class="card border-0 shadow-xl rounded-4 overflow-hidden position-relative">
                    <div class="position-absolute top-0 start-0 w-100 h-1 bg-gradient-primary"></div>
                    
                    <div class="card-body p-4 p-md-5 bg-white">
                        <div class="text-center mb-5">
                            <div class="d-inline-flex align-items-center justify-content-center bg-primary bg-opacity-10 text-primary rounded-circle mb-3" style="width: 64px; height: 64px;">
                                <i class="fas fa-shield-alt fa-2x"></i>
                            </div>
                            <h1 class="fw-bold font-serif display-5 mb-2">Privacy Policy</h1>
                            <p class="text-muted small">Last Updated: {{ date('d F, Y') }}</p>
                        </div>

                        <div class="content opacity-75">
                            <h4 class="fw-bold text-dark mb-3">1. Information We Collect</h4>
                            <p class="mb-4">We collect information that you provide directly to us, such as when you apply for admission, contact us, or maximize use of our online services. This may include your name, email address, phone number, and academic records.</p>
                            
                            <h4 class="fw-bold text-dark mb-3">2. How We Use Your Information</h4>
                            <p class="mb-2">We use the information we collect to:</p>
                            <ul class="mb-4">
                                <li>Provide, maintain, and improve our educational services.</li>
                                <li>Process applications and manage student records.</li>
                                <li>Communicate with you about notices, results, and events.</li>
                                <li>Respond to your comments and questions.</li>
                            </ul>

                            <h4 class="fw-bold text-dark mb-3">3. Information Sharing</h4>
                            <p class="mb-4">We do not share your personal information with third parties except as required by law or to protect our rights and safety.</p>
                            
                            <h4 class="fw-bold text-dark mb-3">4. Security</h4>
                            <p class="mb-4">We take reasonable measures to help protect information about you from loss, theft, misuse, and unauthorized access.</p>

                            <h4 class="fw-bold text-dark mb-3">5. Contact Us</h4>
                            <p class="mb-0">If you have any questions about this Privacy Policy, please contact us at: <a href="mailto:{{ $global_settings['contact_general_email'] ?? 'info@college.edu.bd' }}" class="text-primary fw-bold text-decoration-none">{{ $global_settings['contact_general_email'] ?? 'info@college.edu.bd' }}</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .ls-1 { letter-spacing: 1px; }
    .shadow-xl { box-shadow: 0 20px 40px rgba(0,0,0,0.08) !important; }
    .bg-gradient-primary { background: linear-gradient(to right, var(--bs-primary), var(--bs-info)); }
    
    .animate-up {
        animation: fadeInUp 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
        opacity: 0;
        transform: translateY(30px);
    }
    
    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .blur-3xl { filter: blur(3rem); }
</style>
@endsection
