@extends('admin.layouts.app')

@section('title', 'Edit Hero Slide')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('hero-slides.index') }}">Gallery</a></li>
    <li class="breadcrumb-item active" aria-current="page">Edit Slide</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-8">
        <form action="{{ route('hero-slides.update', $slide) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-pencil-square me-2 text-primary"></i>Edit Slide Details</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                         <!-- Image Upload -->
                        <div class="col-12">
                            <label for="image" class="form-label small fw-bold text-muted">Slide Image</label>
                            @if($slide->image_url)
                                <div class="mb-3">
                                    <img src="{{ $slide->image_url }}" alt="Current Image" class="img-fluid rounded border" style="max-height: 200px;">
                                </div>
                            @endif
                            <input type="file" name="image" id="image" class="form-control" accept="image/*">
                            <div class="form-text small">Upload to replace current image. Recommended: 1920x600px. Max: 5MB.</div>
                            @error('image') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Title -->
                        <div class="col-12">
                            <label for="title" class="form-label small fw-bold text-muted">Title</label>
                            <input type="text" name="title" id="title" class="form-control" placeholder="Slide Heading" value="{{ old('title', $slide->title) }}">
                            @error('title') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Subtitle -->
                        <div class="col-12">
                            <label for="subtitle" class="form-label small fw-bold text-muted">Subtitle / Description</label>
                            <textarea name="subtitle" id="subtitle" class="form-control" rows="2" placeholder="Brief description...">{{ old('subtitle', $slide->subtitle) }}</textarea>
                            @error('subtitle') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Primary Button Config -->
                        <div class="col-md-6">
                            <label for="button_primary_text" class="form-label small fw-bold text-muted">Primary Button Text</label>
                            <input type="text" name="button_primary_text" id="button_primary_text" class="form-control" placeholder="e.g. Read More" value="{{ old('button_primary_text', $slide->button_primary_text) }}">
                        </div>
                        <div class="col-md-6">
                            <label for="button_primary_link" class="form-label small fw-bold text-muted">Primary Button Link</label>
                            <input type="url" name="button_primary_link" id="button_primary_link" class="form-control" placeholder="https://..." value="{{ old('button_primary_link', $slide->button_primary_link) }}">
                        </div>

                         <!-- Secondary Button Config -->
                        <div class="col-md-6">
                            <label for="button_secondary_text" class="form-label small fw-bold text-muted">Secondary Button Text</label>
                            <input type="text" name="button_secondary_text" id="button_secondary_text" class="form-control" placeholder="e.g. Contact Us" value="{{ old('button_secondary_text', $slide->button_secondary_text) }}">
                        </div>
                        <div class="col-md-6">
                            <label for="button_secondary_link" class="form-label small fw-bold text-muted">Secondary Button Link</label>
                            <input type="url" name="button_secondary_link" id="button_secondary_link" class="form-control" placeholder="https://..." value="{{ old('button_secondary_link', $slide->button_secondary_link) }}">
                        </div>

                         <!-- Order & Status -->
                        <div class="col-md-6">
                            <label for="sort_order" class="form-label small fw-bold text-muted">Display Order</label>
                            <input type="number" name="sort_order" id="sort_order" class="form-control" value="{{ old('sort_order', $slide->sort_order) }}">
                        </div>
                        <div class="col-md-6 d-flex align-items-end">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="is_active" value="1" id="is_active" {{ old('is_active', $slide->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label fw-bold small" for="is_active">Active</label>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="d-flex justify-content-end gap-2 mb-5">
                <a href="{{ route('hero-slides.index') }}" class="btn btn-light border px-4">Cancel</a>
                <button type="submit" class="btn btn-primary px-4"><i class="bi bi-check-lg me-1"></i> Update Slide</button>
            </div>

        </form>
    </div>
</div>
@endsection


