@extends('admin.layouts.app')

@section('title', 'Gallery & Hero Slides')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Gallery</li>
@endsection

@section('actions')
    <a href="{{ route('hero-slides.create') }}" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Add New Slide
    </a>
@endsection

@section('content')

@if($slides->isEmpty())
    <div class="card p-5 text-center">
        <div class="mb-3">
             <i class="bi bi-images fs-1 text-muted opacity-50"></i>
        </div>
        <h5 class="text-muted">No slides found</h5>
        <p class="text-muted small">Add images to your homepage slider/gallery.</p>
        <div class="mt-3">
            <a href="{{ route('hero-slides.create') }}" class="btn btn-primary">Add First Slide</a>
        </div>
    </div>
@else
    <div class="row g-4">
        @foreach($slides->sortBy('sort_order') as $slide)
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card h-100 overflow-hidden hover-shadow transition">
                    <div class="position-relative">
                        <!-- Image Preview -->
                        <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 200px; overflow: hidden;">
                            @if($slide->image_url)
                                <img src="{{ asset($slide->image_url) }}" class="w-100 h-100" style="object-fit: cover;" alt="Slide Image">
                            @else
                                <div class="text-muted">
                                    <i class="fas fa-image fa-3x"></i>
                                </div>
                            @endif
                            <div class="position-absolute top-0 start-0 m-2 badge bg-dark opacity-75">
                                <i class="fas fa-arrow-down"></i> {{ $slide->sort_order }}
                            </div>
                        </div>
                        
                        <!-- Badges Overlay -->
                        <div class="position-absolute top-0 start-0 p-2 d-flex gap-2">
                            <span class="badge bg-dark bg-opacity-75 backdrop-blur">
                                <i class="bi bi-sort-numeric-down me-1"></i> {{ $slide->sort_order }}
                            </span>
                             @if(!$slide->is_active)
                                <span class="badge bg-danger bg-opacity-75 backdrop-blur">Inactive</span>
                             @endif
                        </div>
                    </div>

                    <div class="card-body">
                        <h5 class="card-title fw-bold text-dark mb-1 text-truncate" title="{{ $slide->title }}">{{ $slide->title ?? 'Untitled Slide' }}</h5>
                        <p class="card-text text-muted small text-truncate">{{ $slide->subtitle ?? 'No subtitle provided' }}</p>
                        
                        @if($slide->button_text)
                            <div class="mt-3">
                                <span class="badge bg-light text-dark border">
                                    <i class="bi bi-link-45deg me-1"></i> {{ $slide->button_text }}
                                </span>
                            </div>
                        @endif
                    </div>

                    <div class="card-footer bg-white border-top-0 pt-0 pb-3 d-flex gap-2">
                        <a href="{{ route('hero-slides.edit', $slide) }}" class="btn btn-sm btn-outline-warning flex-fill">
                            <i class="bi bi-pencil-square me-1"></i> Edit
                        </a>
                        
                        <form action="{{ route('hero-slides.destroy', $slide) }}" method="POST" class="flex-fill" onsubmit="return confirm('Are you sure you want to delete this slide?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-outline-danger w-100">
                                <i class="bi bi-trash me-1"></i> Delete
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <!-- Alert / Tip -->
    <div class="mt-4 p-3 bg-light border rounded d-flex align-items-center">
        <i class="bi bi-info-circle text-primary me-3 fs-4"></i>
        <div class="small text-muted">
            <strong class="text-dark">Pro Tip:</strong> Use high-quality images (1920x600 recommended) for the best homepage experience. Slides are displayed in the order specified above.
        </div>
    </div>
@endif

@endsection
