<nav x-data="{ open: false }" class="bg-blue-900 border-b border-blue-800">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('dashboard') }}" class="text-white text-xl font-bold">
                        <i class="fas fa-graduation-cap mr-2"></i>SAWMC Admin
                    </a>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex">
                    <a href="{{ route('dashboard') }}" class="inline-flex items-center px-1 pt-1 border-b-2 {{ request()->routeIs('dashboard') ? 'border-white text-white' : 'border-transparent text-blue-200 hover:text-white hover:border-blue-300' }} text-sm font-medium leading-5 transition duration-150 ease-in-out">
                        <i class="fas fa-tachometer-alt mr-2"></i>Dashboard
                    </a>
                    <a href="{{ route('students.index') }}" class="inline-flex items-center px-1 pt-1 border-b-2 {{ request()->routeIs('students.*') ? 'border-white text-white' : 'border-transparent text-blue-200 hover:text-white hover:border-blue-300' }} text-sm font-medium leading-5 transition duration-150 ease-in-out">
                        <i class="fas fa-users mr-2"></i>Students
                    </a>
                    <a href="{{ route('result-management.index') }}" class="inline-flex items-center px-1 pt-1 border-b-2 {{ request()->routeIs('result-management.*') ? 'border-white text-white' : 'border-transparent text-blue-200 hover:text-white hover:border-blue-300' }} text-sm font-medium leading-5 transition duration-150 ease-in-out">
                        <i class="fas fa-chart-line mr-2"></i>Results
                    </a>
                    <a href="{{ route('notices.index') }}" class="inline-flex items-center px-1 pt-1 border-b-2 {{ request()->routeIs('notices.*') ? 'border-white text-white' : 'border-transparent text-blue-200 hover:text-white hover:border-blue-300' }} text-sm font-medium leading-5 transition duration-150 ease-in-out">
                        <i class="fas fa-bell mr-2"></i>Notices
                    </a>
                </div>
            </div>

            <!-- Settings Dropdown -->
            <div class="hidden sm:flex sm:items-center sm:ml-6">
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = ! open" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-blue-800 hover:bg-blue-700 focus:outline-none transition ease-in-out duration-150">
                        <div>{{ Auth::user()->name }}</div>
                        <div class="ml-1">
                            <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </div>
                    </button>

                    <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 rounded-md shadow-lg py-1 bg-white ring-1 ring-black ring-opacity-5" style="display: none;">
                        <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-user mr-2"></i>Profile
                        </a>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-sign-out-alt mr-2"></i>Log Out
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Hamburger -->
            <div class="-mr-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-blue-200 hover:text-white hover:bg-blue-800 focus:outline-none focus:bg-blue-800 focus:text-white transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <a href="{{ route('dashboard') }}" class="block pl-3 pr-4 py-2 border-l-4 {{ request()->routeIs('dashboard') ? 'border-white text-white bg-blue-800' : 'border-transparent text-blue-200 hover:text-white hover:bg-blue-800 hover:border-blue-300' }} text-base font-medium">
                <i class="fas fa-tachometer-alt mr-2"></i>Dashboard
            </a>
            <a href="{{ route('students.index') }}" class="block pl-3 pr-4 py-2 border-l-4 {{ request()->routeIs('students.*') ? 'border-white text-white bg-blue-800' : 'border-transparent text-blue-200 hover:text-white hover:bg-blue-800 hover:border-blue-300' }} text-base font-medium">
                <i class="fas fa-users mr-2"></i>Students
            </a>
            <a href="{{ route('result-management.index') }}" class="block pl-3 pr-4 py-2 border-l-4 {{ request()->routeIs('result-management.*') ? 'border-white text-white bg-blue-800' : 'border-transparent text-blue-200 hover:text-white hover:bg-blue-800 hover:border-blue-300' }} text-base font-medium">
                <i class="fas fa-chart-line mr-2"></i>Results
            </a>
            <a href="{{ route('notices.index') }}" class="block pl-3 pr-4 py-2 border-l-4 {{ request()->routeIs('notices.*') ? 'border-white text-white bg-blue-800' : 'border-transparent text-blue-200 hover:text-white hover:bg-blue-800 hover:border-blue-300' }} text-base font-medium">
                <i class="fas fa-bell mr-2"></i>Notices
            </a>
        </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-blue-800">
            <div class="px-4">
                <div class="font-medium text-base text-white">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-blue-300">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <a href="{{ route('profile.edit') }}" class="block pl-3 pr-4 py-2 border-l-4 border-transparent text-base font-medium text-blue-200 hover:text-white hover:bg-blue-800 hover:border-blue-300">
                    <i class="fas fa-user mr-2"></i>Profile
                </a>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="block w-full text-left pl-3 pr-4 py-2 border-l-4 border-transparent text-base font-medium text-blue-200 hover:text-white hover:bg-blue-800 hover:border-blue-300">
                        <i class="fas fa-sign-out-alt mr-2"></i>Log Out
                    </button>
                </form>
            </div>
        </div>
    </div>
</nav>

<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

