@extends('admin.layouts.app')

@section('title', 'Edit Notice Category')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('notice-categories.index') }}">Notice Categories</a></li>
    <li class="breadcrumb-item active" aria-current="page">Edit</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6">
        <form action="{{ route('notice-categories.update', $noticeCategory) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-pencil-square me-2 text-primary"></i>Edit Category</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <label for="name" class="form-label small fw-bold text-muted">Category Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" placeholder="e.g. Events, Academic" required value="{{ old('name', $noticeCategory->name) }}">
                             @error('name') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-12">
                            <label for="slug" class="form-label small fw-bold text-muted">Slug</label>
                            <input type="text" name="slug" id="slug" class="form-control" placeholder="Auto-generated if empty" value="{{ old('slug', $noticeCategory->slug) }}">
                             @error('slug') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="color" class="form-label small fw-bold text-muted">Color</label>
                            <div class="input-group">
                                <input type="color" class="form-control form-control-color" id="color_picker" value="{{ old('color', $noticeCategory->color) }}" title="Choose your color">
                                <input type="text" name="color" id="color" class="form-control" value="{{ old('color', $noticeCategory->color) }}" placeholder="#3B82F6">
                            </div>
                             @error('color') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6">
                             <label for="icon" class="form-label small fw-bold text-muted">Icon Class</label>
                             <input type="text" name="icon" id="icon" class="form-control" placeholder="e.g. fas fa-graduation-cap" value="{{ old('icon', $noticeCategory->icon) }}">
                             <div class="form-text small"><a href="https://fontawesome.com/icons" target="_blank" class="text-decoration-none">FontAwesome Icons</a> supported.</div>
                        </div>

                         <div class="col-12">
                            <label for="description" class="form-label small fw-bold text-muted">Description</label>
                            <textarea name="description" id="description" class="form-control" rows="3" placeholder="Optional description...">{{ old('description', $noticeCategory->description) }}</textarea>
                        </div>

                        <div class="col-md-6">
                             <label for="display_order" class="form-label small fw-bold text-muted">Display Order</label>
                             <input type="number" name="display_order" id="display_order" class="form-control" value="{{ old('display_order', $noticeCategory->display_order) }}">
                        </div>

                         <div class="col-md-6 d-flex align-items-end">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="is_active" value="1" id="is_active" {{ old('is_active', $noticeCategory->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label fw-bold small" for="is_active">Active Category</label>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="d-flex justify-content-end gap-2 mb-5">
                <a href="{{ route('notice-categories.index') }}" class="btn btn-light border px-4">Cancel</a>
                <button type="submit" class="btn btn-primary px-4"><i class="bi bi-save me-1"></i> Update Category</button>
            </div>

        </form>
    </div>
</div>

<script>
    // Sync color picker and text input
    document.getElementById('color_picker').addEventListener('input', function(e) {
        document.getElementById('color').value = e.target.value;
    });
    
    document.getElementById('color').addEventListener('input', function(e) {
        if (/^#[0-9A-F]{6}$/i.test(e.target.value)) {
            document.getElementById('color_picker').value = e.target.value;
        }
    });
</script>
@endsection
