@extends('admin.layouts.app')

@section('title', 'Notice Categories')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Notice Categories</li>
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold"><i class="bi bi-tags me-2 text-primary"></i>All Categories</h6>
                <a href="{{ route('notice-categories.create') }}" class="btn btn-primary btn-sm rounded-pill px-3">
                    <i class="bi bi-plus-lg me-1"></i> Add Category
                </a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4">Category Name</th>
                                <th>Icon</th>
                                <th>Color</th>
                                <th>Order</th>
                                <th>Notices</th>
                                <th>Status</th>
                                <th class="text-end pe-4">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($categories as $category)
                                <tr>
                                    <td class="ps-4">
                                        <div class="d-flex flex-column">
                                            <span class="fw-bold text-dark">{{ $category->name }}</span>
                                            @if($category->description)
                                                <small class="text-muted text-truncate" style="max-width: 250px;">{{ $category->description }}</small>
                                            @endif
                                            <small class="text-muted" style="font-size: 11px;">Slug: {{ $category->slug }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        @if($category->icon)
                                            <i class="{{ $category->icon }} fs-5" style="color: {{ $category->color }}"></i>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <div class="rounded-circle border" style="width: 20px; height: 20px; background-color: {{ $category->color }}"></div>
                                            <span class="small text-muted font-monospace">{{ $category->color }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark border">{{ $category->display_order }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info-subtle text-info border border-info-subtle rounded-pill">
                                            {{ $category->notices()->count() }} Notices
                                        </span>
                                    </td>
                                    <td>
                                        @if($category->is_active)
                                            <span class="badge bg-success-subtle text-success border border-success-subtle rounded-pill">Active</span>
                                        @else
                                            <span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle rounded-pill">Inactive</span>
                                        @endif
                                    </td>
                                    <td class="text-end pe-4">
                                        <div class="d-flex justify-content-end gap-2">
                                            <a href="{{ route('notice-categories.edit', $category) }}" class="btn btn-sm btn-light border hover-bg-gray-100" title="Edit">
                                                <i class="bi bi-pencil-square text-primary"></i>
                                            </a>
                                            <form action="{{ route('notice-categories.destroy', $category) }}" method="POST" onsubmit="return confirm('Are you sure? This will NOT delete the notices attached, but might affect their display.')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-light border hover-bg-danger-subtle" title="Delete">
                                                    <i class="bi bi-trash text-danger"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center py-5">
                                        <div class="d-flex flex-col align-items-center">
                                            <div class="mb-3 text-muted opacity-25">
                                                <i class="bi bi-tags-fill display-4"></i>
                                            </div>
                                            <h6 class="text-muted fw-bold">No Categories Found</h6>
                                            <p class="text-muted small mb-3">Get started by creating your first notice category.</p>
                                            <a href="{{ route('notice-categories.create') }}" class="btn btn-primary btn-sm rounded-pill px-4">
                                                Create Category
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($categories->hasPages())
                    <div class="card-footer bg-white py-3">
                        {{ $categories->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
