@extends('admin.layouts.app')

@section('title', 'Create New Notice')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('notices.index') }}">Notices</a></li>
    <li class="breadcrumb-item active" aria-current="page">Create</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-8">
        <form action="{{ route('notices.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-megaphone me-2 text-primary"></i>Notice Details</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <!-- Title -->
                        <div class="col-12">
                            <label for="title" class="form-label small fw-bold text-muted">Notice Title <span class="text-danger">*</span></label>
                            <input type="text" name="title" id="title" class="form-control" placeholder="Enter notice title" required value="{{ old('title') }}">
                            @error('title') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Category -->
                        <div class="col-md-6">
                            <label for="category_id" class="form-label small fw-bold text-muted">Category <span class="text-danger">*</span></label>
                            <select name="category_id" id="category_id" class="form-select" required>
                                <option value="">Select Category</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                            @error('category_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                         <!-- Priority -->
                         <div class="col-md-6">
                            <label for="priority" class="form-label small fw-bold text-muted">Priority</label>
                            <select name="priority" id="priority" class="form-select">
                                <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low</option>
                                <option value="normal" {{ old('priority', 'normal') == 'normal' ? 'selected' : '' }}>Normal</option>
                                <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High</option>
                                <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                            </select>
                        </div>



                         <!-- Attachment -->
                        <div class="col-12">
                             <label for="attachment" class="form-label small fw-bold text-muted">Attachment (PDF/Image)</label>
                             <input type="file" name="attachment" id="attachment" class="form-control">
                             <div class="form-text small">Optional. Max 5MB.</div>
                             @error('attachment') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Settings -->
                        <div class="col-12 mt-4">
                            <div class="d-flex gap-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_published" value="1" id="is_published" {{ old('is_published', true) ? 'checked' : '' }}>
                                    <label class="form-check-label fw-bold small" for="is_published">Publish Immediately</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_pinned" value="1" id="is_pinned" {{ old('is_pinned') ? 'checked' : '' }}>
                                    <label class="form-check-label fw-bold small" for="is_pinned">Pin to Top</label>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="d-flex justify-content-end gap-2 mb-5">
                <a href="{{ route('notices.index') }}" class="btn btn-light border px-4">Cancel</a>
                <button type="submit" class="btn btn-primary px-4"><i class="bi bi-save me-1"></i> Publish Notice</button>
            </div>

        </form>
    </div>
</div>
@endsection
