@extends('admin.layouts.app')

@section('title', 'Edit Notice')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('notices.index') }}">Notices</a></li>
    <li class="breadcrumb-item"><a href="{{ route('notices.show', $notice) }}">{{ Str::limit($notice->title, 20) }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">Edit</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-8">
        <form action="{{ route('notices.update', $notice) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="card mb-4 shadow-sm border-0">
                <div class="card-header bg-white py-3 border-bottom d-flex align-items-center justify-content-between">
                     <h6 class="mb-0 fw-bold text-primary"><i class="bi bi-pencil-square me-2"></i>Update Notice Details</h6>
                     @if($notice->is_active)
                        <span class="badge bg-success-subtle text-success">Active</span>
                     @else
                        <span class="badge bg-secondary-subtle text-secondary">Draft</span>
                     @endif
                </div>
                <div class="card-body p-4">
                    <div class="row g-3">
                        <!-- Title -->
                        <div class="col-12">
                            <label for="title" class="form-label small fw-bold text-muted">Notice Title <span class="text-danger">*</span></label>
                            <input type="text" name="title" id="title" class="form-control" placeholder="Enter notice title" required value="{{ old('title', $notice->title) }}">
                            @error('title') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Category -->
                        <div class="col-md-12">
                            <label for="category_id" class="form-label small fw-bold text-muted">Category <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="bi bi-tag"></i></span>
                                <select name="category_id" id="category_id" class="form-select" required>
                                    <option value="">Select Category</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id', $notice->notice_category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('category_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>



                         <!-- Attachment -->
                        <div class="col-12">
                             <label for="file" class="form-label small fw-bold text-muted">Attachment (PDF/Image)</label>
                             @if($notice->attachment_path)
                                <div class="mb-2 p-2 bg-light border rounded d-flex justify-content-between align-items-center">
                                    <span class="small text-muted"><i class="bi bi-paperclip me-1"></i> Current: {{ basename($notice->attachment_path) }}</span>
                                    <a href="{{ Storage::url($notice->attachment_path) }}" target="_blank" class="btn btn-sm btn-link text-decoration-none p-0">View</a>
                                </div>
                             @endif
                             <input type="file" name="file" id="file" class="form-control">
                             <div class="form-text small">Upload new file to replace current one. Max 10MB.</div>
                             @error('file') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Settings -->
                        <div class="col-12 mt-4">
                            <div class="d-flex gap-4 p-3 bg-light rounded border">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_published" value="1" id="is_published" {{ old('is_published', $notice->is_active) ? 'checked' : '' }}>
                                    <label class="form-check-label fw-bold small text-dark" for="is_published">Publish Active</label>
                                    <div class="form-text small mt-0">Uncheck to set as draft (hidden from public)</div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="d-flex justify-content-end gap-2 mb-5">
                <a href="{{ route('notices.index') }}" class="btn btn-light border px-4">Cancel</a>
                <button type="submit" class="btn btn-primary px-4 fw-bold shadow-sm"><i class="bi bi-check-lg me-1"></i> Update Notice</button>
            </div>

        </form>
    </div>
</div>
@endsection
