@extends('admin.layouts.app')

@section('title', 'Notices Management')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Notices</li>
@endsection

@section('actions')
    <div class="d-flex gap-2">
        <a href="{{ route('notice-categories.index') }}" class="btn btn-light border">
            <i class="bi bi-tags me-1"></i> Categories
        </a>
        <a href="{{ route('notices.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-lg me-1"></i> Create Notice
        </a>
    </div>
@endsection

@section('content')

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('notices.index') }}" class="row g-3">
            <div class="col-md-3">
                 <label class="form-label small text-muted fw-bold">Search</label>
                 <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><i class="bi bi-search text-muted"></i></span>
                    <input type="text" name="search" class="form-control border-start-0 ps-0" value="{{ request('search') }}" placeholder="Title...">
                </div>
            </div>
            
            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Category</label>
                <select name="category_id" class="form-select">
                    <option value="">All Categories</option>
                    @foreach(($categories ?? []) as $category)
                        <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                            {{ $category->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label small text-muted fw-bold">Priority</label>
                <select name="priority" class="form-select">
                    <option value="">All</option>
                    <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                    <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>High</option>
                    <option value="normal" {{ request('priority') == 'normal' ? 'selected' : '' }}>Normal</option>
                    <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>Low</option>
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label small text-muted fw-bold">Status</label>
                <select name="status" class="form-select">
                    <option value="">All</option>
                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                    <option value="pinned" {{ request('status') == 'pinned' ? 'selected' : '' }}>Pinned</option>
                </select>
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-dark w-100"><i class="bi bi-funnel me-1"></i> Filter</button>
            </div>
        </form>
    </div>
</div>

<!-- Notices List -->
<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted small text-uppercase">
                    <tr>
                        <th class="ps-4" width="40%">Title & Details</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>Published</th>
                        <th>Views</th>
                        <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($notices as $notice)
                        <tr class="{{ $notice->is_pinned ? 'bg-warning bg-opacity-10' : '' }}">
                            <td class="ps-4">
                                <div class="d-flex flex-column">
                                    <h6 class="mb-1 fw-bold text-dark">
                                        @if($notice->is_pinned) <i class="bi bi-pin-angle-fill text-warning me-1"></i> @endif
                                        {{ $notice->title }}
                                    </h6>

                                    <div class="mt-1 d-flex gap-2">
                                        @if($notice->is_instant) <span class="badge bg-danger rounded-pill" style="font-size: 10px;">Instant</span> @endif
                                        @if(!$notice->is_active) <span class="badge bg-secondary rounded-pill" style="font-size: 10px;">Inactive</span> @endif
                                    </div>
                                </div>
                            </td>
                            <td>
                                @if($notice->category)
                                    <span class="badge" style="background-color: {{ $notice->category->color }}20; color: {{ $notice->category->color }}; border: 1px solid {{ $notice->category->color }}40;">
                                        {{ $notice->category->name }}
                                    </span>
                                @else
                                    <span class="text-muted small">-</span>
                                @endif
                            </td>
                            <td>
                                @php
                                    $pClass = match($notice->priority) {
                                        'urgent' => 'danger',
                                        'high' => 'warning',
                                        'low' => 'secondary',
                                        default => 'info'
                                    };
                                @endphp
                                <span class="badge badge-soft-{{ $pClass }}">{{ ucfirst($notice->priority) }}</span>
                            </td>
                             <td>
                                <div class="small">
                                     <i class="bi bi-calendar3 me-1 text-muted"></i> {{ $notice->date ? $notice->date->format('M d, Y') : 'N/A' }}
                                </div>
                            </td>
                            <td>
                                <div class="small text-muted"><i class="bi bi-eye me-1"></i> {{ $notice->views_count }}</div>
                            </td>
                            <td class="text-end pe-4">
                                <div class="btn-group">
                                    <a href="{{ route('notices.show', $notice) }}" class="btn btn-sm btn-light text-primary" title="View"><i class="bi bi-eye"></i></a>
                                    <a href="{{ route('notices.edit', $notice) }}" class="btn btn-sm btn-light text-warning" title="Edit"><i class="bi bi-pencil-square"></i></a>
                                    
                                     <form action="{{ route('notices.destroy', $notice) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this notice?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="py-5 text-center text-muted">
                                <div class="mb-3">
                                    <i class="bi bi-megaphone fs-1 text-secondary opacity-50"></i>
                                </div>
                                <p class="mb-1">No notices posted yet.</p>
                                <a href="{{ route('notices.create') }}" class="btn btn-sm btn-primary mt-2">Post Notice</a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($notices->hasPages())
        <div class="card-footer bg-white border-top-0 py-3">
             {{ $notices->links('pagination::bootstrap-5') }}
        </div>
    @endif
</div>
@endsection
