@extends('admin.layouts.app')

@section('title', 'Notice Details')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('notices.index') }}">Notices</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ Str::limit($notice->title, 20) }}</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-10">
        
        <!-- Main Notice Card -->
        <div class="card shadow border-0 overflow-hidden mb-4">
            <!-- Header with Gradient -->
            <div class="card-header border-0 py-4 text-white" style="background: linear-gradient(135deg, #6f42c1 0%, #4e73df 100%);">
                <div class="d-flex justify-content-between align-items-start">
                    <div class="d-flex align-items-center gap-3">
                        <div class="bg-white bg-opacity-25 rounded-circle p-3 d-flex align-items-center justify-content-center" style="width: 56px; height: 56px;">
                             <i class="bi bi-megaphone fs-3"></i>
                        </div>
                        <div>
                            <div class="d-flex align-items-center gap-2 mb-1">
                                <span class="badge rounded-pill bg-white text-primary bg-opacity-90 border-0 fw-bold px-3">
                                    {{ $notice->category->name ?? 'General' }}
                                </span>
                                @if($notice->is_active)
                                    <span class="badge rounded-pill bg-success text-white border-0 fw-bold px-3">
                                        <i class="bi bi-check-circle-fill me-1"></i> Active
                                    </span>
                                @else
                                    <span class="badge rounded-pill bg-secondary text-white border-0 fw-bold px-3">
                                        <i class="bi bi-dash-circle me-1"></i> Inactive
                                    </span>
                                @endif
                            </div>
                            <h3 class="card-title fw-bold mb-0 text-white">{{ $notice->title }}</h3>
                            <p class="mb-0 text-white text-opacity-75 mt-1 small">
                                <i class="bi bi-calendar-event me-1"></i> Published: {{ $notice->published_at ? $notice->published_at->format('F d, Y') : 'Not yet published' }}
                            </p>
                        </div>
                    </div>
                    
                    <div class="dropdown">
                        <button class="btn btn-link text-white text-decoration-none p-0" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-three-dots-vertical fs-5"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end shadow border-0 rounded-3">
                            <li><a class="dropdown-item py-2" href="{{ route('notices.edit', $notice) }}"><i class="bi bi-pencil me-2 text-warning"></i> Edit Notice</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <form action="{{ route('notices.destroy', $notice) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="dropdown-item py-2 text-danger"><i class="bi bi-trash me-2"></i> Delete Notice</button>
                                </form>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Content Area -->
            <div class="card-body p-4 p-md-5">
                <!-- Meta Info Row -->
                <div class="row g-4 mb-5 border-bottom pb-4">
                    <div class="col-md-3 col-6">
                        <div class="d-flex align-items-center gap-3">
                            <div class="rounded p-2 bg-light text-primary border">
                                <i class="bi bi-person fs-5"></i>
                            </div>
                            <div>
                                <small class="text-muted d-block text-uppercase fw-bold" style="font-size: 0.7rem;">Created By</small>
                                <span class="fw-semibold text-dark small">{{ $notice->creator->name ?? 'Admin' }}</span>
                            </div>
                        </div>
                    </div>
                    @if($notice->attachment_path)
                    <div class="col-md-3 col-6">
                        <div class="d-flex align-items-center gap-3">
                            <div class="rounded p-2 bg-light text-danger border">
                                <i class="bi bi-file-earmark-pdf fs-5"></i>
                            </div>
                            <div>
                                <small class="text-muted d-block text-uppercase fw-bold" style="font-size: 0.7rem;">Attachment</small>
                                <a href="{{ Storage::url($notice->attachment_path) }}" target="_blank" class="fw-semibold text-primary small text-decoration-none">
                                    Download <i class="bi bi-box-arrow-up-right ms-1"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    @endif

            </div>

            <!-- Footer Actions -->
            <div class="card-footer bg-white py-3 border-top d-flex justify-content-between">
                <a href="{{ route('notices.index') }}" class="btn btn-light border fw-bold text-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Back to List
                </a>
                <a href="{{ route('notices.edit', $notice) }}" class="btn btn-primary fw-bold px-4 shadow-sm">
                    <i class="bi bi-pencil-square me-1"></i> Edit Notice
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
