@extends('admin.layouts.app')

@section('title', 'My Profile')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Profile</li>
@endsection

@section('content')

<div class="row g-4">
    <!-- Profile Card (Left Column) -->
    <div class="col-lg-4">
        <!-- User Info -->
        <div class="card shadow-sm border-0 mb-4 text-center">
            <div class="card-body p-4">
                <div class="avatar avatar-xl rounded-circle bg-primary text-white d-flex align-items-center justify-content-center mx-auto mb-3 shadow" style="width: 80px; height: 80px; font-size: 2rem;">
                    {{ substr($user->name, 0, 1) }}
                </div>
                <h5 class="fw-bold mb-1">{{ $user->name }}</h5>
                <p class="text-muted small mb-3">{{ $user->email }}</p>
                
                <div class="d-flex justify-content-center gap-2">
                    <span class="badge bg-light text-dark border">
                        <i class="bi bi-shield-lock me-1"></i> {{ $user->role ?? 'Administrator' }}
                    </span>
                    <span class="badge bg-light text-dark border">
                        <i class="bi bi-calendar3 me-1"></i> Joined {{ $user->created_at->format('M Y') }}
                    </span>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="card shadow-sm border-0">
             <div class="card-header bg-white fw-bold"><i class="bi bi-activity me-2"></i>Account Activity</div>
            <div class="list-group list-group-flush">
                <div class="list-group-item d-flex justify-content-between align-items-center">
                    <span class="small text-muted">Last Updated</span>
                    <span class="small fw-bold">{{ $user->updated_at->diffForHumans() }}</span>
                </div>
                <div class="list-group-item d-flex justify-content-between align-items-center">
                    <span class="small text-muted">Account Status</span>
                    <span class="badge bg-success-subtle text-success">Active</span>
                </div>
                 <div class="list-group-item d-flex justify-content-between align-items-center">
                    <span class="small text-muted">Total Login</span>
                    <span class="small fw-bold">N/A</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Forms (Right Column) -->
    <div class="col-lg-8">
        
        <!-- Update Profile Info -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold"><i class="bi bi-person-gear me-2 text-primary"></i>Profile Information</h6>
            </div>
            <div class="card-body">
                @if (session('status') === 'profile-updated')
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i> Profile updated successfully.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <form method="POST" action="{{ route('profile.update') }}">
                    @csrf
                    @method('PATCH')

                    <div class="mb-3">
                        <label for="name" class="form-label small fw-bold text-muted">Full Name</label>
                        <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $user->name) }}" required>
                        @error('name') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-4">
                        <label for="email" class="form-label small fw-bold text-muted">Email Address</label>
                        <input type="email" class="form-control" id="email" name="email" value="{{ old('email', $user->email) }}" required>
                        @error('email') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        
                        @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                             <div class="alert alert-warning mt-2 small">
                                Your email address is unverified. 
                                <button form="send-verification" class="btn btn-link p-0 small">Click here to re-send the verification email.</button>
                            </div>
                        @endif
                    </div>

                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-1"></i> Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Update Password -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold"><i class="bi bi-key me-2 text-warning"></i>Update Password</h6>
            </div>
            <div class="card-body">
                 @if (session('status') === 'password-updated')
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                         <i class="bi bi-check-circle me-1"></i> Password updated successfully.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <form method="POST" action="{{ route('password.update') }}">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label for="current_password" class="form-label small fw-bold text-muted">Current Password</label>
                        <input type="password" class="form-control" id="current_password" name="current_password" required>
                        @error('current_password') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label small fw-bold text-muted">New Password</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                        @error('password') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-4">
                        <label for="password_confirmation" class="form-label small fw-bold text-muted">Confirm Password</label>
                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                        @error('password_confirmation') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>

                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-dark">
                            <i class="bi bi-shield-check me-1"></i> Update Password
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Delete Account -->
        <div class="card shadow-sm border-0 border-danger border-start border-3">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold text-danger"><i class="bi bi-exclamation-triangle me-2"></i>Delete Account</h6>
            </div>
            <div class="card-body">
                <p class="text-muted small">
                    Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.
                </p>
                <div class="d-flex justify-content-end">
                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#confirmUserDeletionModal">
                       <i class="bi bi-trash me-1"></i> Delete Account
                    </button>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- Delete Account Modal -->
<div class="modal fade" id="confirmUserDeletionModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('profile.destroy') }}">
                @csrf
                @method('DELETE')
                
                <div class="modal-header">
                    <h5 class="modal-title text-danger">Are you sure you want to delete your account?</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p class="small text-muted">
                        Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.
                    </p>
                    <div class="mt-3">
                        <label for="delete_password" class="form-label small fw-bold">Password</label>
                        <input type="password" class="form-control" id="delete_password" name="password" placeholder="Password" required>
                         @error('password', 'userDeletion') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Delete Account</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
