@extends('admin.layouts.app')

@section('title', 'Enter Marks: ' . $student->name)

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('result-management.index') }}">Results</a></li>
    <li class="breadcrumb-item"><a href="{{ route('result-management.students', $exam) }}">{{ $exam->name }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ $student->name }}</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-10">
        <form action="{{ route('result-management.save', ['exam' => $exam, 'student' => $student]) }}" method="POST">
            @csrf

            <!-- Header Card -->
            <div class="card shadow-sm border-0 mb-4 bg-primary text-white">
                <div class="card-body py-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-1 fw-bold">{{ $student->name }}</h4>
                            <p class="mb-0 opacity-75">
                                Roll: {{ $student->class_roll }} | 
                                Batch: {{ $exam->batch->name }} | 
                                Year: {{ $exam->start_date->format('Y') }}
                            </p>
                        </div>
                        <a href="{{ route('result-management.students', $exam) }}" class="btn btn-light bg-white bg-opacity-10 text-white border-0 hover-bg-opacity-20">
                            <i class="bi bi-arrow-left me-1"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                @foreach($subjectsWithConfig as $subjectData)
                    @php
                        $subject = $subjectData['subject'];
                        $paperMode = $subjectData['paper_mode'];
                        $config = $subjectData['config'];
                        $existingMark = $subjectData['existing_marks'];
                        
                        // Robust logic for flags and max marks (Merged)
                        $hasMcq = $config['has_mcq'] ?? $subject->has_mcq ?? false;
                        $mcqMax = $config['mcq_marks'] ?? 0;

                        $hasCq = $config['has_cq'] ?? $subject->has_cq ?? false;
                        $cqMax = $config['cq_marks'] ?? 0;

                        $hasPractical = $config['has_practical'] ?? $subject->has_practical ?? false;
                        $practicalMax = $config['practical_marks'] ?? 0;

                        // Robust logic for Separate
                        // P1
                        $p1HasMcq = $config['paper1_has_mcq'] ?? $subject->has_first_paper; // Fallback loose
                        $p1McqMax = $config['paper1_mcq_marks'] ?? 0;
                        $p1HasCq = $config['paper1_has_cq'] ?? $subject->has_first_paper;
                        $p1CqMax = $config['paper1_cq_marks'] ?? 0;
                        $p1HasPrac = $config['paper1_has_practical'] ?? false;
                        $p1PracMax = $config['paper1_practical_marks'] ?? 0;

                        // P2
                        $p2HasMcq = $config['paper2_has_mcq'] ?? $subject->has_second_paper;
                        $p2McqMax = $config['paper2_mcq_marks'] ?? 0;
                        $p2HasCq = $config['paper2_has_cq'] ?? $subject->has_second_paper;
                        $p2CqMax = $config['paper2_cq_marks'] ?? 0;
                        $p2HasPrac = $config['paper2_has_practical'] ?? false;
                        $p2PracMax = $config['paper2_practical_marks'] ?? 0;
                    @endphp

                    <div class="col-12">
                        <div class="card shadow-sm border-0">
                            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0 fw-bold text-primary">{{ $subject->name }} <span class="text-muted fw-normal ms-2">({{ $subject->code }})</span></h6>
                                </div>
                                <div class="small">
                                    <span class="badge {{ $paperMode === 'merged' ? 'bg-info-subtle text-info-emphasis' : 'bg-purple-subtle text-purple-emphasis' }}">{{ ucfirst($paperMode) }} Mode</span>
                                    <span class="badge bg-light text-dark border ms-2">Total: {{ $subjectData['total_marks'] }}</span>
                                    <span class="badge bg-light text-dark border ms-1">Pass: {{ $subjectData['pass_marks'] }}</span>
                                </div>
                            </div>
                            
                            <div class="card-body">
                                <input type="hidden" name="marks[{{ $loop->index }}][subject_id]" value="{{ $subject->id }}">

                                @if($paperMode === 'merged')
                                    <div class="row g-3">
                                        @if($hasMcq)
                                            <div class="col-md-4">
                                                <label class="form-label small fw-bold text-muted">MCQ (Max: {{ $mcqMax }})</label>
                                                <input type="number" 
                                                       name="marks[{{ $loop->index }}][first_paper_mcq]" 
                                                       value="{{ old('marks.'.$loop->index.'.first_paper_mcq', $existingMark->first_paper_mcq ?? '') }}"
                                                       min="0" max="{{ $mcqMax }}" step="0.01"
                                                       class="form-control" placeholder="-">
                                            </div>
                                        @endif
                                        @if($hasCq)
                                            <div class="col-md-4">
                                                <label class="form-label small fw-bold text-muted">CQ (Max: {{ $cqMax }})</label>
                                                <input type="number" 
                                                       name="marks[{{ $loop->index }}][first_paper_cq]" 
                                                       value="{{ old('marks.'.$loop->index.'.first_paper_cq', $existingMark->first_paper_cq ?? '') }}"
                                                       min="0" max="{{ $cqMax }}" step="0.01"
                                                       class="form-control" placeholder="-">
                                            </div>
                                        @endif
                                        @if($hasPractical)
                                            <div class="col-md-4">
                                                <label class="form-label small fw-bold text-muted">Practical (Max: {{ $practicalMax }})</label>
                                                <input type="number" 
                                                       name="marks[{{ $loop->index }}][first_paper_practical]" 
                                                       value="{{ old('marks.'.$loop->index.'.first_paper_practical', $existingMark->first_paper_practical ?? '') }}"
                                                       min="0" max="{{ $practicalMax }}" step="0.01"
                                                       class="form-control" placeholder="-">
                                            </div>
                                        @endif
                                    </div>
                                @else
                                    {{-- Separate Mode --}}
                                    <div class="row g-3">
                                        {{-- First Paper --}}
                                        @if($subject->has_first_paper)
                                            <div class="col-md-6 border-end">
                                                <h6 class="text-primary fw-bold mb-3 small text-uppercase">First Paper</h6>
                                                <div class="row g-2">
                                                    @if($p1HasMcq)
                                                        <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="MCQ"
                                                                       name="marks[{{ $loop->index }}][first_paper_mcq]" 
                                                                       value="{{ old('marks.'.$loop->index.'.first_paper_mcq', $existingMark->first_paper_mcq ?? '') }}"
                                                                       min="0" max="{{ $p1McqMax }}" step="0.01">
                                                                <label>MCQ ({{ $p1McqMax }})</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if($p1HasCq)
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="CQ"
                                                                       name="marks[{{ $loop->index }}][first_paper_cq]" 
                                                                       value="{{ old('marks.'.$loop->index.'.first_paper_cq', $existingMark->first_paper_cq ?? '') }}"
                                                                       min="0" max="{{ $p1CqMax }}" step="0.01">
                                                                <label>CQ ({{ $p1CqMax }})</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if($p1HasPrac)
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="Prac"
                                                                       name="marks[{{ $loop->index }}][first_paper_practical]" 
                                                                       value="{{ old('marks.'.$loop->index.'.first_paper_practical', $existingMark->first_paper_practical ?? '') }}"
                                                                       min="0" max="{{ $p1PracMax }}" step="0.01">
                                                                <label>Prac ({{ $p1PracMax }})</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif

                                        {{-- Second Paper --}}
                                        @if($subject->has_second_paper)
                                            <div class="col-md-6 ps-md-4">
                                                <h6 class="text-success fw-bold mb-3 small text-uppercase">Second Paper</h6>
                                                <div class="row g-2">
                                                     @if($p2HasMcq)
                                                        <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="MCQ"
                                                                       name="marks[{{ $loop->index }}][second_paper_mcq]" 
                                                                       value="{{ old('marks.'.$loop->index.'.second_paper_mcq', $existingMark->second_paper_mcq ?? '') }}"
                                                                       min="0" max="{{ $p2McqMax }}" step="0.01">
                                                                <label>MCQ ({{ $p2McqMax }})</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if($p2HasCq)
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="CQ"
                                                                       name="marks[{{ $loop->index }}][second_paper_cq]" 
                                                                       value="{{ old('marks.'.$loop->index.'.second_paper_cq', $existingMark->second_paper_cq ?? '') }}"
                                                                       min="0" max="{{ $p2CqMax }}" step="0.01">
                                                                <label>CQ ({{ $p2CqMax }})</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if($p2HasPrac)
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="Prac"
                                                                       name="marks[{{ $loop->index }}][second_paper_practical]" 
                                                                       value="{{ old('marks.'.$loop->index.'.second_paper_practical', $existingMark->second_paper_practical ?? '') }}"
                                                                       min="0" max="{{ $p2PracMax }}" step="0.01">
                                                                <label>Prac ({{ $p2PracMax }})</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Sticky Footer Action -->
            <div class="card fixed-bottom border-top shadow-lg" style="bottom: 0px; z-index: 100;">
                <div class="card-body py-3">
                    <div class="container d-flex justify-content-end gap-2">
                         <a href="{{ route('result-management.students', $exam) }}" class="btn btn-light border px-4">Cancel</a>
                        <button type="submit" class="btn btn-primary px-5 fw-bold shadow-sm">
                            <i class="bi bi-save me-2"></i> Save Marks
                        </button>
                    </div>
                </div>
            </div>
            <!-- Spacer for fixed footer -->
            <div style="height: 100px;"></div>

        </form>
    </div>
</div>
@endsection
