@extends('admin.layouts.app')

@section('title', 'Result Management')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Results</li>
@endsection

@section('actions')
    <a href="{{ route('exams.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i> Create Exam
    </a>
@endsection

@section('content')

    @if(isset($currentBatch))
    <div class="card border-0 shadow-sm mb-4 bg-success text-white overflow-hidden position-relative">
        <div class="card-body p-4 position-relative z-1">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                     <h5 class="mb-1 text-white-50 small text-uppercase fw-bold">Grading Batch</h5>
                    <h3 class="mb-0 fw-bold text-white">{{ $currentBatch->name }}</h3>
                </div>
                <a href="{{ route('result-management.index') }}" class="btn btn-light text-success fw-bold shadow-sm">
                    <i class="bi bi-arrow-left me-1"></i> Back to Folders
                </a>
            </div>
        </div>
        <!-- Decorative bg circle -->
        <div class="position-absolute top-0 end-0 p-3 opacity-25">
            <i class="bi bi-mortarboard-fill display-1 text-white"></i>
        </div>
    </div>
@endif

    @if($exams->isEmpty())
        <div class="card p-5 text-center border-0 shadow-sm">
            <div class="mb-3">
                <i class="bi bi-journal-text fs-1 text-muted opacity-50"></i>
            </div>
            <h5 class="text-muted">No exams available for results</h5>
            <p class="text-muted small">Create an exam first to start entering marks.</p>
            <div class="mt-3">
                <a href="{{ route('exams.create') }}" class="btn btn-primary">Create First Exam</a>
            </div>
        </div>
    @else
        <div class="row g-4">
            @foreach($exams as $exam)
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="card h-100 shadow-sm border-0">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div>
                                    <h5 class="card-title fw-bold text-dark mb-1">{{ $exam->name }}</h5>
                                    <span class="badge bg-light text-dark border">{{ $exam->batch->name ?? 'N/A' }}</span>
                                </div>
                                @if($exam->status === 'upcoming')
                                    <span class="badge bg-warning-subtle text-warning-emphasis">Upcoming</span>
                                @elseif($exam->status === 'ongoing')
                                    <span class="badge bg-success-subtle text-success-emphasis">Ongoing</span>
                                @else
                                    <span class="badge bg-secondary-subtle text-secondary-emphasis">Completed</span>
                                @endif
                            </div>

                            <div class="small text-muted mb-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar3 me-2 text-primary"></i>
                                    {{ $exam->start_date ? \Carbon\Carbon::parse($exam->start_date)->format('M d, Y') : 'N/A' }}
                                </div>
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-file-earmark-text me-2 text-primary"></i>
                                    {{ $exam->examTemplate->name ?? 'No Template' }}
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <a href="{{ route('result-management.students', $exam) }}" class="btn btn-primary flex-fill">
                                    <i class="bi bi-pencil-square me-1"></i> Enter Marks
                                </a>
                                <a href="{{ route('result-management.view-results', $exam) }}"
                                    class="btn btn-outline-success flex-fill">
                                    <i class="bi bi-table me-1"></i> View Results
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-4">
            {{ $exams->links('pagination::bootstrap-5') }}
        </div>
    @endif

@endsection