@extends('admin.layouts.app')

@section('title', 'Select Subject')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('result-management.index') }}">Results</a></li>
    <li class="breadcrumb-item active" aria-current="page">Select Subject</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-12">
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <div>
                     <h5 class="mb-0 fw-bold">{{ $exam->name }}</h5>
                     <small class="text-muted">Batch: {{ $exam->batch->name }} | Year: {{ $exam->start_date->format('Y') }} | Template: {{ $exam->examTemplate->name }}</small>
                </div>
                <a href="{{ route('result-management.index') }}" class="btn btn-light border">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
            
            <div class="card-body">
                <div class="row g-4">
                    @forelse($subjectStats as $s)
                        <div class="col-md-6 col-lg-4">
                            <div class="card h-100 border hover-shadow-sm transition">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <div>
                                            <h6 class="fw-bold mb-1">{{ $s['subject']->name }}</h6>
                                            <small class="text-muted">Code: {{ $s['subject']->code }}</small>
                                        </div>
                                        @if($s['pending'] > 0)
                                            <span class="badge bg-danger-subtle text-danger">{{ $s['pending'] }} Pending</span>
                                        @else
                                            <span class="badge bg-success-subtle text-success">Completed</span>
                                        @endif
                                    </div>
                                    
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="small text-muted">Progress</span>
                                        @if($s['total'] == 0)
                                            <span class="badge bg-success-subtle text-success rounded-pill border border-success-subtle">
                                                <i class="bi bi-check2-circle me-1"></i> No Students Assigned
                                            </span>
                                        @else
                                            <small class="fw-bold">{{ $s['completed'] }} / {{ $s['total'] }} Students</small>
                                        @endif
                                    </div>
                                    <div class="progress mb-4" style="height: 6px;">
                                        @php $percent = $s['total'] > 0 ? ($s['completed'] / $s['total']) * 100 : 100; @endphp
                                        <div class="progress-bar bg-primary" role="progressbar" style="width: {{ $percent }}%" aria-valuenow="{{ $percent }}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <a href="{{ route('result-management.subject-entry', ['exam' => $exam, 'subject' => $s['subject_id']]) }}" class="btn btn-primary w-100">
                                            <i class="bi bi-pencil me-1"></i> Enter Marks
                                        </a>
                                    </div>
                                    <div class="mt-2 text-center">
                                         <small class="text-muted" style="font-size: 11px;">Mode: {{ ucfirst($s['paper_mode']) }}</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12 text-center py-5">
                            <div class="mb-3 text-muted opacity-25">
                                <i class="bi bi-exclamation-circle display-4"></i>
                            </div>
                            <h5 class="text-muted">No configuration found</h5>
                            <p class="text-muted small">No subjects are configured for this exam. Please configure the exam template first.</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
