@extends('admin.layouts.app')

@section('title', 'View Results')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('result-management.index') }}">Results</a></li>
    <li class="breadcrumb-item active" aria-current="page">View Results</li>
@endsection

@section('content')
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="mb-0 fw-bold">{{ $exam->name }}</h5>
                        <p class="text-muted small mb-0">
                            Batch: {{ $exam->batch->name }} |
                            Year: {{ $exam->start_date->format('Y') }} |
                            Template: {{ $exam->examTemplate->name }}
                        </p>
                    </div>
                    <div class="d-flex gap-2">
                        @if($exam->is_published)
                            <form action="{{ route('result-management.unpublish', $exam) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-danger text-white">
                                    <i class="bi bi-eye-slash-fill me-1"></i> Unpublish Results
                                </button>
                            </form>
                        @else
                            <form action="{{ route('result-management.publish', $exam) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-eye-fill me-1"></i> Publish Results
                                </button>
                            </form>
                        @endif

                        <a href="{{ route('result-management.export-sheet', $exam) }}" target="_blank"
                            class="btn btn-outline-secondary">
                            <i class="bi bi-printer me-1"></i> Export Sheet
                        </a>

                        <a href="{{ route('result-management.index') }}" class="btn btn-light border">
                            <i class="bi bi-arrow-left me-1"></i> Back
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if($results->isEmpty())
                        <div class="text-center py-5">
                            <div class="mb-3 text-muted opacity-25">
                                <i class="bi bi-clipboard-data display-4"></i>
                            </div>
                            <h5 class="text-muted">No results found</h5>
                            <p class="text-muted small mb-4">No results have been processed for this exam yet.</p>
                            <a href="{{ route('result-management.students', $exam) }}" class="btn btn-success">
                                <i class="bi bi-plus-lg me-1"></i> Enter Marks
                            </a>
                        </div>
                    @else
                        {{-- Statistics Cards --}}
                        <div class="row g-3 mb-4">
                            <div class="col-md-6 col-lg-3">
                                <div class="card border-0 bg-primary-subtle text-primary h-100">
                                    <div class="card-body d-flex align-items-center">
                                        <div class="rounded-circle bg-white p-3 me-3 text-primary shadow-sm"
                                            style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                            <i class="bi bi-people-fill fs-4"></i>
                                        </div>
                                        <div>
                                            <div class="small fw-bold opacity-75">Total Students</div>
                                            <div class="h3 mb-0 fw-bold">{{ $results->count() }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-3">
                                <div class="card border-0 bg-success-subtle text-success h-100">
                                    <div class="card-body d-flex align-items-center">
                                        <div class="rounded-circle bg-white p-3 me-3 text-success shadow-sm"
                                            style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                            <i class="bi bi-check-circle-fill fs-4"></i>
                                        </div>
                                        <div>
                                            <div class="small fw-bold opacity-75">Passed</div>
                                            <div class="h3 mb-0 fw-bold">
                                                {{ $results->where('result_status', 'passed')->count() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-3">
                                <div class="card border-0 bg-danger-subtle text-danger h-100">
                                    <div class="card-body d-flex align-items-center">
                                        <div class="rounded-circle bg-white p-3 me-3 text-danger shadow-sm"
                                            style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                            <i class="bi bi-x-circle-fill fs-4"></i>
                                        </div>
                                        <div>
                                            <div class="small fw-bold opacity-75">Failed</div>
                                            <div class="h3 mb-0 fw-bold">
                                                {{ $results->where('result_status', 'failed')->count() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-3">
                                <div class="card border-0 bg-info-subtle text-info-emphasis h-100">
                                    <div class="card-body d-flex align-items-center">
                                        <div class="rounded-circle bg-white p-3 me-3 text-info shadow-sm"
                                            style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                            <i class="bi bi-pie-chart-fill fs-4"></i>
                                        </div>
                                        <div>
                                            <div class="small fw-bold opacity-75">Pass Rate</div>
                                            <div class="h3 mb-0 fw-bold">
                                                {{ $results->count() > 0 ? round(($results->where('result_status', 'passed')->count() / $results->count()) * 100, 2) : 0 }}%
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Results Table --}}
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="bg-light">
                                    <tr>
                                        <th class="ps-3 border-bottom-0">Rank</th>
                                        <th class="border-bottom-0">Roll</th>
                                        <th class="border-bottom-0">Student Name</th>
                                        <th class="text-center border-bottom-0">Total Marks</th>
                                        <th class="text-center border-bottom-0">GPA</th>
                                        <th class="text-center border-bottom-0">Grade</th>
                                        <th class="text-center border-bottom-0">Status</th>
                                        <th class="text-end pe-3 border-bottom-0">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($results as $result)
                                        <tr>
                                            <td class="ps-3">
                                                @if($result->position === 1)
                                                    <span
                                                        class="badge rounded-pill bg-warning text-dark border border-warning shadow-sm px-3 py-2">
                                                        <i class="bi bi-trophy-fill me-1"></i> 1st
                                                    </span>
                                                @elseif($result->position === 2)
                                                    <span
                                                        class="badge rounded-pill bg-secondary text-white border border-secondary shadow-sm px-3 py-2">
                                                        <i class="bi bi-award-fill me-1"></i> 2nd
                                                    </span>
                                                @elseif($result->position === 3)
                                                    <span
                                                        class="badge rounded-pill bg-white text-warning-emphasis border border-warning px-3 py-2">
                                                        <i class="bi bi-award me-1"></i> 3rd
                                                    </span>
                                                @else
                                                    <span class="badge bg-light text-secondary border px-3 py-2">
                                                        #{{ $result->position ?? '-' }}
                                                    </span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="fw-bold text-dark">{{ $result->student->class_roll }}</span>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-circle bg-primary-subtle text-primary rounded-circle d-flex align-items-center justify-content-center me-2"
                                                        style="width: 32px; height: 32px;">
                                                        <span
                                                            class="fw-bold small">{{ substr($result->student->name, 0, 1) }}</span>
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold text-dark">{{ $result->student->name }}</div>
                                                        <div class="small text-muted">{{ $result->student->student_id }}</div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <span class="fw-bold">{{ $result->total_marks }}</span>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-info-subtle text-info-emphasis border border-info-subtle">
                                                    {{ number_format($result->gpa, 2) }}
                                                </span>
                                            </td>
                                            <td class="text-center">
                                                @php
                                                    $gradeColor = match ($result->grade) {
                                                        'A+' => 'success',
                                                        'A' => 'success',
                                                        'A-' => 'primary',
                                                        'B' => 'info',
                                                        'C' => 'warning',
                                                        'D' => 'warning',
                                                        default => 'danger'
                                                    };
                                                @endphp
                                                <span class="badge bg-{{ $gradeColor }}">{{ $result->grade }}</span>
                                            </td>
                                            <td class="text-center">
                                                @if($result->result_status === 'passed')
                                                    <span class="badge bg-success-subtle text-success border border-success-subtle">
                                                        <i class="bi bi-check-circle me-1"></i> Passed
                                                    </span>
                                                @else
                                                    <span class="badge bg-danger-subtle text-danger border border-danger-subtle">
                                                        <i class="bi bi-x-circle me-1"></i> Failed
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="text-end pe-3">
                                                <a href="{{ route('result-management.enter', ['exam' => $exam, 'student' => $result->student]) }}"
                                                    class="btn btn-sm btn-outline-primary shadow-sm" data-bs-toggle="tooltip"
                                                    title="View/Edit Details">
                                                    <i class="bi bi-eye"></i> Details
                                                </a>
                                                <a href="{{ route('result-management.export-pdf', ['exam' => $exam, 'student' => $result->student]) }}"
                                                    target="_blank" class="btn btn-sm btn-outline-secondary shadow-sm ms-1"
                                                    data-bs-toggle="tooltip" title="Print Result">
                                                    <i class="bi bi-printer"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-4 px-3">
                            {{ $results->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection