<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-2xl text-gray-800 flex items-center">
            <i class="fas fa-plus-circle mr-3 text-green-600"></i>Add New Result
        </h2>
    </x-slot>

    <div class="max-w-5xl mx-auto">
        <div class="bg-white overflow-hidden shadow-xl rounded-2xl">
            <!-- Header -->
            <div class="bg-gradient-to-r from-green-600 to-green-700 px-8 py-6">
                <h3 class="text-xl font-bold text-white">Result Information</h3>
                <p class="text-green-100 text-sm mt-1">Fill in the details below to add a new result</p>
            </div>

            <!-- Form -->
            <form action="{{ route('results.store') }}" method="POST" class="p-8">
                @csrf

                <!-- Student Selection -->
                <div class="mb-8 bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg">
                    <div class="flex items-start">
                        <i class="fas fa-info-circle text-blue-600 mt-1 mr-3"></i>
                        <div class="space-y-2 flex-1">
                            <p class="text-sm text-blue-800 font-medium">Link to Existing Student (Optional)</p>
                            <select name="student_id" id="student_id"
                                    class="w-full border-2 border-blue-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition">
                                <option value="">Select Student (Optional)</option>
                                @foreach($students as $student)
                                    <option value="{{ $student->id }}" {{ old('student_id') == $student->id ? 'selected' : '' }}>
                                        {{ $student->name }} - Roll: {{ $student->roll }} (Class {{ $student->class }})
                                    </option>
                                @endforeach
                            </select>
                            <p class="text-xs text-blue-700">If student exists in system, select from dropdown. Otherwise, fill in details below.</p>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Student Name -->
                    <div class="space-y-2">
                        <label for="student_name" class="block text-sm font-semibold text-gray-700">
                            <i class="fas fa-user text-green-600 mr-2"></i>Student Name *
                        </label>
                        <input type="text" name="student_name" id="student_name" value="{{ old('student_name') }}" required
                               placeholder="Enter student's full name"
                               class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                        @error('student_name')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Roll -->
                    <div class="space-y-2">
                        <label for="roll" class="block text-sm font-semibold text-gray-700">
                            <i class="fas fa-id-card text-green-600 mr-2"></i>Roll Number *
                        </label>
                        <input type="text" name="roll" id="roll" value="{{ old('roll') }}" required
                               placeholder="Enter roll number"
                               class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                        @error('roll')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Class -->
                    <div class="space-y-2">
                        <label for="class" class="block text-sm font-semibold text-gray-700">
                            <i class="fas fa-school text-green-600 mr-2"></i>Class *
                        </label>
                        <select name="class" id="class" required
                                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                            <option value="">Select Class</option>
                            <option value="11" {{ old('class') == 11 ? 'selected' : '' }}>Class 11 (XI)</option>
                            <option value="12" {{ old('class') == 12 ? 'selected' : '' }}>Class 12 (XII)</option>
                        </select>
                        @error('class')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Year -->
                    <div class="space-y-2">
                        <label for="year" class="block text-sm font-semibold text-gray-700">
                            <i class="fas fa-calendar text-green-600 mr-2"></i>Academic Year *
                        </label>
                        <select name="year" id="year" required
                                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                            <option value="">Select Year</option>
                            @for($i = date('Y'); $i >= date('Y') - 5; $i--)
                                <option value="{{ $i }}" {{ old('year', date('Y')) == $i ? 'selected' : '' }}>{{ $i }}</option>
                            @endfor
                        </select>
                        @error('year')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Total Marks -->
                    <div class="space-y-2">
                        <label for="total_marks" class="block text-sm font-semibold text-gray-700">
                            <i class="fas fa-star text-green-600 mr-2"></i>Total Marks *
                        </label>
                        <input type="number" step="0.01" name="total_marks" id="total_marks" value="{{ old('total_marks') }}" required
                               placeholder="Enter total marks"
                               class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                        @error('total_marks')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Grade -->
                    <div class="space-y-2">
                        <label for="grade" class="block text-sm font-semibold text-gray-700">
                            <i class="fas fa-award text-green-600 mr-2"></i>Grade *
                        </label>
                        <select name="grade" id="grade" required
                                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                            <option value="">Select Grade</option>
                            <option value="A+" {{ old('grade') == 'A+' ? 'selected' : '' }}>A+</option>
                            <option value="A" {{ old('grade') == 'A' ? 'selected' : '' }}>A</option>
                            <option value="A-" {{ old('grade') == 'A-' ? 'selected' : '' }}>A-</option>
                            <option value="B" {{ old('grade') == 'B' ? 'selected' : '' }}>B</option>
                            <option value="C" {{ old('grade') == 'C' ? 'selected' : '' }}>C</option>
                            <option value="D" {{ old('grade') == 'D' ? 'selected' : '' }}>D</option>
                            <option value="F" {{ old('grade') == 'F' ? 'selected' : '' }}>F</option>
                        </select>
                        @error('grade')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Remarks -->
                    <div class="md:col-span-2 space-y-2">
                        <label for="remarks" class="block text-sm font-semibold text-gray-700">
                            <i class="fas fa-comment text-green-600 mr-2"></i>Remarks
                        </label>
                        <textarea name="remarks" id="remarks" rows="4"
                                  placeholder="Enter any additional remarks (optional)"
                                  class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition resize-none">{{ old('remarks') }}</textarea>
                        @error('remarks')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row items-center justify-between mt-8 pt-6 border-t border-gray-200 gap-4">
                    <a href="{{ route('results.index') }}" 
                       class="w-full sm:w-auto inline-flex items-center justify-center px-6 py-3 bg-gray-500 hover:bg-gray-600 text-white font-semibold rounded-lg transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>Cancel
                    </a>
                    <button type="submit" 
                            class="w-full sm:w-auto inline-flex items-center justify-center px-8 py-3 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all">
                        <i class="fas fa-save mr-2"></i>Save Result
                    </button>
                </div>
            </form>
        </div>

        <!-- Help Text -->
        <div class="mt-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg">
            <div class="flex items-start">
                <i class="fas fa-lightbulb text-green-600 mt-1 mr-3"></i>
                <div>
                    <p class="text-sm text-green-800 font-medium">Tips</p>
                    <p class="text-sm text-green-700 mt-1">You can link this result to an existing student or enter student details manually.</p>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
