<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-2xl text-gray-800 flex items-center">
            <i class="fas fa-file-excel mr-3 text-green-600"></i>Import Results from Excel
        </h2>
    </x-slot>

    <div class="max-w-4xl mx-auto space-y-6">
        <!-- Upload Form Card -->
        <div class="bg-white overflow-hidden shadow-xl rounded-2xl">
            <div class="bg-gradient-to-r from-green-600 to-green-700 px-8 py-6">
                <h3 class="text-xl font-bold text-white flex items-center">
                    <i class="fas fa-upload mr-3"></i>Upload Excel File
                </h3>
                <p class="text-green-100 text-sm mt-1">Upload an Excel file containing student results</p>
            </div>

            <form action="{{ route('results.import') }}" method="POST" enctype="multipart/form-data" class="p-8">
                @csrf

                <div class="mb-8">
                    <label for="file" class="block text-sm font-semibold text-gray-700 mb-3">
                        <i class="fas fa-file-upload text-green-600 mr-2"></i>Select Excel File *
                    </label>
                    <input type="file" name="file" id="file" accept=".xlsx,.xls,.csv" required
                           class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                    <p class="mt-2 text-sm text-gray-500 flex items-center">
                        <i class="fas fa-info-circle text-blue-600 mr-2"></i>
                        Supported formats: .xlsx, .xls, .csv | Maximum file size: 2MB
                    </p>
                </div>

                <!-- Info Boxes -->
                <div class="space-y-4 mb-8">
                    <!-- Format Info -->
                    <div class="bg-blue-50 border-l-4 border-blue-500 p-5 rounded-r-lg">
                        <div class="flex items-start">
                            <i class="fas fa-info-circle text-blue-600 text-xl mt-1 mr-3"></i>
                            <div>
                                <h4 class="text-sm font-bold text-blue-800 mb-2">Excel File Format</h4>
                                <p class="text-sm text-blue-700 mb-3">Your Excel file should contain the following columns (in this order):</p>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
                                    <div class="flex items-center text-sm text-blue-700">
                                        <i class="fas fa-check-circle text-blue-600 mr-2"></i>
                                        <strong>roll</strong> - Student's roll number
                                    </div>
                                    <div class="flex items-center text-sm text-blue-700">
                                        <i class="fas fa-check-circle text-blue-600 mr-2"></i>
                                        <strong>class</strong> - Student's class (6-12)
                                    </div>
                                    <div class="flex items-center text-sm text-blue-700">
                                        <i class="fas fa-check-circle text-blue-600 mr-2"></i>
                                        <strong>year</strong> - Academic year
                                    </div>
                                    <div class="flex items-center text-sm text-blue-700">
                                        <i class="fas fa-check-circle text-blue-600 mr-2"></i>
                                        <strong>student_name</strong> - Student's full name
                                    </div>
                                    <div class="flex items-center text-sm text-blue-700">
                                        <i class="fas fa-check-circle text-blue-600 mr-2"></i>
                                        <strong>total_marks</strong> - Total marks
                                    </div>
                                    <div class="flex items-center text-sm text-blue-700">
                                        <i class="fas fa-check-circle text-blue-600 mr-2"></i>
                                        <strong>grade</strong> - Grade (optional)
                                    </div>
                                    <div class="flex items-center text-sm text-blue-700 md:col-span-2">
                                        <i class="fas fa-check-circle text-blue-600 mr-2"></i>
                                        <strong>remarks</strong> - Any remarks (optional)
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Warning Info -->
                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-5 rounded-r-lg">
                        <div class="flex items-start">
                            <i class="fas fa-exclamation-triangle text-yellow-600 text-xl mt-1 mr-3"></i>
                            <div>
                                <p class="text-sm text-yellow-800 font-bold">Important Notes:</p>
                                <ul class="text-sm text-yellow-700 mt-2 list-disc list-inside space-y-1">
                                    <li>The first row should contain column headers</li>
                                    <li>All required fields must be properly filled</li>
                                    <li>Ensure there are no empty rows in between data</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row items-center justify-between pt-6 border-t border-gray-200 gap-4">
                    <a href="{{ route('results.index') }}" 
                       class="w-full sm:w-auto inline-flex items-center justify-center px-6 py-3 bg-gray-500 hover:bg-gray-600 text-white font-semibold rounded-lg transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>Cancel
                    </a>
                    <button type="submit" 
                            class="w-full sm:w-auto inline-flex items-center justify-center px-8 py-3 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all">
                        <i class="fas fa-upload mr-2"></i>Upload & Import
                    </button>
                </div>
            </form>
        </div>

        <!-- Sample Excel Template -->
        <div class="bg-white overflow-hidden shadow-xl rounded-2xl">
            <div class="bg-gradient-to-r from-gray-700 to-gray-800 px-8 py-4">
                <h3 class="text-lg font-bold text-white flex items-center">
                    <i class="fas fa-table mr-3"></i>Sample Data Template
                </h3>
            </div>
            <div class="p-6 overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 text-sm border border-gray-300">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-bold text-gray-700 uppercase border-r border-gray-300">roll</th>
                            <th class="px-4 py-3 text-left text-xs font-bold text-gray-700 uppercase border-r border-gray-300">class</th>
                            <th class="px-4 py-3 text-left text-xs font-bold text-gray-700 uppercase border-r border-gray-300">year</th>
                            <th class="px-4 py-3 text-left text-xs font-bold text-gray-700 uppercase border-r border-gray-300">student_name</th>
                            <th class="px-4 py-3 text-left text-xs font-bold text-gray-700 uppercase border-r border-gray-300">total_marks</th>
                            <th class="px-4 py-3 text-left text-xs font-bold text-gray-700 uppercase border-r border-gray-300">grade</th>
                            <th class="px-4 py-3 text-left text-xs font-bold text-gray-700 uppercase">remarks</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 border-r border-gray-200">101</td>
                            <td class="px-4 py-3 border-r border-gray-200">10</td>
                            <td class="px-4 py-3 border-r border-gray-200">2024</td>
                            <td class="px-4 py-3 border-r border-gray-200">John Doe</td>
                            <td class="px-4 py-3 border-r border-gray-200">850</td>
                            <td class="px-4 py-3 border-r border-gray-200">A+</td>
                            <td class="px-4 py-3">Excellent performance</td>
                        </tr>
                        <tr class="hover:bg-gray-50 bg-gray-50">
                            <td class="px-4 py-3 border-r border-gray-200">102</td>
                            <td class="px-4 py-3 border-r border-gray-200">10</td>
                            <td class="px-4 py-3 border-r border-gray-200">2024</td>
                            <td class="px-4 py-3 border-r border-gray-200">Jane Smith</td>
                            <td class="px-4 py-3 border-r border-gray-200">720</td>
                            <td class="px-4 py-3 border-r border-gray-200">A</td>
                            <td class="px-4 py-3">Good result</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</x-app-layout>
