<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h2 class="font-bold text-2xl text-gray-800 flex items-center">
                    <i class="fas fa-chart-line mr-3 text-green-600"></i>Result Details
                </h2>
                <p class="text-sm text-gray-500 mt-1">Complete information about the result</p>
            </div>
            <div class="flex flex-wrap gap-2">
                <a href="{{ route('results.edit', $result) }}" 
                   class="inline-flex items-center px-5 py-2.5 bg-yellow-600 hover:bg-yellow-700 text-white font-semibold rounded-lg transition-colors shadow-md">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('results.index') }}" 
                   class="inline-flex items-center px-5 py-2.5 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors shadow-md">
                    <i class="fas fa-arrow-left mr-2"></i>Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="max-w-5xl mx-auto space-y-6">
        <!-- Result Card -->
        <div class="bg-white overflow-hidden shadow-xl rounded-2xl">
            <!-- Header -->
            <div class="bg-gradient-to-r from-green-600 to-green-700 px-8 py-8">
                <div class="flex flex-col md:flex-row items-center md:items-start gap-6">
                    <div class="flex-shrink-0">
                        <div class="w-24 h-24 rounded-full bg-white bg-opacity-20 backdrop-blur-sm flex items-center justify-center border-4 border-white">
                            <span class="text-4xl font-bold text-white">{{ substr($result->student_name, 0, 1) }}</span>
                        </div>
                    </div>
                    <div class="flex-1 text-center md:text-left">
                        <h3 class="text-3xl font-bold text-white mb-2">{{ $result->student_name }}</h3>
                        <div class="flex flex-wrap gap-3 justify-center md:justify-start">
                            <span class="px-4 py-2 bg-white bg-opacity-20 rounded-full text-white text-sm font-medium backdrop-blur-sm">
                                <i class="fas fa-id-card mr-2"></i>Roll: {{ $result->roll }}
                            </span>
                            <span class="px-4 py-2 bg-white bg-opacity-20 rounded-full text-white text-sm font-medium backdrop-blur-sm">
                                <i class="fas fa-school mr-2"></i>Class: {{ $result->class }}
                            </span>
                            <span class="px-4 py-2 bg-white bg-opacity-20 rounded-full text-white text-sm font-medium backdrop-blur-sm">
                                <i class="fas fa-calendar mr-2"></i>Year: {{ $result->year }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Result Information -->
            <div class="p-8">
                <h4 class="text-lg font-bold text-gray-800 mb-6 flex items-center">
                    <i class="fas fa-graduation-cap text-green-600 mr-3"></i>Academic Performance
                </h4>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Student Name</label>
                        <p class="text-lg text-gray-900 font-medium">{{ $result->student_name }}</p>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Roll Number</label>
                        <p class="text-lg text-gray-900 font-medium">
                            <span class="px-3 py-1 bg-green-100 text-green-800 rounded-lg">{{ $result->roll }}</span>
                        </p>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Class</label>
                        <p class="text-lg text-gray-900 font-medium">{{ $result->class }}</p>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Academic Year</label>
                        <p class="text-lg text-gray-900 font-medium">{{ $result->year }}</p>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Total Marks</label>
                        <p class="text-lg text-gray-900 font-medium">
                            <span class="px-4 py-2 bg-blue-100 text-blue-800 rounded-lg font-bold text-xl">{{ $result->total_marks }}</span>
                        </p>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Grade</label>
                        <p class="text-lg">
                            <span class="px-4 py-2 inline-flex text-xl font-bold rounded-lg 
                                {{ $result->grade == 'F' ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800' }}">
                                {{ $result->grade }}
                            </span>
                        </p>
                    </div>
                    @if($result->remarks)
                        <div class="md:col-span-2 space-y-2">
                            <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Remarks</label>
                            <div class="bg-gray-50 rounded-lg p-4 border-2 border-gray-200">
                                <p class="text-lg text-gray-900 font-medium">
                                    <i class="fas fa-comment text-green-600 mr-2"></i>{{ $result->remarks }}
                                </p>
                            </div>
                        </div>
                    @endif
                    @if($result->student)
                        <div class="md:col-span-2 space-y-2">
                            <label class="block text-sm font-semibold text-gray-500 uppercase tracking-wider">Linked Student Profile</label>
                            <a href="{{ route('students.show', $result->student) }}" 
                               class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg transition-colors">
                                <i class="fas fa-user-graduate mr-2"></i>View Student Profile
                                <i class="fas fa-external-link-alt ml-2 text-sm"></i>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="flex flex-wrap gap-4 justify-center">
            <a href="{{ route('results.edit', $result) }}" 
               class="inline-flex items-center px-8 py-3 bg-yellow-600 hover:bg-yellow-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all">
                <i class="fas fa-edit mr-2"></i>Edit Result
            </a>
            <form action="{{ route('results.destroy', $result) }}" method="POST" class="inline" 
                  onsubmit="return confirm('Are you sure you want to delete this result? This action cannot be undone.')">
                @csrf
                @method('DELETE')
                <button type="submit" 
                        class="inline-flex items-center px-8 py-3 bg-red-600 hover:bg-red-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all">
                    <i class="fas fa-trash mr-2"></i>Delete Result
                </button>
            </form>
            <a href="{{ route('results.index') }}" 
               class="inline-flex items-center px-8 py-3 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all">
                <i class="fas fa-list mr-2"></i>Back to List
            </a>
        </div>
    </div>
</x-app-layout>
