@extends('admin.layouts.app')

@section('title', 'System Settings')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Settings</li>
@endsection

@section('content')

<div class="container-fluid p-0">
    <div class="row">
        <!-- Settings Navigation (Sidebar/Tabs) -->
        <div class="col-12 col-lg-3 mb-4">
            <div class="card shadow-sm border-0 rounded-lg">
                <div class="list-group list-group-flush" id="settings-tab" role="tablist">
                    <a class="list-group-item list-group-item-action active fw-bold py-3" id="list-general-list" data-bs-toggle="list" href="#list-general" role="tab">
                        <i class="bi bi-gear me-2 text-primary"></i> General Settings
                    </a>
                    <a class="list-group-item list-group-item-action fw-bold py-3" id="list-social-list" data-bs-toggle="list" href="#list-social" role="tab">
                        <i class="bi bi-share me-2 text-info"></i> Social & Footer
                    </a>
                    <a class="list-group-item list-group-item-action fw-bold py-3" id="list-contact-list" data-bs-toggle="list" href="#list-contact" role="tab">
                        <i class="bi bi-telephone me-2 text-success"></i> Contact Info
                    </a>
                    <a class="list-group-item list-group-item-action fw-bold py-3" id="list-principal-list" data-bs-toggle="list" href="#list-principal" role="tab">
                        <i class="bi bi-person-workspace me-2 text-warning"></i> Principal Msg
                    </a>

                </div>
            </div>
            
            <div class="card shadow-sm border-0 rounded-lg mt-3 bg-primary text-white">
                <div class="card-body text-center p-4">
                    <h5 class="mb-3"><i class="bi bi-save2 fa-2x"></i></h5>
                    <p class="small text-white-50 mb-3">Don't forget to save your changes!</p>
                    <button type="submit" form="settingsForm" class="btn btn-light w-100 fw-bold text-primary shadow-sm">
                        Save All Changes
                    </button>
                    <p class="small text-white-50 mt-2 mb-0">Last updated: {{ now()->format('d M, h:i A') }}</p>
                </div>
            </div>
        </div>

        <!-- Settings Content -->
        <div class="col-12 col-lg-9">
            <form action="{{ route('settings.update') }}" method="POST" enctype="multipart/form-data" id="settingsForm">
                @csrf
                <div class="tab-content" id="nav-tabContent">
                    
                    <!-- General Settings -->
                    <div class="tab-pane fade show active" id="list-general" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-primary">Website Identity</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">College Name</label>
                                        <input type="text" name="college_name" value="{{ old('college_name', $values['college_name'] ?? '') }}" class="form-control form-control-lg" placeholder="e.g. Dhaka College">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Tagline / Slogan</label>
                                        <input type="text" name="tagline" value="{{ old('tagline', $values['tagline'] ?? '') }}" class="form-control form-control-lg" placeholder="e.g. Excellence in Education">
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Site Logo</label>
                                        <div class="input-group">
                                            <input type="file" name="site_logo" class="form-control" accept="image/*">
                                        </div>
                                        @if(!empty($values['site_logo']))
                                            <div class="mt-2 p-2 border rounded bg-light d-inline-block">
                                                <img src="{{ asset('storage/uploads/settings/' . basename($values['site_logo'])) }}" alt="Logo" height="40">
                                            </div>
                                        @endif
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Favicon</label>
                                        <div class="input-group">
                                            <input type="file" name="site_favicon" class="form-control" accept="image/*">
                                        </div>
                                         @if(!empty($values['site_favicon']))
                                            <div class="mt-2 p-2 border rounded bg-light d-inline-block">
                                                <img src="{{ asset('storage/uploads/settings/' . basename($values['site_favicon'])) }}" alt="Favicon" height="32">
                                            </div>
                                        @endif
                                    </div>
                                    
                                     <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Controller Signature (Result Sheet)</label>
                                        <div class="input-group">
                                            <input type="file" name="controller_examination_signature" class="form-control" accept="image/*">
                                        </div>
                                         @if(!empty($values['controller_examination_signature']))
                                            <div class="mt-2 p-2 border rounded bg-light d-inline-block">
                                                <img src="{{ asset('storage/uploads/settings/' . basename($values['controller_examination_signature'])) }}" alt="Signature" height="40">
                                            </div>
                                        @endif
                                    </div>

                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Meta Description (SEO)</label>
                                        <textarea name="description" rows="3" class="form-control" placeholder="Brief description for search engines...">{{ old('description', $values['description'] ?? '') }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Social & Footer -->
                    <div class="tab-pane fade" id="list-social" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-info">Social Media & Footer</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Footer About Text</label>
                                        <textarea name="footer_about" rows="3" class="form-control" placeholder="Short text about the college for the footer...">{{ old('footer_about', $values['footer_about'] ?? '') }}</textarea>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-facebook me-1"></i> Facebook URL</label>
                                        <input type="url" name="social_facebook" value="{{ old('social_facebook', $values['social_facebook'] ?? '') }}" class="form-control" placeholder="https://facebook.com/...">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-youtube me-1"></i> YouTube URL</label>
                                        <input type="url" name="social_youtube" value="{{ old('social_youtube', $values['social_youtube'] ?? '') }}" class="form-control" placeholder="https://youtube.com/...">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-twitter me-1"></i> Twitter / X URL</label>
                                        <input type="url" name="social_twitter" value="{{ old('social_twitter', $values['social_twitter'] ?? '') }}" class="form-control" placeholder="https://twitter.com/...">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-instagram me-1"></i> Instagram URL</label>
                                        <input type="url" name="social_instagram" value="{{ old('social_instagram', $values['social_instagram'] ?? '') }}" class="form-control" placeholder="https://instagram.com/...">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Info -->
                    <div class="tab-pane fade" id="list-contact" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-success">Contact Information</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Full Address</label>
                                        <textarea name="contact_full_address" rows="3" class="form-control" placeholder="Street Address, City, Postal Code">{{ old('contact_full_address', $values['contact_full_address'] ?? '') }}</textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Office Phone</label>
                                        <input type="text" name="contact_office_phone" value="{{ old('contact_office_phone', $values['contact_office_phone'] ?? '') }}" class="form-control">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Mobile / Hotline</label>
                                        <input type="text" name="contact_mobile_phone" value="{{ old('contact_mobile_phone', $values['contact_mobile_phone'] ?? '') }}" class="form-control">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Principal Email</label>
                                        <input type="email" name="contact_principal_email" value="{{ old('contact_principal_email', $values['contact_principal_email'] ?? '') }}" class="form-control">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">General / Info Email</label>
                                        <input type="email" name="contact_general_email" value="{{ old('contact_general_email', $values['contact_general_email'] ?? '') }}" class="form-control">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Google Maps Embed Code / URL</label>
                                        <textarea name="contact_map_url" rows="3" class="form-control" placeholder="<iframe src='...'></iframe> OR https://www.google.com/maps/embed?...">{{ old('contact_map_url', $values['contact_map_url'] ?? '') }}</textarea>
                                        <div class="form-text">You can paste the full &lt;iframe&gt; code from Google Maps, or just the URL inside the src attribute.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Principal Message Settings -->
                    <div class="tab-pane fade" id="list-principal" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-warning">Principal's Message Configuration</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-md-8">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold small text-muted">Principal Name</label>
                                            <input type="text" name="principal_name" value="{{ old('principal_name', $values['principal_name'] ?? '') }}" class="form-control form-control-lg" placeholder="Mr. Name">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label fw-bold small text-muted">Short Message (Home Page)</label>
                                            <textarea name="principal_message_short" rows="5" class="form-control" placeholder="Welcome message...">{{ old('principal_message_short', $values['principal_message_short'] ?? '') }}</textarea>
                                            <div class="form-text">This message will appear on the dashboard/home page.</div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold small text-muted">Principal Image</label>
                                        <div class="card bg-light border-0 text-center p-3 mb-2">
                                            @php
                                                $p_img = isset($values['principal_image']) ? asset('storage/'.$values['principal_image']) : 'https://via.placeholder.com/150';
                                            @endphp
                                            <img id="principal_preview" src="{{ $p_img }}" class="img-fluid rounded-circle shadow-sm mb-2" style="width: 150px; height: 150px; object-fit: cover;">
                                            <div class="small text-muted">Preview</div>
                                        </div>
                                        <input type="file" name="principal_image" class="form-control" accept="image/*" onchange="document.getElementById('principal_preview').src = window.URL.createObjectURL(this.files[0])">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Full Message</label>
                                        <textarea name="principal_message" rows="8" class="form-control">{{ old('principal_message', $values['principal_message'] ?? '') }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
    // Ensure last active tab is remembered if needed, or simple redirect back to index
</script>
@endpush
