@extends('admin.layouts.app')

@section('title', 'Import Students')

@section('content')
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-bold"><i class="bi bi-file-earmark-spreadsheet me-2 text-success"></i> Bulk Import
                        Students</h5>
                </div>
                <div class="card-body p-4">

                    <div class="alert alert-info d-flex align-items-baseline mb-3">
                        <i class="bi bi-info-circle-fill me-2 fs-5"></i>
                        <div>
                            <h6 class="fw-bold mb-1">Instructions</h6>
                            <ul class="mb-0 ps-3 small">
                                <li>Please use the <strong>CSV</strong> format for bulk import.</li>
                                <li>The first row should be the header row.</li>
                                <li>Required columns (17 total): <strong>Name, Reg No, Father Name, Mother Name, Class
                                        (11/12), Group, SSC Batch, Phone, Gender, Address, Subject 1-6 Codes, 4th Subject
                                        Code</strong>.</li>
                                <li>For <strong>Group</strong>, use: Science, Commerce, or Humanities.</li>
                                <li><strong>Roll numbers will be auto-generated</strong> sequentially.</li>
                                <li><strong>Subject Codes</strong>: Enter 6 mandatory subject codes (e.g., 101 for Bangla,
                                    107 for English).</li>
                                <li><strong>4th Subject (Optional)</strong>: Enter code in the last column.</li>
                            </ul>
                        </div>
                    </div>

                    <div class="alert alert-warning d-flex align-items-center mb-4 small">
                        <i class="bi bi-exclamation-triangle-fill me-2 fs-5"></i>
                        <div>
                            <strong>Duplicate Entry error?</strong> 
                            Old students conflict with the new system. 
                            <a href="{{ route('students.fix-rolls') }}" class="btn btn-sm btn-warning ms-2 fw-bold italic">Fix Existing Rolls</a>
                        </div>
                    </div>

                    <form action="{{ route('students.upload') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="mb-4">
                            <label for="file" class="form-label fw-bold">Select CSV File</label>
                            <input type="file" class="form-control form-control-lg" id="file" name="file"
                                accept=".csv, .txt" required>
                            <div class="form-text">Max file size: 2MB.</div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary px-4 fw-bold">
                                <i class="bi bi-cloud-upload me-2"></i> Upload & Import
                            </button>
                            <a href="{{ route('students.import-sample') }}" class="btn btn-outline-secondary fw-bold">
                                <i class="bi bi-download me-2"></i> Download Sample CSV
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection