@extends('admin.layouts.app')

@section('title', 'Students Management')

@section('actions')
    <a href="{{ route('students.import') }}" class="btn btn-success me-2">
        <i class="bi bi-file-earmark-spreadsheet me-1"></i> Import Students
    </a>
    <a href="{{ route('students.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i> Add New Student
    </a>
@endsection

@section('content')

    <!-- Filter Bar -->
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-body">
            <form action="{{ route('students.index') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label small text-muted">Search Query</label>
                    <div class="input-group">
                        <span class="input-group-text bg-light border-end-0"><i class="bi bi-search text-muted"></i></span>
                        <input type="text" name="search" class="form-control border-start-0 ps-0"
                            placeholder="Name, Roll, Reg No..." value="{{ request('search') }}">
                    </div>
                </div>

                <div class="col-md-2">
                    <label class="form-label small text-muted">HSC Batch</label>
                    <select name="hsc_batch" class="form-select">
                        <option value="">All Batches</option>
                        @foreach($hsc_batches as $batchYear)
                            <option value="{{ $batchYear }}" {{ request('hsc_batch') == $batchYear ? 'selected' : '' }}>
                                {{ $batchYear }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label small text-muted">Group</label>
                    <select name="group_code" class="form-select">
                        <option value="">All Groups</option>
                        <option value="3" {{ request('group_code') == '3' ? 'selected' : '' }}>Science</option>
                        <option value="2" {{ request('group_code') == '2' ? 'selected' : '' }}>Commerce</option>
                        <option value="1" {{ request('group_code') == '1' ? 'selected' : '' }}>Humanities</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label small text-muted">Status</label>
                    <select name="status" class="form-select">
                        <option value="active" {{ request('status', 'active') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="archived" {{ request('status') == 'archived' ? 'selected' : '' }}>Archived (Deleted)
                        </option>
                    </select>
                </div>

                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100 me-2">
                        <i class="bi bi-funnel me-1"></i> Filter
                    </button>
                    <a href="{{ route('students.index') }}" class="btn btn-light border" title="Reset">
                        <i class="bi bi-arrow-counterclockwise"></i>
                    </a>
                </div>
            </form>
        </div>
    </div>
    </div>

    @if(isset($currentBatch))
        <div class="card border-0 shadow-sm mb-4 bg-primary text-white overflow-hidden position-relative">
            <div class="card-body p-4 position-relative z-1">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1 fw-bold text-white">{{ $currentBatch->name }}</h4>
                        <p class="mb-0 opacity-75">
                            <i class="bi bi-calendar-range me-1"></i>
                            {{ $currentBatch->session ? 'Session: ' . $currentBatch->session : 'No Session Set' }}
                        </p>
                    </div>
                    <a href="{{ route('students.index') }}" class="btn btn-light text-primary fw-bold shadow-sm">
                        <i class="bi bi-arrow-left me-1"></i> Back to Folders
                    </a>
                </div>
            </div>
            <!-- Decorative bg circle -->
            <div class="position-absolute top-0 end-0 p-3 opacity-10">
                <i class="bi bi-folder-fill display-1 text-white"></i>
            </div>
        </div>
    @endif

    <!-- Summary Badges (Optional) -->
    <div class="mb-3 d-flex gap-3 overflow-auto pb-2">
        <span
            class="badge rounded-pill bg-primary bg-opacity-10 text-primary border border-primary border-opacity-25 px-3 py-2">
            Total: {{ $students->total() }}
        </span>
        {{-- Can add more summary badges like 'Science: 50', 'Active: 40' if calculated --}}
    </div>

    <!-- Desktop Table -->
    <div class="card shadow-sm border-0 d-none d-md-block">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr>
                        <th class="ps-4">Student Info</th>
                        <th>Academic</th>
                        <th>Roll / Reg</th>
                        <th>Status</th>
                        <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($students as $student)
                        <tr>
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    @if($student->photo)
                                        <img src="{{ asset('storage/' . $student->photo) }}" class="rounded-circle me-3" width="40"
                                            height="40" style="object-fit: cover;">
                                    @else
                                        <div class="avatar-sm rounded-circle bg-light border d-flex align-items-center justify-content-center me-3"
                                            style="width: 40px; height: 40px;">
                                            <span class="text-muted fw-bold">{{ substr($student->name, 0, 1) }}</span>
                                        </div>
                                    @endif
                                    <div>
                                        <div class="fw-bold text-dark">{{ $student->name }}</div>
                                        <div class="small text-muted">{{ $student->phone ?? 'N/A' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="small">
                                    <span class="d-block text-dark fw-semibold">{{ $student->group }}</span>
                                    <span class="d-block text-muted">Class {{ $student->class }} | Batch
                                        {{ $student->ssc_batch }}</span>
                                    @if($student->version)
                                        <span
                                            class="badge bg-light text-dark border mt-1">{{ $student->version->version_name }}</span>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <div class="small">
                                    <span class="d-block">Roll: <span
                                            class="font-monospace fw-bold">{{ $student->class_roll }}</span></span>
                                    <span class="d-block text-muted">Reg: {{ $student->ssc_reg_no }}</span>
                                </div>
                            </td>
                            <td>
                                @if($student->trashed())
                                    <span class="badge bg-danger-subtle text-danger">Archived</span>
                                @elseif($student->status == 'active')
                                    <span class="badge bg-success-subtle text-success">Active</span>
                                @else
                                    <span class="badge bg-secondary-subtle text-secondary">{{ ucfirst($student->status) }}</span>
                                @endif
                            </td>
                            <td class="text-end pe-4">
                                <div class="d-flex justify-content-end gap-2">
                                    @if(!$student->trashed())
                                        <a href="{{ route('students.show', $student) }}" class="btn btn-sm btn-light border"
                                            title="View Details">
                                            <i class="bi bi-eye text-primary"></i>
                                        </a>
                                        <a href="{{ route('students.edit', $student) }}" class="btn btn-sm btn-light border"
                                            title="Edit">
                                            <i class="bi bi-pencil text-warning"></i>
                                        </a>
                                        <form action="{{ route('students.destroy', $student) }}" method="POST"
                                            onsubmit="return confirm('Are you sure you want to permanently DELETE this student? This action cannot be undone.');"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-light border" title="Delete">
                                                <i class="bi bi-trash text-danger"></i>
                                            </button>
                                        </form>
                                    @else
                                        <form action="{{ route('students.restore', $student->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit"
                                                class="btn btn-sm btn-success-subtle text-success border border-success-subtle"
                                                title="Restore">
                                                <i class="bi bi-arrow-counterclockwise me-1"></i> Restore
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-5">
                                <img src="https://cdni.iconscout.com/illustration/premium/thumb/empty-state-2130362-1800926.png"
                                    alt="Empty" style="width: 200px; opacity: 0.5;">
                                <p class="text-muted mt-3">No students found.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Mobile Card View -->
    <div class="d-block d-md-none">
        @forelse($students as $student)
            <div class="card shadow-sm border-0 mb-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="d-flex align-items-center">
                            @if($student->photo)
                                <img src="{{ asset('storage/' . $student->photo) }}" class="rounded-circle me-3" width="40"
                                    height="40" style="object-fit: cover;">
                            @else
                                <div class="avatar-sm rounded-circle bg-light border d-flex align-items-center justify-content-center me-3"
                                    style="width: 40px; height: 40px;">
                                    <span class="text-muted fw-bold">{{ substr($student->name, 0, 1) }}</span>
                                </div>
                            @endif
                            <div>
                                <h6 class="card-title fw-bold mb-0 text-dark">{{ $student->name }}</h6>
                                <span class="small text-muted">Roll: {{ $student->class_roll }}</span>
                            </div>
                        </div>
                        @if($student->trashed())
                            <span class="badge bg-danger-subtle text-danger">Archived</span>
                        @elseif($student->status == 'active')
                            <span class="badge bg-success-subtle text-success">Active</span>
                        @else
                            <span class="badge bg-secondary-subtle text-secondary">{{ ucfirst($student->status) }}</span>
                        @endif
                    </div>

                    <div class="row g-2 mb-3">
                        <div class="col-6">
                            <small class="text-muted d-block" style="font-size: 10px;">GROUP</small>
                            <span class="fw-semibold text-dark small">{{ $student->group }}</span>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block" style="font-size: 10px;">BATCH</small>
                            <span class="fw-semibold text-dark small">{{ $student->ssc_batch }}</span>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        @if(!$student->trashed())
                            <a href="{{ route('students.show', $student) }}" class="btn btn-sm btn-light flex-fill"><i
                                    class="bi bi-eye"></i></a>
                            <a href="{{ route('students.edit', $student) }}" class="btn btn-sm btn-light flex-fill"><i
                                    class="bi bi-pencil"></i></a>
                            <form action="{{ route('students.destroy', $student) }}" method="POST" class="d-inline flex-fill"
                                onsubmit="return confirm('Permanent Delete?');">
                                @csrf @method('DELETE')
                                <button class="btn btn-sm btn-light-danger w-100 text-danger border"><i
                                        class="bi bi-trash"></i></button>
                            </form>
                        @else
                            <form action="{{ route('students.restore', $student->id) }}" method="POST" class="w-100">
                                @csrf
                                <button class="btn btn-sm btn-success w-100"><i class="bi bi-arrow-counterclockwise me-1"></i>
                                    Restore</button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>
        @empty
            <div class="text-center py-5">
                <p class="text-muted">No students found.</p>
            </div>
        @endforelse
    </div>

    <div class="mt-4">
        {{ $students->links('pagination::bootstrap-5') }}
    </div>

@endsection