@extends('admin.layouts.app')

@section('title', 'Student Profile: ' . $student->name)

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('students.index') }}">Students</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ $student->class_roll }}</li>
@endsection

@section('actions')
    @if(!$student->trashed())
        <a href="{{ route('students.edit', $student) }}" class="btn btn-warning text-white me-2">
            <i class="bi bi-pencil-square me-1"></i> Edit Profile
        </a>
    @endif
@endsection

@section('content')

<div class="row g-4">
    <!-- Profile Card Sidebar -->
    <div class="col-12 col-md-4 col-lg-3">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body text-center pt-5">
                <div class="mb-4 position-relative d-inline-block">
                     @if($student->photo)
                        <img src="{{ asset('storage/'.$student->photo) }}" class="rounded-circle shadow-sm p-1 bg-white" width="120" height="120" style="object-fit: cover;">
                    @else
                        <div class="avatar-xl rounded-circle bg-light border d-flex align-items-center justify-content-center mx-auto shadow-sm" style="width: 120px; height: 120px;">
                            <span class="fs-1 text-muted fw-bold">{{ substr($student->name, 0, 1) }}</span>
                        </div>
                    @endif
                    <span class="position-absolute bottom-0 end-0 p-2 bg-success border border-white rounded-circle indicator"></span>
                </div>
                
                <h5 class="fw-bold mb-1">{{ $student->name }}</h5>
                <p class="text-muted small mb-3">{{ $student->ssc_reg_no }}</p>

                <div class="d-flex justify-content-center gap-2 mb-4">
                    <span class="badge bg-light text-dark border">{{ $student->group }}</span>
                    <span class="badge bg-light text-dark border">Class {{ $student->class }}</span>
                </div>

                <hr>

                <div class="text-start">
                    <div class="mb-3">
                         <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">PERSONAL INFO</label>
                         <div class="mb-1"><strong class="me-1">Father:</strong> {{ $student->father_name ?? 'N/A' }}</div>
                         <div class="mb-1"><strong class="me-1">Mother:</strong> {{ $student->mother_name ?? 'N/A' }}</div>
                         <div class="mb-1"><strong class="me-1">DOB:</strong> {{ $student->date_of_birth ? date('d M Y', strtotime($student->date_of_birth)) : 'N/A' }}</div>
                         <div class="mb-1"><strong class="me-1">Gender:</strong> {{ $student->gender ?? 'N/A' }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">CLASS ROLL</label>
                        <span class="fw-bold fs-5 text-primary font-monospace">{{ $student->class_roll }}</span>
                    </div>
                    <div class="mb-3">
                         <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">CONTACT</label>
                         <div><i class="bi bi-telephone me-2 text-muted"></i> {{ $student->phone ?? 'N/A' }}</div>
                         <div><i class="bi bi-envelope me-2 text-muted"></i> {{ $student->email ?? 'N/A' }}</div>
                    </div>
                    <div>
                         <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">ADDRESS</label>
                         <p class="small text-muted mb-0">{{ $student->address ?? 'N/A' }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="col-12 col-md-8 col-lg-9">
        
        <!-- Academic Summary -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold">Academic Overview</h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">SSC Batch</small>
                             <h6 class="fw-bold mb-0">{{ $student->ssc_batch }}</h6>
                         </div>
                    </div>
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">HSC Batch</small>
                             <h6 class="fw-bold mb-0">{{ $student->hsc_batch }}</h6>
                         </div>
                    </div>
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">Status</small>
                             <h6 class="fw-bold mb-0 {{ $student->status == 'active' ? 'text-success' : 'text-danger' }}">{{ ucfirst($student->status) }}</h6>
                         </div>
                    </div>
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">Joined</small>
                             <h6 class="fw-bold mb-0">{{ $student->created_at->format('M Y') }}</h6>
                         </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Subjects -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">Assigned Subjects</h6>
                <span class="badge bg-primary rounded-pill">{{ $student->subjects->count() }}</span>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="bg-light">
                        <tr>
                            <th class="ps-4">Code</th>
                            <th>Subject Name</th>
                            <th>Type</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($student->subjects as $subject)
                            <tr>
                                <td class="ps-4 fw-mono text-muted">{{ $subject->code }}</td>
                                <td class="fw-semibold">{{ $subject->name }}</td>
                                <td>
                                    @if($subject->pivot->is_optional)
                                        <span class="badge bg-warning-subtle text-warning-emphasis">4th Subject</span>
                                    @else
                                        <span class="badge bg-secondary-subtle text-secondary-emphasis">Mandatory</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="3" class="text-center py-4 text-muted">No subjects assigned.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Audit Log -->
        <div class="card shadow-sm border-0">
             <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold text-muted small uppercase">Recent Activity</h6>
            </div>
            <div class="list-group list-group-flush">
                @forelse($logs as $log)
                    <div class="list-group-item px-4 py-3 border-bottom-0">
                        <div class="d-flex justify-content-between">
                            <div>
                                <span class="badge bg-light text-dark border me-2">{{ strtoupper($log->action) }}</span>
                                <span class="small text-muted">by System/Admin</span>
                            </div>
                            <small class="text-muted">{{ $log->created_at->diffForHumans() }}</small>
                        </div>
                    </div>
                @empty
                    <div class="p-4 text-center text-muted small">No recent activity recorded.</div>
                @endforelse
            </div>
        </div>

    </div>
</div>

@endsection
