@extends('admin.layouts.app')

@section('title', 'Create Subject')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('subjects.index') }}">Subjects</a></li>
    <li class="breadcrumb-item active" aria-current="page">Create New</li>
@endsection

@section('content')

<div class="row justify-content-center">
    <div class="col-md-9">
        <form action="{{ route('subjects.store') }}" method="POST">
            @csrf
            
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-bold">Step 1: Subject Identity</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label class="form-label fw-bold">Subject Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" placeholder="e.g. Physics" required value="{{ old('name') }}">
                            <div class="form-text">Do not include "1st Paper" or "2nd Paper" in the name.</div>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Short Name</label>
                            <input type="text" name="short_name" class="form-control" placeholder="e.g. PHY" value="{{ old('short_name') }}">
                        </div>
                        <div class="col-12">
                             <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="is_4th_subject_eligible" id="is4th" checked>
                                <label class="form-check-label" for="is4th">Eligible as 4th Subject?</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="mb-0 fw-bold">Step 2: Paper Configuration</h6>
                    <div class="btn-group" role="group">
                        <input type="radio" class="btn-check" name="paper_type" id="type_single" value="single" checked onchange="togglePapers()">
                        <label class="btn btn-outline-primary btn-sm" for="type_single">Single Paper</label>

                        <input type="radio" class="btn-check" name="paper_type" id="type_double" value="double" onchange="togglePapers()">
                        <label class="btn btn-outline-primary btn-sm" for="type_double">Two Papers</label>
                    </div>
                </div>
                <div class="card-body">
                    
                    <!-- Paper 1 Config -->
                    <div class="border rounded p-3 mb-3 bg-light">
                        <h6 class="fw-bold text-primary mb-3" id="p1_title">Paper Configuration</h6>
                        <div class="row g-3">
                             <div class="col-md-4">
                                <label class="form-label">Paper Code <span class="text-danger">*</span></label>
                                <input type="number" name="paper_1_code" id="p1_code" class="form-control" required placeholder="e.g. 101" oninput="autoSuggestP2()">
                                <div id="p1_feedback" class="invalid-feedback">Code is taken!</div>
                             </div>
                            <div class="col-md-8 d-flex align-items-center gap-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="p1_has_cq" id="p1_has_cq" value="1" checked>
                                    <label class="form-check-label" for="p1_has_cq">CQ (Theory)</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="p1_has_mcq" id="p1_has_mcq" value="1" checked>
                                    <label class="form-check-label" for="p1_has_mcq">MCQ</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="p1_has_practical" id="p1_has_practical" value="1">
                                    <label class="form-check-label" for="p1_has_practical">Practical</label>
                                </div>
                             </div>
                        </div>
                    </div>

                    <!-- Paper 2 Config (Hidden by default) -->
                    <div id="paper_2_section" class="border rounded p-3 mb-3 bg-light d-none">
                        <h6 class="fw-bold text-primary mb-3">2nd Paper Configuration</h6>
                        <div class="row g-3">
                             <div class="col-md-4">
                                <label class="form-label">2nd Paper Code <span class="text-danger">*</span></label>
                                <input type="number" name="paper_2_code" id="p2_code" class="form-control" placeholder="e.g. 102">
                                <div id="p2_hint" class="form-text text-success"></div>
                                <div id="p2_feedback" class="invalid-feedback">Code is taken!</div>
                             </div>
                             <div class="col-md-8 d-flex align-items-center gap-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="p2_has_cq" id="p2_has_cq" value="1" checked>
                                    <label class="form-check-label" for="p2_has_cq">CQ (Theory)</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="p2_has_mcq" id="p2_has_mcq" value="1" checked>
                                    <label class="form-check-label" for="p2_has_mcq">MCQ</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="p2_has_practical" id="p2_has_practical" value="1">
                                    <label class="form-check-label" for="p2_has_practical">Practical</label>
                                </div>
                             </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <a href="{{ route('subjects.index') }}" class="btn btn-light border">Cancel</a>
                <button type="submit" class="btn btn-primary fw-bold px-4">Create Subject</button>
            </div>
        </form>
    </div>
</div>

@endsection

@push('scripts')
<script>
    const p1Code = document.getElementById('p1_code');
    const p2Code = document.getElementById('p2_code');
    const p2Section = document.getElementById('paper_2_section');
    const p1Title = document.getElementById('p1_title');
    const typeDouble = document.getElementById('type_double');
    const p2Hint = document.getElementById('p2_hint');

    function togglePapers() {
        if(typeDouble.checked) {
            p2Section.classList.remove('d-none');
            p1Title.innerText = "1st Paper Configuration";
            // Trigger auto suggest if P1 is filled
            if(p1Code.value) autoSuggestP2();
        } else {
            p2Section.classList.add('d-none');
            p1Title.innerText = "Paper Configuration";
        }
    }

    async function checkCode(code, element, feedbackId) {
        if(!code) return;
        try {
            const res = await fetch(`{{ route('api.subjects.check-code') }}?code=${code}`);
            const data = await res.json();
            if(data.exists) {
                element.classList.add('is-invalid');
                document.getElementById(feedbackId).innerText = "Code " + code + " is already taken!";
            } else {
                element.classList.remove('is-invalid');
            }
        } catch(e) { console.error(e); }
    }

    // Auto Suggest Logic
    function autoSuggestP2() {
        if(!typeDouble.checked) return;
        
        const val = parseInt(p1Code.value);
        if(!isNaN(val)) {
            const next = val + 1;
            p2Code.value = next;
            p2Hint.innerText = "Auto-suggested: " + next;
            checkCode(next, p2Code, 'p2_feedback');
        }
    }

    // Debounce check for P1
    p1Code.addEventListener('blur', function() {
        checkCode(this.value, this, 'p1_feedback');
    });

    // Manual P2 override check
    p2Code.addEventListener('blur', function() {
        checkCode(this.value, this, 'p2_feedback');
    });

</script>
@endpush
