@extends('admin.layouts.app')

@section('title', 'Edit Subject')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('subjects.index') }}">Subjects</a></li>
    <li class="breadcrumb-item"><a href="{{ route('subjects.show', $subject->id) }}">{{ $subject->name }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">Edit</li>
@endsection

@section('content')

<div class="row justify-content-center">
    <div class="col-md-9">
        <form action="{{ route('subjects.update', $subject->id) }}" method="POST">
            @csrf
            @method('PUT')
            
            <!-- Identity -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-bold text-primary">Subject Identity</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label class="form-label fw-bold">Subject Name</label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $subject->name) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Short Name</label>
                            <input type="text" name="short_name" class="form-control" value="{{ old('short_name', $subject->short_name) }}">
                        </div>
                        <div class="col-12">
                             <div class="form-check">
                                <input type="hidden" name="is_4th_subject_eligible" value="0">
                                <input class="form-check-input" type="checkbox" value="1" name="is_4th_subject_eligible" id="is4th" {{ $subject->is_4th_subject_eligible ? 'checked' : '' }}>
                                <label class="form-check-label" for="is4th">Eligible as 4th Subject?</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Papers -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-bold text-primary">Paper Configuration</h6>
                </div>
                <div class="card-body">
                    <div class="alert alert-info py-2 small">
                        <i class="bi bi-info-circle me-1"></i> You are editing the existing <strong>{{ $subject->has_multiple_papers ? 'Two Papers' : 'Single Paper' }}</strong> configuration. To change the structure (Single to Double), please delete and recreate or contact support.
                    </div>

                    @foreach($subject->papers as $paper)
                    <div class="border rounded p-3 mb-3 bg-light">
                        <div class="d-flex justify-content-between mb-2">
                             <h6 class="fw-bold text-dark">
                                @if($paper->paper_type === 'first') 1st Paper
                                @elseif($paper->paper_type === 'second') 2nd Paper
                                @else Single Paper
                                @endif
                             </h6>
                        </div>
                        
                        <div class="row g-3">
                             <div class="col-md-4">
                                <label class="form-label small text-muted text-uppercase fw-bold">Paper Code</label>
                                <input type="text" name="papers[{{ $paper->id }}][code]" class="form-control" value="{{ old("papers.{$paper->id}.code", $paper->paper_code) }}" required>
                             </div>
                             
                             <div class="col-md-8 d-flex align-items-center gap-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" value="1" name="papers[{{ $paper->id }}][has_cq]" id="paper_{{ $paper->id }}_has_cq" {{ $paper->has_cq ? 'checked' : '' }}>
                                    <label class="form-check-label" for="paper_{{ $paper->id }}_has_cq">CQ</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" value="1" name="papers[{{ $paper->id }}][has_mcq]" id="paper_{{ $paper->id }}_has_mcq" {{ $paper->has_mcq ? 'checked' : '' }}>
                                    <label class="form-check-label" for="paper_{{ $paper->id }}_has_mcq">MCQ</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" value="1" name="papers[{{ $paper->id }}][has_practical]" id="paper_{{ $paper->id }}_has_practical" {{ $paper->has_practical ? 'checked' : '' }}>
                                    <label class="form-check-label" for="paper_{{ $paper->id }}_has_practical">Practical</label>
                                </div>
                             </div>
                        </div>
                    </div>
                    @endforeach

                </div>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <a href="{{ route('subjects.show', $subject->id) }}" class="btn btn-light border">Cancel</a>
                <button type="submit" class="btn btn-primary fw-bold px-4">Update Subject</button>
            </div>
        </form>
    </div>
</div>

@endsection
