@extends('admin.layouts.app')

@section('title', 'Subject Details')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('subjects.index') }}">Subjects</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ $subject->name }}</li>
@endsection

@section('content')

<div class="row justify-content-center">
    <div class="col-md-10">
        
        <!-- Identity Card -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold text-primary">{{ $subject->name }}</h5>
                <div>
                   <a href="{{ route('subjects.edit', $subject->id) }}" class="btn btn-warning btn-sm fw-bold"><i class="bi bi-pencil-square me-1"></i> Edit</a>
                   <a href="{{ route('subjects.index') }}" class="btn btn-light btn-sm border"><i class="bi bi-arrow-left me-1"></i> Back</a>
                </div>
            </div>
            <div class="card-body">
                <div class="row g-4">
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">Code</label>
                        <div class="fs-4 font-monospace fw-bold">{{ $subject->code }}</div>
                    </div>
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">Short Name</label>
                        <div class="fs-5">{{ $subject->short_name ?? '-' }}</div>
                    </div>
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">Configuration</label>
                        <div>
                            @if($subject->has_multiple_papers)
                                <span class="badge bg-primary">Two Papers</span>
                            @else
                                <span class="badge bg-secondary">Single Paper</span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">4th Subject</label>
                        <div>
                            @if($subject->is_4th_subject_eligible)
                                <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i> Eligible</span>
                            @else
                                <span class="badge bg-light text-muted border">Not Eligible</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Papers List -->
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light py-2">
                <h6 class="mb-0 fw-bold text-muted">Paper Configuration</h6>
            </div>
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="bg-white text-muted small text-uppercase">
                        <tr>
                            <th class="ps-4">Paper Type</th>
                            <th>Paper Code</th>
                            <th>Marks Distribution</th>
                            <th>Full Marks</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($subject->papers as $paper)
                        <tr>
                            <td class="ps-4 fw-bold text-primary">
                                @if($paper->paper_type === 'first') 1st Paper
                                @elseif($paper->paper_type === 'second') 2nd Paper
                                @else Single Paper
                                @endif
                            </td>
                            <td><span class="badge bg-white text-dark border font-monospace">{{ $paper->paper_code }}</span></td>
                            <td>
                                <div class="d-flex gap-2">
                                    @if($paper->has_cq) <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25">CQ</span> @endif
                                    @if($paper->has_mcq) <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25">MCQ</span> @endif
                                    @if($paper->has_practical) <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">Practical</span> @endif
                                </div>
                            </td>
                            <td>{{ $paper->full_marks }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>

@endsection
