@extends('admin.layouts.app')

@section('title', 'Edit Teacher: ' . $teacher->name)

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('teachers.index') }}">Teachers</a></li>
    <li class="breadcrumb-item active" aria-current="page">Edit Teacher</li>
@endsection

@section('content')

<div class="row justify-content-center">
    <div class="col-12 col-xl-10">
        <form action="{{ route('teachers.update', $teacher) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 fw-bold"><i class="bi bi-pencil-square text-primary me-2"></i>Edit Teacher Profile</h5>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" id="is_active" name="is_active" value="1" {{ old('is_active', $teacher->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">Active Status</label>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-4">
                    <!-- Photo Preview & Upload -->
                    <div class="row mb-5 align-items-center">
                        <div class="col-md-3 text-center">
                            <div class="position-relative d-inline-block">
                                @if($teacher->photo)
                                    <img src="{{ asset('storage/' . $teacher->photo) }}" id="photoPreview" class="rounded-circle shadow-sm p-1 bg-white border" width="150" height="150" style="object-fit: cover;">
                                @else
                                    <div id="photoPlaceholder" class="rounded-circle bg-light border d-flex align-items-center justify-content-center mx-auto shadow-sm" style="width: 150px; height: 150px;">
                                        <i class="bi bi-person fs-1 text-muted"></i>
                                    </div>
                                    <img src="" id="photoPreview" class="rounded-circle shadow-sm p-1 bg-white border d-none" width="150" height="150" style="object-fit: cover;">
                                @endif
                                <label for="photo" class="position-absolute bottom-0 end-0 bg-white shadow-sm border rounded-circle p-2 cursor-pointer" style="cursor: pointer;">
                                    <i class="bi bi-camera-fill text-primary"></i>
                                    <input type="file" name="photo" id="photo" class="d-none" accept="image/*" onchange="previewImage(this)">
                                </label>
                            </div>
                            <div class="mt-2 small text-muted">Click camera icon to change</div>
                        </div>
                        <div class="col-md-9">
                            <div class="alert alert-light border mb-0">
                                <i class="bi bi-info-circle me-2 text-info"></i>
                                <small>Upload a clear portrait photo. Max size 2MB. Supported formats: JPG, PNG.</small>
                            </div>
                        </div>
                    </div>

                    <h6 class="fw-bold mb-3 text-uppercase text-muted small border-bottom pb-2">Basic Information</h6>
                    
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <label class="form-label">Full Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $teacher->name) }}" required placeholder="e.g. John Doe">
                             @error('name') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Designation <span class="text-danger">*</span></label>
                            <input type="text" name="designation" class="form-control" value="{{ old('designation', $teacher->designation) }}" required placeholder="e.g. Senior Lecturer">
                             @error('designation') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6">
                             <label class="form-label">Department</label>
                             <input type="text" name="department" class="form-control" value="{{ old('department', $teacher->department) }}" placeholder="e.g. Mathematics">
                             @error('department') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Email Address</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light text-muted"><i class="bi bi-envelope"></i></span>
                                <input type="email" name="email" class="form-control" value="{{ old('email', $teacher->email) }}" placeholder="email@college.edu.bd">
                            </div>
                             @error('email') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>
                         <div class="col-md-6">
                            <label class="form-label">Phone Number</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light text-muted"><i class="bi bi-telephone"></i></span>
                                <input type="text" name="phone" class="form-control" value="{{ old('phone', $teacher->phone) }}" placeholder="+880 1XXX-XXXXXX">
                            </div>
                             @error('phone') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Display Order</label>
                            <input type="number" name="display_order" class="form-control" value="{{ old('display_order', $teacher->display_order) }}">
                            <div class="form-text small">Used for sorting on the frontend list.</div>
                        </div>
                    </div>

                    <h6 class="fw-bold mb-3 text-uppercase text-muted small border-bottom pb-2">Academic Profile</h6>

                    <div class="row g-3 mb-4">
                        <div class="col-12">
                            <label class="form-label">Qualification</label>
                            <textarea name="qualification" class="form-control" rows="2" placeholder="e.g. B.Sc in Mathematics, M.Sc in Applied Mathematics">{{ old('qualification', $teacher->qualification) }}</textarea>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Specialization</label>
                            <textarea name="specialization" class="form-control" rows="2" placeholder="e.g. Number Theory, Calculus">{{ old('specialization', $teacher->specialization) }}</textarea>
                        </div>
                         <div class="col-12">
                            <label class="form-label">Biography</label>
                            <textarea name="bio" class="form-control" rows="4" placeholder="Brief introduction about the teacher...">{{ old('bio', $teacher->bio) }}</textarea>
                        </div>
                    </div>

                    <!-- Roles -->
                    <div class="mb-3 bg-light p-3 rounded border">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_principal" id="is_principal" value="1" {{ old('is_principal', $teacher->is_principal) ? 'checked' : '' }}>
                            <label class="form-check-label fw-bold" for="is_principal">
                                <i class="bi bi-award text-warning me-2"></i> Mark as Principal/Head
                            </label>
                            <div class="form-text mt-0 ms-4">This teacher will be highlighted as the head of the institution.</div>
                        </div>
                    </div>
                </div>

                <div class="card-footer bg-light py-3 d-flex justify-content-end gap-2">
                    <a href="{{ route('teachers.index') }}" class="btn btn-light border">Cancel</a>
                    <button type="submit" class="btn btn-primary px-4"><i class="bi bi-save me-1"></i> Update Changes</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
function previewImage(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('photoPreview').src = e.target.result;
            document.getElementById('photoPreview').classList.remove('d-none');
            
            const placeholder = document.getElementById('photoPlaceholder');
            if(placeholder) placeholder.classList.add('d-none');
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>

@endsection
