@extends('admin.layouts.app')

@section('title', 'Teachers Management')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Teachers</li>
@endsection

@section('actions')
    <a href="{{ route('teachers.create') }}" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Add Teacher
    </a>
@endsection

@section('content')

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('teachers.index') }}" class="row g-3">
             <div class="col-md-4">
                <label class="form-label small text-muted fw-bold">Search</label>
                <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><i class="bi bi-search text-muted"></i></span>
                    <input type="text" name="search" class="form-control border-start-0 ps-0" value="{{ request('search') }}" placeholder="Name, Email, Phone...">
                </div>
            </div>
            
            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Department</label>
                <select name="department" class="form-select">
                    <option value="">All Departments</option>
                    @foreach($departments ?? [] as $dept)
                         <option value="{{ $dept }}" {{ request('department') == $dept ? 'selected' : '' }}>{{ $dept }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Designation</label>
                <select name="designation" class="form-select">
                    <option value="">All Designations</option>
                     @foreach($designations ?? [] as $desig)
                         <option value="{{ $desig }}" {{ request('designation') == $desig ? 'selected' : '' }}>{{ $desig }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-dark w-100">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Teachers List -->
<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted small text-uppercase">
                    <tr>
                         <th class="ps-4">Teacher Info</th>
                         <th>Designation</th>
                         <th>Contact</th>
                         <th>Status</th>
                         <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($teachers as $teacher)
                        <tr>
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    @if($teacher->image)
                                        <img src="{{ asset('storage/'.$teacher->image) }}" class="rounded-circle me-3 border" width="48" height="48" alt="{{ $teacher->name }}">
                                    @else
                                         <div class="avatar rounded-circle bg-secondary bg-opacity-10 text-secondary d-flex align-items-center justify-content-center fw-bold me-3" style="width: 48px; height: 48px;">
                                            {{ substr($teacher->name, 0, 1) }}
                                        </div>
                                    @endif
                                    <div>
                                        <h6 class="mb-0 text-dark fw-bold">{{ $teacher->name }}</h6>
                                        <div class="text-muted small">{{ $teacher->department ?? 'General' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark border">{{ $teacher->designation }}</span>
                            </td>
                            <td>
                                <div class="d-flex flex-column small">
                                    <span class="text-dark"><i class="bi bi-envelope me-1 text-muted"></i> {{ $teacher->email }}</span>
                                    <span class="text-muted mt-1"><i class="bi bi-phone me-1"></i> {{ $teacher->phone }}</span>
                                </div>
                            </td>
                             <td>
                                @if($teacher->is_active)
                                    <span class="badge badge-soft-success">Active</span>
                               
                                @else
                                    <span class="badge badge-soft-danger">Inactive</span>
                                @endif
                            </td>
                            <td class="text-end pe-4">
                                <div class="btn-group">
                                    <a href="{{ route('teachers.edit', $teacher) }}" class="btn btn-sm btn-light text-warning" title="Edit"><i class="bi bi-pencil-square"></i></a>
                                    
                                    <form action="{{ route('teachers.destroy', $teacher) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this teacher?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="py-5 text-center text-muted">
                                <div class="mb-3">
                                    <i class="bi bi-person-video3 fs-1 text-secondary opacity-50"></i>
                                </div>
                                <p class="mb-1">No teachers found.</p>
                                <a href="{{ route('teachers.create') }}" class="btn btn-sm btn-primary mt-2">Add First Teacher</a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($teachers->hasPages())
        <div class="card-footer bg-white border-top-0 py-3">
             {{ $teachers->links('pagination::bootstrap-5') }}
        </div>
    @endif
</div>

@endsection
