<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h2 class="font-bold text-2xl text-gray-800 flex items-center">
                    <i class="fas fa-user mr-3 text-blue-600"></i>Teacher Details
                </h2>
                <p class="text-sm text-gray-500 mt-1">View teacher information</p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('teachers.edit', $teacher) }}" 
                   class="inline-flex items-center px-6 py-3 bg-yellow-600 hover:bg-yellow-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('teachers.index') }}" 
                   class="inline-flex items-center px-6 py-3 bg-gray-500 hover:bg-gray-600 text-white font-semibold rounded-lg transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white overflow-hidden shadow-xl rounded-2xl">
            <!-- Header -->
            <div class="bg-gradient-to-r from-blue-600 to-blue-700 px-8 py-6">
                <div class="flex items-center space-x-6">
                    @if($teacher->photo)
                        <img src="{{ asset('storage/' . $teacher->photo) }}" alt="{{ $teacher->name }}" 
                             class="h-24 w-24 rounded-full object-cover border-4 border-white shadow-xl">
                    @else
                        <div class="h-24 w-24 rounded-full bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-white font-bold text-3xl border-4 border-white shadow-xl">
                            {{ strtoupper(substr($teacher->name, 0, 1)) }}
                        </div>
                    @endif
                    <div class="text-white">
                        <h3 class="text-2xl font-bold">{{ $teacher->name }}
                            @if($teacher->is_principal)
                                <i class="fas fa-crown text-yellow-400 ml-2"></i>
                            @endif
                        </h3>
                        <p class="text-blue-100 text-lg mt-1">{{ $teacher->designation }}</p>
                        @if($teacher->department)
                            <p class="text-blue-200 text-sm mt-1">{{ $teacher->department }}</p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Content -->
            <div class="p-8 space-y-6">
                @if($teacher->qualification)
                    <div class="border-l-4 border-blue-500 pl-4">
                        <h4 class="font-semibold text-gray-700 mb-2 flex items-center">
                            <i class="fas fa-graduation-cap text-blue-600 mr-2"></i>Qualification
                        </h4>
                        <p class="text-gray-600">{{ $teacher->qualification }}</p>
                    </div>
                @endif

                @if($teacher->specialization)
                    <div class="border-l-4 border-blue-500 pl-4">
                        <h4 class="font-semibold text-gray-700 mb-2 flex items-center">
                            <i class="fas fa-book text-blue-600 mr-2"></i>Specialization
                        </h4>
                        <p class="text-gray-600">{{ $teacher->specialization }}</p>
                    </div>
                @endif

                @if($teacher->bio)
                    <div class="border-l-4 border-blue-500 pl-4">
                        <h4 class="font-semibold text-gray-700 mb-2 flex items-center">
                            <i class="fas fa-info-circle text-blue-600 mr-2"></i>Biography
                        </h4>
                        <p class="text-gray-600 leading-relaxed">{{ $teacher->bio }}</p>
                    </div>
                @endif

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 pt-6 border-t border-gray-200">
                    @if($teacher->email)
                        <div class="flex items-center space-x-3">
                            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-envelope text-blue-600"></i>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Email</p>
                                <a href="mailto:{{ $teacher->email }}" class="text-blue-600 hover:text-blue-800 font-semibold">
                                    {{ $teacher->email }}
                                </a>
                            </div>
                        </div>
                    @endif

                    @if($teacher->phone)
                        <div class="flex items-center space-x-3">
                            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-phone text-green-600"></i>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Phone</p>
                                <a href="tel:{{ $teacher->phone }}" class="text-green-600 hover:text-green-800 font-semibold">
                                    {{ $teacher->phone }}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="flex flex-wrap gap-3 pt-6 border-t border-gray-200">
                    <span class="px-4 py-2 rounded-full text-sm font-semibold {{ $teacher->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                        <i class="fas fa-circle text-xs mr-2 {{ $teacher->is_active ? 'text-green-600' : 'text-gray-600' }}"></i>
                        {{ $teacher->is_active ? 'Active' : 'Inactive' }}
                    </span>
                    @if($teacher->is_principal)
                        <span class="px-4 py-2 rounded-full text-sm font-semibold bg-yellow-100 text-yellow-800">
                            <i class="fas fa-crown mr-2"></i>Principal
                        </span>
                    @endif
                    <span class="px-4 py-2 rounded-full text-sm font-semibold bg-blue-100 text-blue-800">
                        Display Order: {{ $teacher->display_order }}
                    </span>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

