<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\ResultController;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\SubjectController;
// use App\Http\Controllers\ExamTypeController;
use App\Http\Controllers\ExamController;
use App\Http\Controllers\ExamTemplateController;
use App\Http\Controllers\ResultManagementController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\HeroSlideController;
use App\Http\Controllers\TeacherController;
use App\Http\Controllers\NoticeCategoryController;
use App\Http\Controllers\SubjectConfigurationController;
use Illuminate\Support\Facades\Route;


// Frontend Routes - Rebuilding..
Route::get('/', [App\Http\Controllers\FrontendController::class, 'index'])->name('home');


Route::get('/about', [App\Http\Controllers\FrontendController::class, 'about'])->name('about');

Route::get('/contact', [App\Http\Controllers\FrontendController::class, 'contact'])->name('contact');
Route::get('/notices', [App\Http\Controllers\FrontendController::class, 'notice'])->name('notice');
Route::get('/notices/{id}', [App\Http\Controllers\FrontendController::class, 'noticeDetails'])->name('notice.details');
Route::get('/notices/{notice}/download', [App\Http\Controllers\FrontendController::class, 'downloadNotice'])->name('notice.download');
Route::get('/notices/{notice}/view', [App\Http\Controllers\FrontendController::class, 'viewNotice'])->name('notice.view');
Route::get('/notices/{notice}/stream', [App\Http\Controllers\FrontendController::class, 'streamNotice'])->name('notice.stream');
Route::get('/privacy-policy', [App\Http\Controllers\FrontendController::class, 'privacyPolicy'])->name('privacy-policy');
Route::get('/terms-of-use', [App\Http\Controllers\FrontendController::class, 'termsOfUse'])->name('terms-of-use');
Route::get('/teachers', [App\Http\Controllers\FrontendController::class, 'teachers'])->name('teachers');
Route::get('/teachers', [App\Http\Controllers\FrontendController::class, 'teachers'])->name('teachers');
Route::get('/results', [App\Http\Controllers\FrontendController::class, 'result'])->name('result');
Route::get('/get-exams', [App\Http\Controllers\FrontendController::class, 'getExams'])->name('get.exams');
Route::post('/results/search', [App\Http\Controllers\FrontendController::class, 'resultSearch'])->name('result.search');




Route::redirect('/admin', '/admin/dashboard');

// Manually register Tyro Login routes if not auto-discovered
Route::middleware('web')->group(function () {
    Route::get('/login', [\HasinHayder\TyroLogin\Http\Controllers\LoginController::class, 'showLoginForm'])->name('tyro-login.login');
    Route::post('/login', [\HasinHayder\TyroLogin\Http\Controllers\LoginController::class, 'login'])->name('tyro-login.login.submit');
    Route::post('/logout', [\HasinHayder\TyroLogin\Http\Controllers\LoginController::class, 'logout'])->name('tyro-login.logout');
    // Alias 'logout' for standard layouts
    Route::post('/logout-alias', [\HasinHayder\TyroLogin\Http\Controllers\LoginController::class, 'logout'])->name('logout');

    Route::get('/register', [\HasinHayder\TyroLogin\Http\Controllers\RegisterController::class, 'showRegistrationForm'])->name('tyro-login.register');
    Route::post('/register', [\HasinHayder\TyroLogin\Http\Controllers\RegisterController::class, 'register'])->name('tyro-login.register.submit');
});

Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Profile routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::put('/password', [App\Http\Controllers\PasswordController::class, 'update'])->name('password.update');

    // Student Promotion (define BEFORE resource to avoid conflict with students.show)
    Route::patch('students/{student}/promote', [StudentController::class, 'promote'])->name('students.promote');
    Route::get('students/bulk-promote', [StudentController::class, 'bulkPromotePage'])->name('students.bulk-promote');
    Route::post('students/bulk-promote/process', [StudentController::class, 'bulkPromoteProcess'])->name('students.bulk-promote.process');
    Route::get('students/get-by-session', [StudentController::class, 'getBySession'])->name('students.get-by-session');

    // Student Management
    Route::post('students/{id}/restore', [StudentController::class, 'restore'])->name('students.restore');
    Route::get('students/import', [StudentController::class, 'import'])->name('students.import');
    Route::post('students/import', [StudentController::class, 'upload'])->name('students.upload');
    Route::get('students/import-sample', [StudentController::class, 'downloadSample'])->name('students.import-sample');
    Route::get('students/fix-rolls', [StudentController::class, 'fixRolls'])->name('students.fix-rolls');
    Route::resource('students', StudentController::class);

    // (Legacy Results module removed) Use Result Management below

    // Notice Management
    Route::resource('notices', NoticeController::class);

    // Notice Categories Management
    Route::resource('notice-categories', NoticeCategoryController::class);

    // Subject Management
    Route::resource('subjects', SubjectController::class);
    Route::get('api/check-subject-code', [SubjectController::class, 'checkCode'])->name('api.subjects.check-code');
    Route::get('api/subjects-by-group/{group}', [SubjectController::class, 'getByGroup'])->name('api.subjects.by-group');

    // Exam Type Management (Removed - Legacy)
    // Route::resource('exam-types', ExamTypeController::class);

    // Exam Management
    Route::resource('exams', ExamController::class);

    // Exam Templates (dynamic rule templates)
    Route::post('exam-templates/{examTemplate}/duplicate', [ExamTemplateController::class, 'duplicate'])->name('exam-templates.duplicate');
    Route::resource('exam-templates', ExamTemplateController::class);

    // Result Management
    Route::get('result-management', [ResultManagementController::class, 'index'])->name('result-management.index');
    Route::get('result-management/exam/{exam}', [ResultManagementController::class, 'selectExam'])->name('result-management.students');
    Route::get('result-management/exam/{exam}/student/{student}', [ResultManagementController::class, 'enterMarks'])->name('result-management.enter');
    Route::post('result-management/exam/{exam}/student/{student}', [ResultManagementController::class, 'saveMarks'])->name('result-management.save');
    Route::get('result-management/exam/{exam}/results', [ResultManagementController::class, 'viewResults'])->name('result-management.view-results');
    Route::post('result-management/exam/{exam}/publish', [ResultManagementController::class, 'publishResults'])->name('result-management.publish');
    Route::post('result-management/exam/{exam}/unpublish', [ResultManagementController::class, 'unpublishResults'])->name('result-management.unpublish');
    Route::get('result-management/exam/{exam}/student/{student}/export', [ResultManagementController::class, 'exportPdf'])->name('result-management.export-pdf');
    Route::get('result-management/exam/{exam}/export-sheet', [ResultManagementController::class, 'exportResultSheet'])->name('result-management.export-sheet');

    // Subject-wise Entry
    Route::get('result-management/exam/{exam}/subject/{subject}', [ResultManagementController::class, 'subjectEntry'])->name('result-management.subject-entry');
    Route::post('result-management/exam/{exam}/subject/{subject}', [ResultManagementController::class, 'saveSubjectMarks'])->name('result-management.subject-save');

    // Subject Rules API
    Route::get('api/student-subject-rules', [StudentController::class, 'getSubjectRules'])->name('api.student.rules');

    // Website Settings
    Route::get('settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('settings', [SettingController::class, 'update'])->name('settings.update');

    Route::get('/subject-configuration', [SubjectConfigurationController::class, 'index'])->name('subjects.config.index');
    Route::post('/subject-configuration/toggle-fixed', [SubjectConfigurationController::class, 'toggleFixed'])->name('subjects.config.toggle-fixed');
    Route::post('/subject-configuration/details', [SubjectConfigurationController::class, 'details'])->name('subjects.config.details'); // Optional for future
    Route::post('/subject-configuration/store-bucket', [SubjectConfigurationController::class, 'storeBucket'])->name('subjects.config.store-bucket');
    Route::delete('subject-configuration/rule/{group}', [SubjectConfigurationController::class, 'deleteBucket'])->name('subjects.config.delete-bucket');

    // Version Management
    Route::post('subject-configuration/version/{id}/activate', [SubjectConfigurationController::class, 'activateVersion'])->name('subjects.config.version.activate');
    Route::delete('subject-configuration/version/{id}', [SubjectConfigurationController::class, 'deleteVersion'])->name('subjects.config.version.delete');
    Route::post('subject-configuration/version/{id}/restore', [SubjectConfigurationController::class, 'restoreVersion'])->name('subjects.config.version.restore');
    // Hero Slides
    Route::resource('hero-slides', HeroSlideController::class)->except(['show']);

    // Teacher Management
    Route::resource('teachers', TeacherController::class);
});
