

<?php $__env->startSection('title', 'Notices - ' . ($global_settings['college_name'] ?? 'College Name')); ?>

<?php $__env->startSection('content'); ?>

<div class="container py-5">
    
    <div class="row g-4">
        <!-- Main Notice List -->
        <div class="col-lg-8 animate-up">
            <div class="d-flex align-items-center justify-content-between mb-4">
               <div>
                   <h2 class="font-serif fw-bold mb-1">Notice Board</h2>
                   <p class="text-muted mb-0">Stay updated with the latest announcements</p>
               </div>
               <div class="d-none d-md-block">
                    <span class="badge bg-primary bg-opacity-10 text-primary px-3 py-2 rounded-pill">
                        <i class="fas fa-bell me-1"></i> Latest Updates
                    </span>
               </div>
            </div>

            <!-- Notices Content Wrapper for AJAX -->
            <div id="notice-content-wrapper">
                <?php echo $__env->make('frontend.partials.notice-content', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4 animate-up" style="animation-delay: 0.2s;">
            <!-- Search Widget -->
            <div class="card border-0 shadow-sm rounded-4 mb-4 bg-white">
                <div class="card-body p-4">
                    <h5 class="fw-bold font-serif mb-4 pb-2 border-bottom">Search Notices</h5>
                    <form action="<?php echo e(route('notice')); ?>" method="GET" id="searchForm" class="uiverse-form position-relative">
                        <button class="search-icon-btn position-absolute top-50 start-0 translate-middle-y p-1 border-0 bg-transparent text-secondary" type="submit">
                            <svg width="17" height="16" fill="none" xmlns="http://www.w3.org/2000/svg" role="img" aria-labelledby="search" class="w-5 h-5 text-gray-700">
                                <path d="M7.667 12.667A5.333 5.333 0 107.667 2a5.333 5.333 0 000 10.667zM14.334 14l-2.9-2.9" stroke="currentColor" stroke-width="1.333" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </button>
                        <input class="uiverse-input form-control rounded-pill px-5 py-3 border-2 border-transparent shadow-sm" placeholder="Search..." required="" type="text" name="search" id="searchInput" value="<?php echo e(request('search')); ?>" />
                        <button type="reset" class="reset-icon-btn position-absolute top-50 end-0 translate-middle-y me-2 p-1 border-0 bg-transparent text-secondary" onclick="document.getElementById('searchInput').value=''; document.getElementById('searchInput').dispatchEvent(new Event('keyup'));">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-700" fill="none" viewBox="0 0 24 24" stroke="currentColor" width="20" height="20">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Modern Table Styles */
    .table-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        overflow-x: auto;
        border: 1px solid #edf2f7;
    }

    .modern-table {
        margin-bottom: 0;
        width: 100%;
    }

    .modern-table thead th {
        background-color: #f8fafc;
        color: #64748b;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.8rem;
        letter-spacing: 0.5px;
        padding: 1rem 1.5rem;
        border-bottom: 2px solid #e2e8f0;
        border-top: none;
    }

    .modern-table tbody tr {
        transition: all 0.2s ease;
        border-bottom: 1px solid #f1f5f9;
    }

    .modern-table tbody tr:last-child {
        border-bottom: none;
    }

    .modern-table tbody tr:hover {
        background-color: #f8fafc;
        transform: translateY(-1px);
        box-shadow: 0 2px 15px rgba(0,0,0,0.02);
    }

    .modern-table td {
        padding: 1.25rem 1.5rem;
        vertical-align: middle;
        color: #334155;
        font-size: 0.95rem;
        border: none;
    }

    .notice-date {
        font-family: 'Courier New', monospace;
        background: #f1f5f9;
        padding: 4px 10px;
        border-radius: 6px;
        color: #475569;
        font-weight: 600;
        font-size: 0.85rem;
    }

    .action-btn {
        padding: 6px 16px;
        border-radius: 50rem;
        font-size: 0.85rem;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }
    
    .btn-download {
        background-color: #eff6ff;
        color: #2563eb;
    }
    
    .btn-download:hover {
        background-color: #2563eb;
        color: white;
    }
    
    .btn-view {
        background-color: #f8fafc;
        color: #475569;
        border: 1px solid #e2e8f0;
    }
    
    .btn-view:hover {
        background-color: #475569;
        color: white;
    }
    
    .pinned-icon {
        color: #f59e0b;
        margin-right: 8px;
        filter: drop-shadow(0 2px 4px rgba(245, 158, 11, 0.2));
    }
</style>

<style>
    .uiverse-input {
        transition: all 0.3s ease;
        background-color: #f8f9fa;
        padding-left: 3rem !important; /* Space for search icon */
    }
    .uiverse-input:focus {
        outline: none;
        border-color: var(--bs-primary) !important;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        background-color: #fff;
    }
    .search-icon-btn {
        left: 10px;
        z-index: 10;
        cursor: pointer;
    }
    .reset-icon-btn {
        right: 10px;
        z-index: 10;
        cursor: pointer;
        opacity: 0.5;
        transition: opacity 0.2s;
    }
    .reset-icon-btn:hover {
        opacity: 1;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const searchInput = document.getElementById('searchInput');
        const contentWrapper = document.getElementById('notice-content-wrapper');
        let timeout = null;

        // Loading state function
        const setLoading = (isLoading) => {
            if(isLoading) {
                contentWrapper.style.opacity = '0.5';
                contentWrapper.style.pointerEvents = 'none';
                contentWrapper.style.transition = 'opacity 0.2s';
            } else {
                contentWrapper.style.opacity = '1';
                contentWrapper.style.pointerEvents = 'auto';
            }
        };

        searchInput.addEventListener('keyup', function() {
            clearTimeout(timeout);
            const query = this.value;

            setLoading(true); // Start loading immediately on type

            timeout = setTimeout(() => {
                const url = new URL("<?php echo e(route('notice')); ?>");
                if(query) url.searchParams.set('search', query);
                
                fetch(url, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => response.text())
                .then(html => {
                    contentWrapper.innerHTML = html;
                    setLoading(false); // Stop loading on success
                })
                .catch(error => {
                    console.error('Error:', error);
                    setLoading(false);
                });
            }, 300); // 300ms debounce
        });
        
        // Prevent default form submit if JS is enabled, purely for live search feel.
        // But keep button functional for non-JS or immediate submit.
        document.getElementById('searchForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const query = searchInput.value;
            const url = new URL("<?php echo e(route('notice')); ?>");
            if(query) url.searchParams.set('search', query);
                 fetch(url, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => response.text())
                .then(html => {
                    contentWrapper.innerHTML = html;
                });
        });

        // Handle pagination clicks via AJAX
        document.addEventListener('click', function(e) {
            if (e.target.closest('.pagination a')) {
                e.preventDefault();
                const url = e.target.closest('.pagination a').href;
                fetch(url, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => response.text())
                .then(html => {
                    contentWrapper.innerHTML = html;
                    window.scrollTo({ top: contentWrapper.offsetTop - 100, behavior: 'smooth' });
                });
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/frontend/notice.blade.php ENDPATH**/ ?>