

<?php $__env->startSection('title', 'Add New Slide'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('hero-slides.index')); ?>">Gallery</a></li>
    <li class="breadcrumb-item active" aria-current="page">Add Slide</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-lg-8">
        <form action="<?php echo e(route('hero-slides.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-image me-2 text-primary"></i>Slide Details</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                         <!-- Image Upload -->
                        <div class="col-12">
                            <label for="image" class="form-label small fw-bold text-muted">Slide Image <span class="text-danger">*</span></label>
                            <input type="file" name="image" id="image" class="form-control" required accept="image/*">
                            <div class="form-text small">Recommended size: 1920x600px. Max: 5MB.</div>
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Title -->
                        <div class="col-12">
                            <label for="title" class="form-label small fw-bold text-muted">Title</label>
                            <input type="text" name="title" id="title" class="form-control" placeholder="Slide Heading" value="<?php echo e(old('title')); ?>">
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Subtitle -->
                        <div class="col-12">
                            <label for="subtitle" class="form-label small fw-bold text-muted">Subtitle / Description</label>
                            <textarea name="subtitle" id="subtitle" class="form-control" rows="2" placeholder="Brief description..."><?php echo e(old('subtitle')); ?></textarea>
                            <?php $__errorArgs = ['subtitle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Button Config -->
                        <div class="col-md-6">
                            <label for="button_primary_text" class="form-label small fw-bold text-muted">Primary Button Text</label>
                            <input type="text" name="button_primary_text" id="button_primary_text" class="form-control" placeholder="e.g. Read More" value="<?php echo e(old('button_primary_text')); ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="button_primary_link" class="form-label small fw-bold text-muted">Primary Button Link</label>
                            <input type="url" name="button_primary_link" id="button_primary_link" class="form-control" placeholder="https://..." value="<?php echo e(old('button_primary_link')); ?>">
                        </div>

                         <!-- Secondary Button Config -->
                        <div class="col-md-6">
                            <label for="button_secondary_text" class="form-label small fw-bold text-muted">Secondary Button Text</label>
                            <input type="text" name="button_secondary_text" id="button_secondary_text" class="form-control" placeholder="e.g. Contact Us" value="<?php echo e(old('button_secondary_text')); ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="button_secondary_link" class="form-label small fw-bold text-muted">Secondary Button Link</label>
                            <input type="url" name="button_secondary_link" id="button_secondary_link" class="form-control" placeholder="https://..." value="<?php echo e(old('button_secondary_link')); ?>">
                        </div>

                         <!-- Order & Status -->
                        <div class="col-md-6">
                            <label for="order" class="form-label small fw-bold text-muted">Display Order</label>
                            <input type="number" name="order" id="order" class="form-control" value="<?php echo e(old('order', 0)); ?>">
                        </div>
                        <div class="col-md-6 d-flex align-items-end">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="is_active" value="1" id="is_active" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                <label class="form-check-label fw-bold small" for="is_active">Active</label>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="d-flex justify-content-end gap-2 mb-5">
                <a href="<?php echo e(route('hero-slides.index')); ?>" class="btn btn-light border px-4">Cancel</a>
                <button type="submit" class="btn btn-primary px-4"><i class="bi bi-save me-1"></i> Save Slide</button>
            </div>

        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/hero-slides/create.blade.php ENDPATH**/ ?>