

<?php $__env->startSection('title', 'Exam Templates'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Exam Templates</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('exam-templates.create')); ?>" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Create Template
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted small text-uppercase">
                    <tr>
                        <th class="ps-4">Template Name</th>
                        <th>Description</th>
                        <th>Subjects</th>
                        <th>Created</th>
                        <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar rounded-circle bg-purple-100 text-purple-600 d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-file-earmark-text fs-5"></i>
                                    </div>
                                    <div class="fw-bold text-dark"><?php echo e($template->name); ?></div>
                                </div>
                            </td>
                            <td>
                                <span class="text-muted small"><?php echo e(Str::limit($template->description ?? 'No description provided.', 60)); ?></span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark border">
                                    <i class="bi bi-collection me-1"></i> 
                                    <?php echo e($template->subjectRules->count()); ?> Subject Rules
                                </span>
                            </td>
                            <td class="text-muted small">
                                <i class="bi bi-calendar3 me-1"></i> <?php echo e($template->created_at->format('M d, Y')); ?>

                            </td>
                            <td class="text-end pe-4">
                                <div class="btn-group">
                                    <a href="<?php echo e(route('exam-templates.edit', $template)); ?>" class="btn btn-sm btn-light text-warning" data-bs-toggle="tooltip" title="Edit Template"><i class="bi bi-pencil-square"></i></a>
                                    
                                    <form action="<?php echo e(route('exam-templates.duplicate', $template)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-sm btn-light text-info" data-bs-toggle="tooltip" title="Duplicate Template"><i class="bi bi-copy"></i></button>
                                    </form>
                                    
                                    <form action="<?php echo e(route('exam-templates.destroy', $template)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this template?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="py-5 text-center text-muted">
                                <div class="mb-3">
                                    <i class="bi bi-file-earmark-text fs-1 text-secondary opacity-50"></i>
                                </div>
                                <p class="mb-1">No exam templates found.</p>
                                <a href="<?php echo e(route('exam-templates.create')); ?>" class="btn btn-sm btn-primary mt-2">Create First Template</a>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($templates->hasPages()): ?>
        <div class="card-footer bg-white border-top-0 py-3">
             <?php echo e($templates->links('pagination::bootstrap-5')); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/exam-templates/index.blade.php ENDPATH**/ ?>