

<?php $__env->startSection('title', 'Teachers Management'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Teachers</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('teachers.create')); ?>" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Add Teacher
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('teachers.index')); ?>" class="row g-3">
             <div class="col-md-4">
                <label class="form-label small text-muted fw-bold">Search</label>
                <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><i class="bi bi-search text-muted"></i></span>
                    <input type="text" name="search" class="form-control border-start-0 ps-0" value="<?php echo e(request('search')); ?>" placeholder="Name, Email, Phone...">
                </div>
            </div>
            
            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Department</label>
                <select name="department" class="form-select">
                    <option value="">All Departments</option>
                    <?php $__currentLoopData = $departments ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <option value="<?php echo e($dept); ?>" <?php echo e(request('department') == $dept ? 'selected' : ''); ?>><?php echo e($dept); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Designation</label>
                <select name="designation" class="form-select">
                    <option value="">All Designations</option>
                     <?php $__currentLoopData = $designations ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $desig): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <option value="<?php echo e($desig); ?>" <?php echo e(request('designation') == $desig ? 'selected' : ''); ?>><?php echo e($desig); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-dark w-100">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Teachers List -->
<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted small text-uppercase">
                    <tr>
                         <th class="ps-4">Teacher Info</th>
                         <th>Designation</th>
                         <th>Contact</th>
                         <th>Status</th>
                         <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    <?php if($teacher->image): ?>
                                        <img src="<?php echo e(asset('storage/'.$teacher->image)); ?>" class="rounded-circle me-3 border" width="48" height="48" alt="<?php echo e($teacher->name); ?>">
                                    <?php else: ?>
                                         <div class="avatar rounded-circle bg-secondary bg-opacity-10 text-secondary d-flex align-items-center justify-content-center fw-bold me-3" style="width: 48px; height: 48px;">
                                            <?php echo e(substr($teacher->name, 0, 1)); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div>
                                        <h6 class="mb-0 text-dark fw-bold"><?php echo e($teacher->name); ?></h6>
                                        <div class="text-muted small"><?php echo e($teacher->department ?? 'General'); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark border"><?php echo e($teacher->designation); ?></span>
                            </td>
                            <td>
                                <div class="d-flex flex-column small">
                                    <span class="text-dark"><i class="bi bi-envelope me-1 text-muted"></i> <?php echo e($teacher->email); ?></span>
                                    <span class="text-muted mt-1"><i class="bi bi-phone me-1"></i> <?php echo e($teacher->phone); ?></span>
                                </div>
                            </td>
                             <td>
                                <?php if($teacher->is_active): ?>
                                    <span class="badge badge-soft-success">Active</span>
                               
                                <?php else: ?>
                                    <span class="badge badge-soft-danger">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-end pe-4">
                                <div class="btn-group">
                                    <a href="<?php echo e(route('teachers.edit', $teacher)); ?>" class="btn btn-sm btn-light text-warning" title="Edit"><i class="bi bi-pencil-square"></i></a>
                                    
                                    <form action="<?php echo e(route('teachers.destroy', $teacher)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete this teacher?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="py-5 text-center text-muted">
                                <div class="mb-3">
                                    <i class="bi bi-person-video3 fs-1 text-secondary opacity-50"></i>
                                </div>
                                <p class="mb-1">No teachers found.</p>
                                <a href="<?php echo e(route('teachers.create')); ?>" class="btn btn-sm btn-primary mt-2">Add First Teacher</a>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($teachers->hasPages()): ?>
        <div class="card-footer bg-white border-top-0 py-3">
             <?php echo e($teachers->links('pagination::bootstrap-5')); ?>

        </div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/teachers/index.blade.php ENDPATH**/ ?>