<?php $__env->startSection('title', 'Notices Management'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Notices</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    <div class="d-flex gap-2">
        <a href="<?php echo e(route('notice-categories.index')); ?>" class="btn btn-light border">
            <i class="bi bi-tags me-1"></i> Categories
        </a>
        <a href="<?php echo e(route('notices.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-lg me-1"></i> Create Notice
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('notices.index')); ?>" class="row g-3">
            <div class="col-md-3">
                 <label class="form-label small text-muted fw-bold">Search</label>
                 <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><i class="bi bi-search text-muted"></i></span>
                    <input type="text" name="search" class="form-control border-start-0 ps-0" value="<?php echo e(request('search')); ?>" placeholder="Title...">
                </div>
            </div>
            
            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Category</label>
                <select name="category_id" class="form-select">
                    <option value="">All Categories</option>
                    <?php $__currentLoopData = ($categories ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                            <?php echo e($category->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label small text-muted fw-bold">Priority</label>
                <select name="priority" class="form-select">
                    <option value="">All</option>
                    <option value="urgent" <?php echo e(request('priority') == 'urgent' ? 'selected' : ''); ?>>Urgent</option>
                    <option value="high" <?php echo e(request('priority') == 'high' ? 'selected' : ''); ?>>High</option>
                    <option value="normal" <?php echo e(request('priority') == 'normal' ? 'selected' : ''); ?>>Normal</option>
                    <option value="low" <?php echo e(request('priority') == 'low' ? 'selected' : ''); ?>>Low</option>
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label small text-muted fw-bold">Status</label>
                <select name="status" class="form-select">
                    <option value="">All</option>
                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="pinned" <?php echo e(request('status') == 'pinned' ? 'selected' : ''); ?>>Pinned</option>
                </select>
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-dark w-100"><i class="bi bi-funnel me-1"></i> Filter</button>
            </div>
        </form>
    </div>
</div>

<!-- Notices List -->
<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted small text-uppercase">
                    <tr>
                        <th class="ps-4" width="40%">Title & Details</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>Published</th>
                        <th>Views</th>
                        <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $notices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php echo e($notice->is_pinned ? 'bg-warning bg-opacity-10' : ''); ?>">
                            <td class="ps-4">
                                <div class="d-flex flex-column">
                                    <h6 class="mb-1 fw-bold text-dark">
                                        <?php if($notice->is_pinned): ?> <i class="bi bi-pin-angle-fill text-warning me-1"></i> <?php endif; ?>
                                        <?php echo e($notice->title); ?>

                                    </h6>

                                    <div class="mt-1 d-flex gap-2">
                                        <?php if($notice->is_instant): ?> <span class="badge bg-danger rounded-pill" style="font-size: 10px;">Instant</span> <?php endif; ?>
                                        <?php if(!$notice->is_active): ?> <span class="badge bg-secondary rounded-pill" style="font-size: 10px;">Inactive</span> <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php if($notice->category): ?>
                                    <span class="badge" style="background-color: <?php echo e($notice->category->color); ?>20; color: <?php echo e($notice->category->color); ?>; border: 1px solid <?php echo e($notice->category->color); ?>40;">
                                        <?php echo e($notice->category->name); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-muted small">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                    $pClass = match($notice->priority) {
                                        'urgent' => 'danger',
                                        'high' => 'warning',
                                        'low' => 'secondary',
                                        default => 'info'
                                    };
                                ?>
                                <span class="badge badge-soft-<?php echo e($pClass); ?>"><?php echo e(ucfirst($notice->priority)); ?></span>
                            </td>
                             <td>
                                <div class="small">
                                     <i class="bi bi-calendar3 me-1 text-muted"></i> <?php echo e($notice->date ? $notice->date->format('M d, Y') : 'N/A'); ?>

                                </div>
                            </td>
                            <td>
                                <div class="small text-muted"><i class="bi bi-eye me-1"></i> <?php echo e($notice->views_count); ?></div>
                            </td>
                            <td class="text-end pe-4">
                                <div class="btn-group">
                                    <a href="<?php echo e(route('notices.show', $notice)); ?>" class="btn btn-sm btn-light text-primary" title="View"><i class="bi bi-eye"></i></a>
                                    <a href="<?php echo e(route('notices.edit', $notice)); ?>" class="btn btn-sm btn-light text-warning" title="Edit"><i class="bi bi-pencil-square"></i></a>
                                    
                                     <form action="<?php echo e(route('notices.destroy', $notice)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete this notice?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="py-5 text-center text-muted">
                                <div class="mb-3">
                                    <i class="bi bi-megaphone fs-1 text-secondary opacity-50"></i>
                                </div>
                                <p class="mb-1">No notices posted yet.</p>
                                <a href="<?php echo e(route('notices.create')); ?>" class="btn btn-sm btn-primary mt-2">Post Notice</a>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($notices->hasPages()): ?>
        <div class="card-footer bg-white border-top-0 py-3">
             <?php echo e($notices->links('pagination::bootstrap-5')); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/notices/index.blade.php ENDPATH**/ ?>