

<?php $__env->startSection('title', Str::limit($notice->title, 50) . ' - Notices'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <a href="<?php echo e(route('notice')); ?>" class="btn btn-link text-decoration-none mb-3 ps-0 text-secondary">
                <i class="fas fa-arrow-left me-1"></i> Back to Notices
            </a>
            
            <div class="card border-0 shadow-lg rounded-4 overflow-hidden bg-white">
                <div class="card-header bg-white p-4 p-md-5 border-bottom">
                    <div class="d-flex align-items-center gap-2 mb-3">
                         <span class="badge bg-primary bg-opacity-10 text-primary"><?php echo e($notice->category->name ?? 'General'); ?></span>
                         <span class="text-muted small">
                             <i class="far fa-calendar-alt me-1"></i> 
                             <?php echo e($notice->published_at ? \Carbon\Carbon::parse($notice->published_at)->format('d F, Y, h:i A') : 'N/A'); ?>

                         </span>
                    </div>
                    <h1 class="font-serif fw-bold display-6 mb-0"><?php echo e($notice->title); ?></h1>
                </div>
                
                <div class="card-body p-4 p-md-5 lh-lg text-secondary">
                    <?php echo $notice->content; ?>

                    
                    <?php if($notice->file_path): ?>
                        <div class="mt-5 p-4 bg-light rounded-3 border">
                            <h5 class="fw-bold mb-3"><i class="fas fa-paperclip me-2"></i> Attachments</h5>
                            <a href="<?php echo e(route('notices.file', $notice->id)); ?>" class="btn btn-primary rounded-pill px-4" target="_blank">
                                <i class="fas fa-download me-2"></i> Download File
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/frontend/notice-details.blade.php ENDPATH**/ ?>