

<?php $__env->startSection('title', 'Home - ' . ($global_settings['college_name'] ?? 'College Name')); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<!-- Hero Section -->
<?php if(isset($hero_slides) && $hero_slides->count() > 0): ?>
    <div id="heroCarousel" class="carousel slide carousel-fade w-100" data-bs-ride="carousel" data-bs-interval="5000">
        <!-- Carousel Indicators -->
        <div class="carousel-indicators">
            <?php $__currentLoopData = $hero_slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="<?php echo e($index); ?>" class="<?php echo e($index == 0 ? 'active' : ''); ?>" aria-current="<?php echo e($index == 0 ? 'true' : 'false'); ?>" aria-label="Slide <?php echo e($index + 1); ?>"></button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="carousel-inner">
            <?php $__currentLoopData = $hero_slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $heroImage = asset($slide->image_url);
                    $heroTitle = $slide->title ?? ($global_settings['college_name'] ?? 'College Name');
                    $heroSubtitle = $slide->subtitle ?? ($global_settings['tagline'] ?? 'Fostering Knowledge, Inspiring Virtue.');
                ?>
                <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>" style="min-height: 600px; background-color: #f8f9fa;">
                    <!-- Background Gradient/Image Split -->
                    <div class="position-absolute top-0 end-0 h-100 w-100 w-lg-75 hero-mask-container" 
                         style="background-image: url('<?php echo e($heroImage); ?>'); 
                                background-size: cover; 
                                background-position: center;">
                        <div class="position-absolute top-0 start-0 w-100 h-100 bg-dark" style="opacity: 0.1;"></div>
                        <!-- Mobile Image (Actual Img tag for auto-resize) -->
                        <img src="<?php echo e($heroImage); ?>" class="d-lg-none w-100 h-auto position-relative z-1" alt="Hero Slide">
                    </div>

                    <!-- Content Container -->
                    <div class="container position-relative z-2 h-100">
                        <div class="row h-100 align-items-center">
                            <div class="col-lg-7 py-5">
                                <div class="pe-lg-5 hero-text-container">
                                    <h1 class="display-3 fw-bold font-serif mb-4 text-dark lh-sm responsive-heading" style="font-size: 3.5rem; text-shadow: 2px 2px 4px rgba(255,255,255,0.5);">
                                        <?php echo e($heroTitle); ?>

                                    </h1>
                                    <p class="lead text-secondary mb-5 w-lg-75 small-mobile-text" style="text-shadow: 1px 1px 2px rgba(255,255,255,0.8);">
                                        <?php echo e($heroSubtitle); ?>

                                    </p>

                                    <!-- Location / Extra Info -->
                                    <div class="mt-2 mt-lg-5 text-muted small d-flex align-items-center justify-content-center justify-content-lg-start address-container">
                                        <i class="fas fa-map-marker-alt me-2 text-primary"></i> 
                                        <?php echo e($global_settings['contact_full_address'] ?? 'Campus Location'); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Carousel Indicators -->
        <div class="carousel-indicators">
            <?php $__currentLoopData = $hero_slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="<?php echo e($index); ?>" class="<?php echo e($index == 0 ? 'active' : ''); ?>" aria-current="<?php echo e($index == 0 ? 'true' : 'false'); ?>" aria-label="Slide <?php echo e($index + 1); ?>"></button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php else: ?>
    <!-- Fallback if no slides -->
    <div class="position-relative w-100 overflow-hidden" style="min-height: 600px; background-color: #f8f9fa;">
         <div class="container position-relative z-2 h-100 d-flex align-items-center justify-content-center">
            <div class="text-center">
                <h1 class="display-4 fw-bold"><?php echo e($global_settings['college_name'] ?? 'Welcome'); ?></h1>
                <p class="lead">Please add hero slides in the admin panel.</p>
            </div>
         </div>
    </div>
<?php endif; ?>

<style>
    /* Responsive Hero Mask */
    .hero-mask-container {
        /* Desktop: Fade from transparent (left) to image (right) */
        -webkit-mask-image: linear-gradient(to right, transparent 0%, black 50%, black 100%);
        mask-image: linear-gradient(to right, transparent 0%, black 50%, black 100%);
    }

    /* Mobile Layout Updates */
    @media (max-width: 991.98px) {
        /* Stack Layout: Image Top, Text Bottom */
        .carousel-item {
            min-height: auto !important; /* Remove fixed height constraint */
            display: flex;
            flex-direction: column;
        }

        .hero-mask-container {
            position: relative !important; 
            width: 100% !important;
            height: auto !important; 
            background-image: none !important; 
            -webkit-mask-image: none !important;
            mask-image: none !important;
            opacity: 1; 
            margin-bottom: 0; 
            z-index: 1;
        }
        
        /* Mobile Overlay Text */
        .hero-text-container {
             position: absolute !important;
             bottom: 0;
             left: 0;
             width: 100%;
             margin-top: 0; 
             text-align: center;
             /* Increased top padding for smoother fade, decreased bottom padding to push text down */
             padding: 8rem 1rem 1.5rem 1rem; 
             /* Refined gradient to be less harsh */
             background: linear-gradient(to top, rgba(0,0,0,0.9) 0%, rgba(0,0,0,0.7) 40%, transparent 100%);
             z-index: 2;
             color: white !important;
        }

        /* Force white text on mobile overlay */
        .hero-text-container h1, 
        .hero-text-container span, 
        .hero-text-container p,
        .hero-text-container i,
        .hero-text-container div {
            color: white !important;
            text-shadow: 1px 1px 3px rgba(0,0,0,0.5);
        }
        
        /* Adjust text sizes */
        .responsive-heading {
            font-size: 1.8rem !important; 
            margin-bottom: 0.5rem !important;
        }
        .small-mobile { display: none !important; } /* Hide tagline on mobile to save space if needed, or keep small */
        .small-mobile-text { 
            font-size: 0.9rem; 
            margin-bottom: 1rem !important; 
            color: rgba(255,255,255,0.9) !important;
            display: inline-block; /* Fix width issues */
            width: 100% !important;
        }
        
        .row.h-100 {
            height: auto !important;
            display: block; /* Normalize row behavior */
        }
        
        .col-lg-7 {
            padding: 0 !important; /* Remove bootstrap padding */
            position: static; /* Let container handle positioning */
        }
    }

    .hover-lift { transition: transform 0.2s ease, box-shadow 0.2s ease; }
    .hover-lift:hover { transform: translateY(-3px); box-shadow: 0 5px 15px rgba(0,0,0,0.1) !important; }

    /* Custom Carousel Indicators */
    .carousel-indicators {
        bottom: 10px; /* Lower on mobile */
    }
    @media (min-width: 992px) {
        .carousel-indicators {
            bottom: 30px;
            margin-bottom: 2rem;
        }
    }
    .carousel-indicators [data-bs-target] {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background-color: #fff;
        opacity: 0.5;
        margin: 0 6px;
        border: none;
        transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
    }
    .carousel-indicators .active {
        width: 35px; /* The "Dash" */
        border-radius: 4px;
        opacity: 1;
        background-color: #fff;
    }
    
    /* Ensure only 5 dots max are shown nicely or just let them wrap? Usually okay to leave default wrap behaviour */
</style>

<!-- Result Search Section Removed as per user request -->

<!-- About Section Removed as per user request -->

<!-- News Ticker Section -->
<div class="bg-primary py-2 text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-auto">
                <span class="badge bg-warning text-dark fw-bold px-3 py-2 rounded-pill shadow-sm">
                    <i class="fas fa-bell me-1"></i> NOTICE
                </span>
            </div>
            <div class="col overflow-hidden">
                <marquee behavior="scroll" direction="left" onmouseover="this.stop();" onmouseout="this.start();">
                    <?php if(isset($latest_notices)): ?>
                        <?php $__currentLoopData = $latest_notices->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('notice.details', $notice->id)); ?>" class="text-white text-decoration-none fw-medium me-5 d-inline-block">
                                <i class="fas fa-dot-circle small text-warning me-2"></i> <?php echo e($notice->title); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </marquee>
            </div>
        </div>
    </div>
</div>

<!-- Main Content Section: Principal (Left) & Notices (Right) -->
<section class="py-5 bg-light">
    <div class="container py-lg-4">
        <div class="row g-4">
            <!-- Left Side: Principal Message (Premium Card) -->
            <div class="col-lg-4">
                <div class="card border-0 rounded-4 overflow-hidden h-100 bg-white principal-card">
                    <div class="position-relative">
                        <!-- Modern Header with Subtle Gradient -->
                        <div class="principal-header" style="height: 120px; background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%); position: relative; overflow: hidden;">
                            <!-- Animated Background Pattern -->
                            <div class="header-pattern"></div>
                        </div>
                         <?php
                            $p_image = $website_settings['principal_image'] ?? null;
                            $principal_img = 'https://via.placeholder.com/400x500?text=Principal';
                             if ($p_image) {
                                 if (Str::startsWith($p_image, 'http')) {
                                    $principal_img = $p_image;
                                } elseif (Str::startsWith($p_image, 'storage/')) {
                                    $principal_img = asset($p_image);
                                } else {
                                    $principal_img = asset('storage/' . $p_image);
                                }
                            }
                        ?>
                        <div class="text-center px-3 px-md-4 position-relative" style="margin-top: -60px;">
                            <div class="position-relative d-inline-block">
                                <div class="principal-avatar-wrapper">
                                    <img src="<?php echo e($principal_img); ?>" class="principal-avatar" alt="Principal" style="width: 130px; height: 130px; object-fit: cover;">
                                </div>
                                <!-- Status Indicator -->
                                <div class="position-absolute bottom-0 end-0">
                                    <span class="status-dot"></span>
                                </div>
                            </div>
                            <h5 class="fw-bold mt-3 mb-1 text-dark"><?php echo e($website_settings['principal_name'] ?? 'Principal Name'); ?></h5>
                            <span class="badge bg-primary px-3 py-2 rounded-pill mb-3 principal-badge">
                                <i class="fas fa-user-tie me-1"></i> Principal
                            </span>
                        </div>
                    </div>
                    
                    <div class="card-body px-3 px-md-4 pb-4 pt-2 text-center">
                        <!-- Quote -->
                        <div class="quote-container mb-3">
                            <i class="fas fa-quote-left text-primary opacity-50"></i>
                        </div>
                        
                        <p class="text-muted mb-4 principal-message" style="font-size: 0.95rem; line-height: 1.7;">
                            <?php echo e(Str::limit($website_settings['principal_message_short'] ?? 'We welcome you to our college. Education is the most powerful weapon which you can use to change the world.', 160)); ?>

                        </p>
                        
                        <a href="<?php echo e(route('about')); ?>" class="btn btn-primary-custom w-100 fw-semibold rounded-pill py-3">
                            <span>Principal's Message</span>
                            <i class="fas fa-arrow-right ms-2 arrow-icon"></i>
                        </a>
                    </div>
                </div>
            </div>


            <!-- Right Side: Notice Board (Main Content) -->
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm rounded-4 h-100 overflow-hidden">
                    <div class="card-header bg-white border-0 py-3 px-4 d-flex justify-content-between align-items-center border-bottom border-light">
                        <div class="d-flex align-items-center">
                            <div class="icon-box bg-primary bg-opacity-10 text-primary rounded-circle p-2 me-3">
                                <i class="fas fa-clipboard-list fa-lg"></i>
                            </div>
                            <h4 class="fw-bold font-serif mb-0 text-dark">Notice Board</h4>
                        </div>
                        <a href="<?php echo e(route('notice')); ?>" class="btn btn-link text-primary fw-bold text-decoration-none small">
                            View All <i class="fas fa-external-link-alt ms-1"></i>
                        </a>
                    </div>
                    
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                             <?php if(isset($pinned_notices) && $pinned_notices->count() > 0): ?>
                                <?php $__currentLoopData = $pinned_notices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="list-group-item p-3 bg-warning bg-opacity-10 border-start border-5 border-warning border-bottom">
                                        <div class="d-flex gap-3 align-items-start">
                                            <div class="text-center flex-shrink-0 pt-1" style="min-width: 70px;">
                                                 <div class="bg-white rounded p-1 shadow-sm border border-warning">
                                                    <span class="d-block h5 mb-0 fw-bold text-dark"><?php echo e($notice->published_at->format('d')); ?></span>
                                                    <span class="d-block small text-uppercase fw-bold text-muted"><?php echo e($notice->published_at->format('M')); ?></span>
                                                 </div>
                                            </div>
                                            <div class="flex-grow-1">
                                                <span class="badge bg-warning text-dark mb-1"><i class="fas fa-thumbtack me-1"></i> Important</span>
                                                <h6 class="mb-1 fw-bold">
                                                    <a href="<?php echo e(route('notice.details', $notice->id)); ?>" class="text-dark text-decoration-none hover-primary stretched-link text-break">
                                                        <?php echo e($notice->title); ?>

                                                    </a>
                                                </h6>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                             <?php if(isset($latest_notices)): ?>
                                <?php $__currentLoopData = $latest_notices->take(7); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="list-group-item p-3 hover-bg-light transition border-bottom">
                                        <div class="d-flex gap-3 align-items-center">
                                            <i class="fas fa-caret-right text-primary"></i>
                                            <div class="flex-grow-1">
                                                <a href="<?php echo e(route('notice.details', $notice->id)); ?>" class="text-dark text-decoration-none hover-primary fw-medium text-break">
                                                    <?php echo e(Str::limit($notice->title, 100)); ?>

                                                </a>
                                                 <small class="text-muted ms-2 d-none d-md-inline-block">- <?php echo e($notice->published_at->format('d M, Y')); ?></small>
                                            </div>
                                            <div class="text-end d-md-none">
                                                <small class="text-muted" style="font-size: 0.75rem;"><?php echo e($notice->published_at->format('d/m')); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<!-- Teachers Section -->
<section class="py-5 bg-white">
    <div class="container py-3">
        <div class="text-center mb-4">
            <span class="badge bg-primary bg-opacity-10 text-primary px-3 py-2 rounded-pill fw-semibold mb-2">Our Excellence</span>
            <h2 class="fw-bold font-serif mb-2">Expert Faculty Members</h2>
            <div class="mx-auto bg-primary" style="width: 50px; height: 3px; border-radius: 2px;"></div>
        </div>
        
        <div class="row g-3 g-md-4 justify-content-center">
             <?php if(isset($teachers)): ?>
                <?php $__currentLoopData = $teachers->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-6 col-md-6 col-lg-3">
                    <div class="teacher-card">
                        <div class="teacher-card-inner">
                            <div class="teacher-avatar-container">
                                <?php if($teacher->photo): ?>
                                    <?php
                                        $photoPath = $teacher->photo;
                                        if (!Str::startsWith($photoPath, 'storage') && !Str::startsWith($photoPath, 'http')) {
                                            $photoPath = 'storage/' . $photoPath;
                                        }
                                    ?>
                                    <img src="<?php echo e(asset($photoPath)); ?>" class="teacher-avatar" alt="<?php echo e($teacher->name); ?>">
                                <?php else: ?>
                                    <div class="teacher-avatar-placeholder">
                                        <i class="fas fa-user-tie fa-3x text-muted"></i>
                                    </div>
                                <?php endif; ?>
                                <!-- Status Indicator -->
                                <span class="status-indicator"></span>
                            </div>
                            
                            <div class="teacher-info">
                                <h6 class="teacher-name"><?php echo e($teacher->name); ?></h6>
                                <p class="teacher-designation"><?php echo e($teacher->designation); ?></p>
                                <p class="teacher-department"><?php echo e(Str::limit($teacher->department, 30)); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        
        <div class="text-center mt-4">
             <a href="<?php echo e(route('teachers')); ?>" class="btn btn-primary rounded-pill px-4 py-2 btn-view-all">
                View All Faculty
                <i class="fas fa-arrow-right ms-2 small"></i>
             </a>
        </div>
    </div>
</section>

<!-- Gallery Preview Section -->
<?php if(isset($gallery_items) && count($gallery_items) > 0): ?>
<section class="py-5 bg-white">
    <div class="container">
        <div class="text-center mb-5">
             <h5 class="text-primary fw-bold text-uppercase">Campus Life</h5>
             <h2 class="font-serif fw-bold display-6">Recent Gallery</h2>
        </div>
        <div class="row g-3">
            <?php $__currentLoopData = $gallery_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-6 col-md-4 col-lg-4">
                    <div class="rounded-3 overflow-hidden shadow-sm position-relative group" style="height: 200px;">
                         <!-- Try common fields for image -->
                         <?php $img = $item->image_url ?? $item->image_path ?? $item->image ?? $item->file_path ?? ''; ?>
                         <img src="<?php echo e(asset($img)); ?>" class="w-100 h-100 transition-all" alt="Gallery" style="object-fit: cover; cursor: pointer; transition: transform 0.5s;">
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<style>
    .transition-all { transition: all 0.3s ease; }
    .ls-1 { letter-spacing: 1px; }
    
    /* Principal Card Premium Styles */
    .principal-card {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }
    
    .principal-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 28px rgba(0, 0, 0, 0.12);
    }
    
    /* Animated Header Pattern */
    .header-pattern {
        position: absolute;
        top: 0;
        left: 0;
        width: 200%;
        height: 100%;
        background: repeating-linear-gradient(
            45deg,
            transparent,
            transparent 10px,
            rgba(255, 255, 255, 0.05) 10px,
            rgba(255, 255, 255, 0.05) 20px
        );
        animation: slide 20s linear infinite;
    }
    
    @keyframes slide {
        0% { transform: translateX(0); }
        100% { transform: translateX(-50%); }
    }
    
    /* Avatar Styles */
    .principal-avatar-wrapper {
        position: relative;
        display: inline-block;
        border-radius: 20px;
        padding: 4px;
        background: linear-gradient(135deg, #3b82f6, #8b5cf6);
        box-shadow: 0 8px 24px rgba(59, 130, 246, 0.25);
        transition: all 0.3s ease;
    }
    
    .principal-card:hover .principal-avatar-wrapper {
        transform: scale(1.05);
        box-shadow: 0 12px 32px rgba(59, 130, 246, 0.35);
    }
    
    .principal-avatar {
        border-radius: 16px;
        border: 4px solid white;
        display: block;
        transition: all 0.3s ease;
    }
    
    /* Status Dot */
    .status-dot {
        display: inline-block;
        width: 16px;
        height: 16px;
        background: #10b981;
        border: 3px solid white;
        border-radius: 50%;
        box-shadow: 0 2px 8px rgba(16, 185, 129, 0.4);
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.7; }
    }
    
    /* Badge */
    .principal-badge {
        font-size: 0.85rem;
        font-weight: 600;
        letter-spacing: 0.5px;
        box-shadow: 0 2px 8px rgba(59, 130, 246, 0.2);
        transition: all 0.3s ease;
    }
    
    .principal-card:hover .principal-badge {
        transform: scale(1.05);
    }
    
    /* Quote Container */
    .quote-container i {
        font-size: 1.5rem;
        transition: all 0.3s ease;
    }
    
    .principal-card:hover .quote-container i {
        transform: scale(1.1);
        opacity: 0.7 !important;
    }
    
    /* Message Text */
    .principal-message {
        transition: color 0.3s ease;
    }
    
    .principal-card:hover .principal-message {
        color: #374151 !important;
    }
    
    /* Premium Button */
    .btn-primary-custom {
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        border: none;
        color: white;
        font-weight: 600;
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
    }
    
    .btn-primary-custom::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.6s ease;
    }
    
    .btn-primary-custom:hover::before {
        left: 100%;
    }
    
    .btn-primary-custom:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(59, 130, 246, 0.4);
        color: white;
        background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
    }
    
    .arrow-icon {
        transition: transform 0.3s ease;
    }
    
    .btn-primary-custom:hover .arrow-icon {
        transform: translateX(4px);
    }
    
    /* Responsive Adjustments */
    @media (max-width: 991px) {
        .principal-avatar-wrapper {
            box-shadow: 0 6px 18px rgba(59, 130, 246, 0.2);
        }
        
        .principal-card {
            margin-bottom: 1.5rem;
        }
    }
    
    @media (max-width: 576px) {
        .principal-avatar,
        .principal-avatar-wrapper img {
            width: 110px !important;
            height: 110px !important;
        }
        
        .principal-card:hover {
            transform: translateY(-4px);
        }
        
        .btn-primary-custom {
            padding-top: 0.75rem !important;
            padding-bottom: 0.75rem !important;
            font-size: 0.95rem;
        }
    }
    
    /* Teacher Cards Styles */
    .teacher-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem 1rem;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
    }
    
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Staggered Animation */
    .teacher-card:nth-child(1) { animation-delay: 0.1s; }
    .teacher-card:nth-child(2) { animation-delay: 0.2s; }
    .teacher-card:nth-child(3) { animation-delay: 0.3s; }
    .teacher-card:nth-child(4) { animation-delay: 0.4s; }
    
    .teacher-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.12);
    }
    
    .teacher-card-inner {
        text-align: center;
    }
    
    /* Avatar Container */
    .teacher-avatar-container {
        position: relative;
        width: 120px;
        height: 120px;
        margin: 0 auto 1rem;
    }
    
    .teacher-avatar {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 50%;
        border: 4px solid #f3f4f6;
        transition: all 0.3s ease;
    }
    
    .teacher-card:hover .teacher-avatar {
        border-color: #3b82f6;
        transform: scale(1.05);
    }
    
    .teacher-avatar-placeholder {
        width: 100%;
        height: 100%;
        background: #f3f4f6;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 4px solid #e5e7eb;
    }
    
    /* Status Indicator */
    .status-indicator {
        position: absolute;
        bottom: 5px;
        right: 5px;
        width: 14px;
        height: 14px;
        background: #10b981;
        border: 3px solid white;
        border-radius: 50%;
        animation: pulse 2s infinite;
    }
    
    /* Teacher Info */
    .teacher-info {
        padding: 0 0.5rem;
    }
    
    .teacher-name {
        font-size: 1rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.25rem;
        transition: color 0.3s ease;
    }
    
    .teacher-card:hover .teacher-name {
        color: #3b82f6;
    }
    
    .teacher-designation {
        font-size: 0.8rem;
        color: #3b82f6;
        font-weight: 600;
        margin-bottom: 0.25rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .teacher-department {
        font-size: 0.85rem;
        color: #6b7280;
        margin-bottom: 0;
    }
    
    /* View All Button */
    .btn-view-all {
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(59, 130, 246, 0.2);
    }
    
    .btn-view-all:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(59, 130, 246, 0.3);
    }
    
    .btn-view-all i {
        transition: transform 0.3s ease;
    }
    
    .btn-view-all:hover i {
        transform: translateX(4px);
    }
    
    /* Responsive Adjustments for Teachers */
    @media (max-width: 991px) {
        .teacher-avatar-container {
            width: 100px;
            height: 100px;
        }
    }
    
    @media (max-width: 576px) {
        .teacher-card {
            padding: 1rem 0.75rem;
        }
        
        .teacher-avatar-container {
            width: 90px;
            height: 90px;
        }
        
        .teacher-name {
            font-size: 0.9rem;
        }
        
        .teacher-designation {
            font-size: 0.75rem;
        }
        
        .teacher-department {
            font-size: 0.8rem;
        }
        
        .teacher-card:hover {
            transform: translateY(-5px);
        }
    }
</style>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/frontend/index.blade.php ENDPATH**/ ?>