

<?php $__env->startSection('title', 'Student Profile: ' . $student->name); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('students.index')); ?>">Students</a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e($student->class_roll); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    <?php if(!$student->trashed()): ?>
        <a href="<?php echo e(route('students.edit', $student)); ?>" class="btn btn-warning text-white me-2">
            <i class="bi bi-pencil-square me-1"></i> Edit Profile
        </a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row g-4">
    <!-- Profile Card Sidebar -->
    <div class="col-12 col-md-4 col-lg-3">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body text-center pt-5">
                <div class="mb-4 position-relative d-inline-block">
                     <?php if($student->photo): ?>
                        <img src="<?php echo e(asset('storage/'.$student->photo)); ?>" class="rounded-circle shadow-sm p-1 bg-white" width="120" height="120" style="object-fit: cover;">
                    <?php else: ?>
                        <div class="avatar-xl rounded-circle bg-light border d-flex align-items-center justify-content-center mx-auto shadow-sm" style="width: 120px; height: 120px;">
                            <span class="fs-1 text-muted fw-bold"><?php echo e(substr($student->name, 0, 1)); ?></span>
                        </div>
                    <?php endif; ?>
                    <span class="position-absolute bottom-0 end-0 p-2 bg-success border border-white rounded-circle indicator"></span>
                </div>
                
                <h5 class="fw-bold mb-1"><?php echo e($student->name); ?></h5>
                <p class="text-muted small mb-3"><?php echo e($student->ssc_reg_no); ?></p>

                <div class="d-flex justify-content-center gap-2 mb-4">
                    <span class="badge bg-light text-dark border"><?php echo e($student->group); ?></span>
                    <span class="badge bg-light text-dark border">Class <?php echo e($student->class); ?></span>
                </div>

                <hr>

                <div class="text-start">
                    <div class="mb-3">
                         <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">PERSONAL INFO</label>
                         <div class="mb-1"><strong class="me-1">Father:</strong> <?php echo e($student->father_name ?? 'N/A'); ?></div>
                         <div class="mb-1"><strong class="me-1">Mother:</strong> <?php echo e($student->mother_name ?? 'N/A'); ?></div>
                         <div class="mb-1"><strong class="me-1">DOB:</strong> <?php echo e($student->date_of_birth ? date('d M Y', strtotime($student->date_of_birth)) : 'N/A'); ?></div>
                         <div class="mb-1"><strong class="me-1">Gender:</strong> <?php echo e($student->gender ?? 'N/A'); ?></div>
                    </div>

                    <div class="mb-3">
                        <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">CLASS ROLL</label>
                        <span class="fw-bold fs-5 text-primary font-monospace"><?php echo e($student->class_roll); ?></span>
                    </div>
                    <div class="mb-3">
                         <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">CONTACT</label>
                         <div><i class="bi bi-telephone me-2 text-muted"></i> <?php echo e($student->phone ?? 'N/A'); ?></div>
                         <div><i class="bi bi-envelope me-2 text-muted"></i> <?php echo e($student->email ?? 'N/A'); ?></div>
                    </div>
                    <div>
                         <label class="small text-muted d-block uppercase fw-bold" style="font-size: 10px;">ADDRESS</label>
                         <p class="small text-muted mb-0"><?php echo e($student->address ?? 'N/A'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="col-12 col-md-8 col-lg-9">
        
        <!-- Academic Summary -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold">Academic Overview</h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">SSC Batch</small>
                             <h6 class="fw-bold mb-0"><?php echo e($student->ssc_batch); ?></h6>
                         </div>
                    </div>
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">HSC Batch</small>
                             <h6 class="fw-bold mb-0"><?php echo e($student->hsc_batch); ?></h6>
                         </div>
                    </div>
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">Status</small>
                             <h6 class="fw-bold mb-0 <?php echo e($student->status == 'active' ? 'text-success' : 'text-danger'); ?>"><?php echo e(ucfirst($student->status)); ?></h6>
                         </div>
                    </div>
                    <div class="col-6 col-md-3">
                         <div class="p-3 bg-light rounded text-center">
                             <small class="text-muted d-block mb-1">Joined</small>
                             <h6 class="fw-bold mb-0"><?php echo e($student->created_at->format('M Y')); ?></h6>
                         </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Subjects -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">Assigned Subjects</h6>
                <span class="badge bg-primary rounded-pill"><?php echo e($student->subjects->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="bg-light">
                        <tr>
                            <th class="ps-4">Code</th>
                            <th>Subject Name</th>
                            <th>Type</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $student->subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="ps-4 fw-mono text-muted"><?php echo e($subject->code); ?></td>
                                <td class="fw-semibold"><?php echo e($subject->name); ?></td>
                                <td>
                                    <?php if($subject->pivot->is_optional): ?>
                                        <span class="badge bg-warning-subtle text-warning-emphasis">4th Subject</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary-subtle text-secondary-emphasis">Mandatory</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="3" class="text-center py-4 text-muted">No subjects assigned.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Audit Log -->
        <div class="card shadow-sm border-0">
             <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold text-muted small uppercase">Recent Activity</h6>
            </div>
            <div class="list-group list-group-flush">
                <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item px-4 py-3 border-bottom-0">
                        <div class="d-flex justify-content-between">
                            <div>
                                <span class="badge bg-light text-dark border me-2"><?php echo e(strtoupper($log->action)); ?></span>
                                <span class="small text-muted">by System/Admin</span>
                            </div>
                            <small class="text-muted"><?php echo e($log->created_at->diffForHumans()); ?></small>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="p-4 text-center text-muted small">No recent activity recorded.</div>
                <?php endif; ?>
            </div>
        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/students/show.blade.php ENDPATH**/ ?>