

<?php $__env->startSection('title', 'Faculty Members - ' . ($global_settings['college_name'] ?? 'College Name')); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row mb-5 animate-up">
        <div class="col-lg-8 mx-auto text-center">
            <h2 class="font-serif fw-bold display-5 mb-3">Our Expert Faculty</h2>
            <div class="d-flex justify-content-center mb-4">
                <div style="height: 3px; width: 60px; background: var(--primary); border-radius: 2px;"></div>
            </div>
            <p class="text-muted lead">Meet our dedicated team of educators committed to shaping the future leaders.</p>
        </div>
    </div>

    <?php if($teachers->count() > 0): ?>
    <div class="row g-3 g-lg-4">
        <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-6 col-md-4 col-lg-3 animate-up" style="animation-delay: <?php echo e($loop->index * 0.1); ?>s;">
            <div class="card h-100 border-0 shadow-sm hover-shadow transition-all bg-white rounded-4 overflow-hidden group">
                <div class="position-relative overflow-hidden">
                    <!-- Image Container with Aspect Ratio -->
                    <div class="ratio ratio-1x1 bg-light">
                        <?php if($teacher->photo): ?>
                            <img src="<?php echo e(asset('storage/' . $teacher->photo)); ?>" 
                                 class="card-img-top object-fit-cover transition-transform" 
                                 alt="<?php echo e($teacher->name); ?>"
                                 style="transition: transform 0.5s ease;">
                        <?php else: ?>
                            <div class="d-flex align-items-center justify-content-center h-100 bg-secondary bg-opacity-10 text-secondary display-1">
                                <i class="fas fa-user-tie"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="card-body text-center p-3 p-lg-4">
                    <h5 class="fw-bold text-dark mb-1 font-serif fs-6 fs-lg-5"><?php echo e($teacher->name); ?></h5>
                    <p class="text-primary small fw-semibold text-uppercase letter-spacing-1 mb-2">
                        <?php echo e($teacher->designation); ?>

                    </p>
                    <?php if($teacher->department): ?>
                        <span class="badge bg-light text-secondary rounded-pill px-2 py-1 px-lg-3 py-lg-2 fw-normal small">
                            <?php echo e($teacher->department); ?>

                        </span>
                    <?php endif; ?>
                    
                    <?php if($teacher->qualification): ?>
                        <p class="text-muted small mt-2 mt-lg-3 mb-0 line-clamp-2 d-none d-sm-block">
                            <?php echo e(Str::limit($teacher->qualification, 50)); ?>

                        </p>
                    <?php endif; ?>
                </div>
                
                <!-- Social/Contact Overlay or Footer can go here -->
                <div class="card-footer bg-white border-0 pt-0 pb-3 pb-lg-4 text-center">
                     <?php if($teacher->email): ?>
                        <a href="mailto:<?php echo e($teacher->email); ?>" class="btn btn-sm btn-outline-primary rounded-circle mx-1" style="width: 28px; height: 28px; display: inline-flex; align-items: center; justify-content: center;">
                            <i class="fas fa-envelope fs-xs"></i>
                        </a>
                     <?php endif; ?>
                     <?php if($teacher->phone): ?>
                        <a href="tel:<?php echo e($teacher->phone); ?>" class="btn btn-sm btn-outline-primary rounded-circle mx-1" style="width: 28px; height: 28px; display: inline-flex; align-items: center; justify-content: center;">
                            <i class="fas fa-phone fs-xs"></i>
                        </a>
                     <?php endif; ?>

                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    
    <div class="mt-5 d-flex justify-content-center">
        <!-- Pagination if needed -->
        
    </div>
    
    <?php else: ?>
    <div class="text-center py-5">
        <div class="mb-3 text-muted display-1 opacity-25">
            <i class="fas fa-users-slash"></i>
        </div>
        <h4>No faculty members found.</h4>
    </div>
    <?php endif; ?>
</div>

<style>
    .hover-shadow:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.08) !important;
    }
    .transition-all {
        transition: all 0.3s ease;
    }
    .group:hover .card-img-top {
        transform: scale(1.05);
    }
    .letter-spacing-1 {
        letter-spacing: 1px;
    }
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    
    /* Animation Fade Up */
    .animate-up {
        animation: fadeInUp 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
        opacity: 0;
        transform: translateY(20px);
    }
    
    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .fs-xs { font-size: 0.75rem; }
    
    /* Mobile responsive adjustments */
    @media (max-width: 576px) {
        .card-body { padding: 0.75rem !important; }
        .fs-6 { font-size: 0.9rem !important; }
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/frontend/teachers.blade.php ENDPATH**/ ?>