

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="row g-4 mb-4">
    <!-- Stat Cards -->
    <div class="col-12 col-sm-6 col-lg-3">
        <?php echo $__env->make('admin.components.stat-card', [
            'title' => 'Total Students',
            'value' => $stats['students'],
            'icon' => 'people',
            'color' => 'primary',
            'trend' => null
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    
    <div class="col-12 col-sm-6 col-lg-3">
        <?php echo $__env->make('admin.components.stat-card', [
            'title' => 'Total Batches',
            'value' => $stats['batches'],
            'icon' => 'layers',
            'color' => 'success',
            'trend' => null
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <div class="col-12 col-sm-6 col-lg-3">
        <?php echo $__env->make('admin.components.stat-card', [
            'title' => 'Total Teachers',
            'value' => $stats['teachers'],
            'icon' => 'person-badge',
            'color' => 'info',
            'trend' => null
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <div class="col-12 col-sm-6 col-lg-3">
        <?php echo $__env->make('admin.components.stat-card', [
            'title' => 'Active Exams',
            'value' => $stats['pending_results'],
            'icon' => 'clipboard-data',
            'color' => 'warning',
            'trend' => null
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
</div>

<div class="row g-4">
    <!-- Charts / Main Content -->
    <div class="col-12 col-lg-8">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">Recent Registrations</h6>
                <a href="<?php echo e(route('students.index')); ?>" class="btn btn-sm btn-light">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4">Student</th>
                                <th>Roll</th>
                                <th>Class</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentStudents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="ps-4">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm rounded-circle bg-primary-subtle text-primary d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px; font-size: 12px;">
                                                <?php echo e(substr($student->name, 0, 1)); ?>

                                            </div>
                                            <div>
                                                <h6 class="mb-0 text-sm fw-semibold text-dark"><?php echo e($student->name); ?></h6>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-sm text-muted"><?php echo e($student->roll); ?></td>
                                    <td class="text-sm text-muted"><?php echo e($student->current_class); ?></td>
                                    <td class="text-sm text-muted"><?php echo e($student->created_at->format('M d, Y')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center py-4 text-muted small">No new students found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Sidebar -->
    <div class="col-12 col-lg-4">
        <!-- Quick Actions -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('students.create')); ?>" class="btn btn-primary d-flex align-items-center justify-content-between">
                        <span><i class="bi bi-person-plus me-2"></i> Add New Student</span>
                        <i class="bi bi-chevron-right small"></i>
                    </a>
                    <a href="<?php echo e(route('exams.create')); ?>" class="btn btn-light border d-flex align-items-center justify-content-between hover-bg-gray-100">
                        <span><i class="bi bi-pencil-square me-2"></i> Create Exam</span>
                        <i class="bi bi-chevron-right small"></i>
                    </a>
                    <a href="<?php echo e(route('notices.create')); ?>" class="btn btn-light border d-flex align-items-center justify-content-between hover-bg-gray-100">
                        <span><i class="bi bi-megaphone me-2"></i> Publish Notice</span>
                        <i class="bi bi-chevron-right small"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- System Alerts / Recent Notices -->
        <div class="card shadow-sm border-0">
             <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">Recent Notices</h6>
            </div>
            <div class="list-group list-group-flush">
                <?php $__empty_1 = true; $__currentLoopData = $recentNotices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="#" class="list-group-item list-group-item-action border-0 px-4 py-3">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1 text-sm fw-semibold text-dark"><?php echo e(Str::limit($notice->title, 30)); ?></h6>
                            <small class="text-muted" style="font-size: 11px;"><?php echo e($notice->created_at->diffForHumans()); ?></small>
                        </div>
                        <p class="mb-0 text-xs text-muted"><?php echo e(Str::limit(strip_tags($notice->content), 50)); ?></p>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                     <div class="text-center py-4 text-muted small">No recent notices.</div>
                <?php endif; ?>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>