

<?php $__env->startSection('title', 'Result Search - ' . ($global_settings['college_name'] ?? 'College Name')); ?>

<?php $__env->startSection('content'); ?>

<div class="result-page-wrapper py-5 bg-light position-relative overflow-hidden">
    <!-- Decor bg shapes -->
    <div class="position-absolute top-0 start-0 translate-middle rounded-circle bg-primary opacity-5 p-5 blur-3xl" style="width: 400px; height: 400px; filter: blur(80px);"></div>
    <div class="position-absolute bottom-0 end-0 translate-middle rounded-circle bg-info opacity-5 p-5 blur-3xl" style="width: 300px; height: 300px; filter: blur(60px);"></div>

    <div class="container py-4 position-relative z-1">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb" class="mb-5 animate-up">
             <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>" class="text-muted text-decoration-none small text-uppercase fw-bold ls-1"><i class="fas fa-home me-1"></i> Home</a></li>
                <li class="breadcrumb-item active text-primary small text-uppercase fw-bold ls-1" aria-current="page">Results</li>
            </ol>
        </nav>

        <div class="row g-5 align-items-center">
            
            <!-- Left Side: Hero / Info -->
            <div class="col-lg-6 animate-up">
                <div class="pe-lg-5">
                    <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3 py-2 mb-3 fw-semibold">
                        <i class="fas fa-bolt me-1"></i> Fast & Secure Result Check
                    </span>
                    <h1 class="font-serif display-4 fw-bold text-dark mb-4">
                        Discover Your <br>
                        <span class="text-primary position-relative">Academic Excellence
                            <svg class="position-absolute start-0 bottom-0 w-100 text-warning opacity-50" height="12" viewBox="0 0 100 12" preserveAspectRatio="none" style="z-index: -1;">
                                <path d="M0,10 Q50,0 100,10" stroke="currentColor" stroke-width="8" fill="none" />
                            </svg>
                        </span>
                    </h1>
                    <p class="lead text-muted mb-4 opacity-75">
                        Access your academic performance records instantly. Enter your examination details and unique identifier to view and download your result sheet.
                    </p>
                    
                    <div class="d-flex gap-4 pt-2">
                        <div class="d-flex align-items-center gap-3">
                            <div class="icon-square bg-white shadow-sm text-success rounded-circle d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                                <i class="fas fa-check-circle fa-lg"></i>
                            </div>
                            <div>
                                <h6 class="fw-bold mb-0">Official Records</h6>
                                <p class="small text-muted mb-0">Verified 100% Accurate</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-3">
                            <div class="icon-square bg-white shadow-sm text-info rounded-circle d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                                <i class="fas fa-print fa-lg"></i>
                            </div>
                            <div>
                                <h6 class="fw-bold mb-0">Print Ready</h6>
                                <p class="small text-muted mb-0">Download & Print Marks</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Side: Search Form -->
            <div class="col-lg-5 offset-lg-1 animate-up" style="animation-delay: 0.2s;">
                <div class="card border-0 shadow-xl rounded-4 overflow-hidden position-relative">
                    <div class="position-absolute top-0 start-0 w-100 h-1 bg-gradient-primary"></div>
                    
                    <div class="card-body p-4 p-md-5 bg-white">
                        <div class="text-center mb-4">
                           <div class="d-inline-flex align-items-center justify-content-center bg-primary bg-opacity-10 text-primary rounded-circle mb-3" style="width: 64px; height: 64px;">
                               <img src="https://cdn-icons-png.flaticon.com/512/2995/2995620.png" width="32" alt="Exam">
                           </div>
                           <h3 class="fw-bold font-serif mb-1">Check Result</h3>
                           <p class="text-muted small">Fill the form to search your result</p>
                        </div>

                        <?php if(session('error')): ?>
                            <div class="alert alert-danger mb-4 border-0 shadow-sm rounded-3 d-flex align-items-center gap-2">
                                <i class="fas fa-exclamation-circle text-danger fs-5"></i>
                                <div><?php echo e(session('error')); ?></div>
                            </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('result.search')); ?>" method="POST" class="needs-validation" novalidate id="resultForm">
                            <?php echo csrf_field(); ?>
                            
                            <div class="row g-3 mb-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-bold small text-uppercase text-muted ls-1 mb-2">
                                        <i class="fas fa-graduation-cap me-1"></i> HSC Batch
                                    </label>
                                    <div class="position-relative">
                                        <span class="position-absolute top-50 start-0 translate-middle-y ps-3 text-muted" style="z-index: 10;">
                                            <i class="fas fa-calendar-alt"></i>
                                        </span>
                                        <select name="batch_id" id="batch_id" class="form-select form-select-lg bg-white border-2 rounded-3 fs-6 py-3 ps-5 shadow-sm" required style="cursor: pointer;">
                                            <option value="">Select Batch...</option>
                                            <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-bold small text-uppercase text-muted ls-1 mb-2">
                                        <i class="fas fa-school me-1"></i> Class
                                    </label>
                                    <div class="position-relative">
                                        <span class="position-absolute top-50 start-0 translate-middle-y ps-3 text-muted" style="z-index: 10;">
                                            <i class="fas fa-book-open"></i>
                                        </span>
                                        <select name="class_year" id="class_year" class="form-select form-select-lg bg-white border-2 rounded-3 fs-6 py-3 ps-5 shadow-sm" required style="cursor: pointer;">
                                            <option value="">Select Class...</option>
                                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($label); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row g-3 mb-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-bold small text-uppercase text-muted ls-1 mb-2">
                                        <i class="fas fa-id-badge me-1"></i> Class Roll
                                    </label>
                                    <div class="position-relative">
                                        <span class="position-absolute top-50 start-0 translate-middle-y ps-3 text-muted" style="z-index: 10;">
                                            <i class="fas fa-hashtag"></i>
                                        </span>
                                        <input type="number" name="roll_no" class="form-control form-control-lg bg-white border-2 rounded-3 fs-6 py-3 ps-5 shadow-sm" placeholder="Enter Roll Number" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-bold small text-uppercase text-muted ls-1 mb-2">
                                        <i class="fas fa-id-card me-1"></i> Registration No
                                    </label>
                                    <div class="position-relative">
                                        <span class="position-absolute top-50 start-0 translate-middle-y ps-3 text-muted" style="z-index: 10;">
                                            <i class="fas fa-barcode"></i>
                                        </span>
                                        <input type="number" name="reg_no" class="form-control form-control-lg bg-white border-2 rounded-3 fs-6 py-3 ps-5 shadow-sm" placeholder="Reg No (Optional)">
                                    </div>
                                </div>
                            </div>

                            <div class="mb-5 position-relative">
                                <label class="form-label fw-bold small text-uppercase text-muted ls-1 mb-2">
                                    <i class="fas fa-file-alt me-1"></i> Result For
                                </label>
                                <div class="position-relative">
                                    <span class="position-absolute top-50 start-0 translate-middle-y ps-3 text-muted" style="z-index: 10;">
                                        <i class="fas fa-clipboard-list"></i>
                                    </span>
                                    <select name="exam_id" id="exam_id" class="form-select form-select-lg bg-white border-2 rounded-3 fs-6 py-3 ps-5 shadow-sm" required disabled style="cursor: pointer;">
                                        <option value="">Select Batch & Class first...</option>
                                    </select>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary w-100 btn-lg fw-bold rounded-pill shadow-lg hover-lift py-3 text-uppercase ls-1" id="submitBtn" disabled>
                                <span class="d-flex align-items-center justify-content-center gap-2">
                                    View Result <i class="fas fa-arrow-right"></i>
                                </span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const batchSelect = document.getElementById('batch_id');
        const classSelect = document.getElementById('class_year');
        const examSelect = document.getElementById('exam_id');
        const submitBtn = document.getElementById('submitBtn');

        function fetchExams() {
            const batchId = batchSelect.value;
            const classYear = classSelect.value;

            if (batchId && classYear) {
                // Show loading state
                examSelect.disabled = true;
                examSelect.innerHTML = '<option>Loading exams...</option>';
                submitBtn.disabled = true;

                fetch(`<?php echo e(route('get.exams')); ?>?batch_id=${batchId}&class_year=${classYear}`)
                    .then(response => response.json())
                    .then(data => {
                        examSelect.innerHTML = '<option value="">Select Exam...</option>';
                        if (data.length > 0) {
                            data.forEach(exam => {
                                const option = document.createElement('option');
                                option.value = exam.id;
                                option.textContent = exam.name;
                                examSelect.appendChild(option);
                            });
                            examSelect.disabled = false;
                        } else {
                            examSelect.innerHTML = '<option value="">No exams found</option>';
                        }
                    })
                    .catch(error => {
                        console.error('Error fetching exams:', error);
                        examSelect.innerHTML = '<option value="">Error loading exams</option>';
                    });
            } else {
                examSelect.innerHTML = '<option value="">Select Batch & Class first...</option>';
                examSelect.disabled = true;
                submitBtn.disabled = true;
            }
        }

        batchSelect.addEventListener('change', fetchExams);
        classSelect.addEventListener('change', fetchExams);
        
        examSelect.addEventListener('change', function() {
            submitBtn.disabled = !this.value;
        });
    });
</script>
<?php $__env->stopPush(); ?>

<style>
    .ls-1 { letter-spacing: 1px; }
    .text-justify { text-align: justify; }
    .shadow-xl { box-shadow: 0 20px 40px rgba(0,0,0,0.08) !important; }
    .bg-gradient-primary { background: linear-gradient(to right, var(--bs-primary), var(--bs-info)); }
    .hover-lift { transition: transform 0.3s ease, box-shadow 0.3s ease; }
    .hover-lift:hover { transform: translateY(-3px); box-shadow: 0 15px 30px rgba(13, 110, 253, 0.2) !important; }
    
    .form-control:focus, .form-select:focus {
        background-color: #fff !important;
        border-color: var(--bs-primary) !important;
        box-shadow: 0 0 0 4px rgba(13, 110, 253, 0.1) !important; 
    }
    
    .animate-up {
        animation: fadeInUp 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
        opacity: 0;
        transform: translateY(30px);
    }
    
    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .blur-3xl { filter: blur(3rem); }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/frontend/result.blade.php ENDPATH**/ ?>