

<?php $__env->startSection('title', 'Gallery & Hero Slides'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Gallery</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('hero-slides.create')); ?>" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Add New Slide
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if($slides->isEmpty()): ?>
    <div class="card p-5 text-center">
        <div class="mb-3">
             <i class="bi bi-images fs-1 text-muted opacity-50"></i>
        </div>
        <h5 class="text-muted">No slides found</h5>
        <p class="text-muted small">Add images to your homepage slider/gallery.</p>
        <div class="mt-3">
            <a href="<?php echo e(route('hero-slides.create')); ?>" class="btn btn-primary">Add First Slide</a>
        </div>
    </div>
<?php else: ?>
    <div class="row g-4">
        <?php $__currentLoopData = $slides->sortBy('sort_order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card h-100 overflow-hidden hover-shadow transition">
                    <div class="position-relative">
                        <!-- Image Preview -->
                        <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 200px; overflow: hidden;">
                            <?php if($slide->image_url): ?>
                                <img src="<?php echo e(asset($slide->image_url)); ?>" class="w-100 h-100" style="object-fit: cover;" alt="Slide Image">
                            <?php else: ?>
                                <div class="text-muted">
                                    <i class="fas fa-image fa-3x"></i>
                                </div>
                            <?php endif; ?>
                            <div class="position-absolute top-0 start-0 m-2 badge bg-dark opacity-75">
                                <i class="fas fa-arrow-down"></i> <?php echo e($slide->sort_order); ?>

                            </div>
                        </div>
                        
                        <!-- Badges Overlay -->
                        <div class="position-absolute top-0 start-0 p-2 d-flex gap-2">
                            <span class="badge bg-dark bg-opacity-75 backdrop-blur">
                                <i class="bi bi-sort-numeric-down me-1"></i> <?php echo e($slide->sort_order); ?>

                            </span>
                             <?php if(!$slide->is_active): ?>
                                <span class="badge bg-danger bg-opacity-75 backdrop-blur">Inactive</span>
                             <?php endif; ?>
                        </div>
                    </div>

                    <div class="card-body">
                        <h5 class="card-title fw-bold text-dark mb-1 text-truncate" title="<?php echo e($slide->title); ?>"><?php echo e($slide->title ?? 'Untitled Slide'); ?></h5>
                        <p class="card-text text-muted small text-truncate"><?php echo e($slide->subtitle ?? 'No subtitle provided'); ?></p>
                        
                        <?php if($slide->button_text): ?>
                            <div class="mt-3">
                                <span class="badge bg-light text-dark border">
                                    <i class="bi bi-link-45deg me-1"></i> <?php echo e($slide->button_text); ?>

                                </span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="card-footer bg-white border-top-0 pt-0 pb-3 d-flex gap-2">
                        <a href="<?php echo e(route('hero-slides.edit', $slide)); ?>" class="btn btn-sm btn-outline-warning flex-fill">
                            <i class="bi bi-pencil-square me-1"></i> Edit
                        </a>
                        
                        <form action="<?php echo e(route('hero-slides.destroy', $slide)); ?>" method="POST" class="flex-fill" onsubmit="return confirm('Are you sure you want to delete this slide?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-outline-danger w-100">
                                <i class="bi bi-trash me-1"></i> Delete
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Alert / Tip -->
    <div class="mt-4 p-3 bg-light border rounded d-flex align-items-center">
        <i class="bi bi-info-circle text-primary me-3 fs-4"></i>
        <div class="small text-muted">
            <strong class="text-dark">Pro Tip:</strong> Use high-quality images (1920x600 recommended) for the best homepage experience. Slides are displayed in the order specified above.
        </div>
    </div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/hero-slides/index.blade.php ENDPATH**/ ?>