

<?php $__env->startSection('title', 'Add New Teacher'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('teachers.index')); ?>">Teachers</a></li>
    <li class="breadcrumb-item active" aria-current="page">Add New</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-lg-10">
        <form action="<?php echo e(route('teachers.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <!-- Basic Information -->
            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-person me-2 text-primary"></i>Teacher Information</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <label for="name" class="form-label small fw-bold text-muted">Full Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" placeholder="Enter teacher's full name" required value="<?php echo e(old('name')); ?>">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="designation" class="form-label small fw-bold text-muted">Designation <span class="text-danger">*</span></label>
                            <input type="text" name="designation" id="designation" class="form-control" placeholder="e.g. Principal, Lecturer" required value="<?php echo e(old('designation')); ?>">
                            <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="department" class="form-label small fw-bold text-muted">Department</label>
                            <input type="text" name="department" id="department" class="form-control" placeholder="e.g. Science, Mathematics" value="<?php echo e(old('department')); ?>">
                        </div>

                         <div class="col-md-6">
                            <label for="email" class="form-label small fw-bold text-muted">Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Email address" value="<?php echo e(old('email')); ?>">
                        </div>

                         <div class="col-md-6">
                            <label for="phone" class="form-label small fw-bold text-muted">Phone</label>
                            <input type="text" name="phone" id="phone" class="form-control" placeholder="Phone number" value="<?php echo e(old('phone')); ?>">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Qualification & Bio -->
            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-mortarboard me-2 text-primary"></i>Details & Qualification</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                         <div class="col-md-6">
                            <label for="qualification" class="form-label small fw-bold text-muted">Qualification</label>
                            <textarea name="qualification" id="qualification" class="form-control" rows="3" placeholder="Educational degrees..."><?php echo e(old('qualification')); ?></textarea>
                        </div>
                        <div class="col-md-6">
                            <label for="specialization" class="form-label small fw-bold text-muted">Specialization</label>
                            <textarea name="specialization" id="specialization" class="form-control" rows="3" placeholder="Area of expertise..."><?php echo e(old('specialization')); ?></textarea>
                        </div>
                         <div class="col-12">
                            <label for="bio" class="form-label small fw-bold text-muted">Biography</label>
                            <textarea name="bio" id="bio" class="form-control" rows="4" placeholder="Brief biography..."><?php echo e(old('bio')); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

             <!-- Photo & Settings -->
             <div class="card mb-4 shadow-sm">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-gear me-2 text-primary"></i>Profile Settings</h6>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <div class="col-md-6">
                             <label for="photo" class="form-label small fw-bold text-muted">Photo</label>
                             <input type="file" name="photo" id="photo" class="form-control">
                             <div class="form-text small">Start with 2MB max. JPEG, PNG only.</div>
                        </div>
                        <div class="col-md-6">
                             <label for="display_order" class="form-label small fw-bold text-muted">Display Order</label>
                             <input type="number" name="display_order" id="display_order" class="form-control" value="<?php echo e(old('display_order', 0)); ?>">
                             <div class="form-text small">Lower number appears first.</div>
                        </div>

                         <div class="col-md-6">
                            <div class="form-check p-2 border rounded bg-warning bg-opacity-10 border-warning">
                                <input class="form-check-input ms-0 me-2" type="checkbox" name="is_principal" value="1" id="is_principal" <?php echo e(old('is_principal') ? 'checked' : ''); ?>>
                                <label class="form-check-label fw-bold text-warning-emphasis" for="is_principal">
                                    Mark as Principal
                                </label>
                            </div>
                        </div>
                         <div class="col-md-6">
                             <div class="form-check p-2 border rounded bg-light">
                                <input class="form-check-input ms-0 me-2" type="checkbox" name="is_active" value="1" id="is_active" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                <label class="form-check-label fw-bold" for="is_active">
                                    Active / Published
                                </label>
                            </div>
                        </div>

                    </div>
                </div>
             </div>

            <!-- Buttons -->
            <div class="d-flex justify-content-end gap-2 mb-5">
                <a href="<?php echo e(route('teachers.index')); ?>" class="btn btn-light border px-4">Cancel</a>
                <button type="submit" class="btn btn-primary px-4"><i class="bi bi-save me-1"></i> Save Teacher</button>
            </div>

        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/teachers/create.blade.php ENDPATH**/ ?>