

<?php $__env->startSection('title', 'Select Subject'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('result-management.index')); ?>">Results</a></li>
    <li class="breadcrumb-item active" aria-current="page">Select Subject</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-12">
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <div>
                     <h5 class="mb-0 fw-bold"><?php echo e($exam->name); ?></h5>
                     <small class="text-muted">Batch: <?php echo e($exam->batch->name); ?> | Year: <?php echo e($exam->start_date->format('Y')); ?> | Template: <?php echo e($exam->examTemplate->name); ?></small>
                </div>
                <a href="<?php echo e(route('result-management.index')); ?>" class="btn btn-light border">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
            
            <div class="card-body">
                <div class="row g-4">
                    <?php $__empty_1 = true; $__currentLoopData = $subjectStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-md-6 col-lg-4">
                            <div class="card h-100 border hover-shadow-sm transition">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <div>
                                            <h6 class="fw-bold mb-1"><?php echo e($s['subject']->name); ?></h6>
                                            <small class="text-muted">Code: <?php echo e($s['subject']->code); ?></small>
                                        </div>
                                        <?php if($s['pending'] > 0): ?>
                                            <span class="badge bg-danger-subtle text-danger"><?php echo e($s['pending']); ?> Pending</span>
                                        <?php else: ?>
                                            <span class="badge bg-success-subtle text-success">Completed</span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="small text-muted">Progress</span>
                                        <?php if($s['total'] == 0): ?>
                                            <span class="badge bg-success-subtle text-success rounded-pill border border-success-subtle">
                                                <i class="bi bi-check2-circle me-1"></i> No Students Assigned
                                            </span>
                                        <?php else: ?>
                                            <small class="fw-bold"><?php echo e($s['completed']); ?> / <?php echo e($s['total']); ?> Students</small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="progress mb-4" style="height: 6px;">
                                        <?php $percent = $s['total'] > 0 ? ($s['completed'] / $s['total']) * 100 : 100; ?>
                                        <div class="progress-bar bg-primary" role="progressbar" style="width: <?php echo e($percent); ?>%" aria-valuenow="<?php echo e($percent); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <a href="<?php echo e(route('result-management.subject-entry', ['exam' => $exam, 'subject' => $s['subject_id']])); ?>" class="btn btn-primary w-100">
                                            <i class="bi bi-pencil me-1"></i> Enter Marks
                                        </a>
                                    </div>
                                    <div class="mt-2 text-center">
                                         <small class="text-muted" style="font-size: 11px;">Mode: <?php echo e(ucfirst($s['paper_mode'])); ?></small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12 text-center py-5">
                            <div class="mb-3 text-muted opacity-25">
                                <i class="bi bi-exclamation-circle display-4"></i>
                            </div>
                            <h5 class="text-muted">No configuration found</h5>
                            <p class="text-muted small">No subjects are configured for this exam. Please configure the exam template first.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/result-management/students.blade.php ENDPATH**/ ?>