<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" x-data="{ sidebarOpen: true }">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'College Management')); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Scripts -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <style>
        .sidebar-transition {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .animate-slide-down {
            animation: slideDown 0.3s ease-out;
        }
        
        .scroll-smooth {
            scroll-behavior: smooth;
        }
        
        /* Custom Scrollbar */
        .custom-scrollbar::-webkit-scrollbar {
            width: 6px;
        }
        
        .custom-scrollbar::-webkit-scrollbar-track {
            background: #1e293b;
        }
        
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #475569;
            border-radius: 3px;
        }
        
        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #64748b;
        }
        
        [x-cloak] {
            display: none !important;
        }
        
        @media (min-width: 768px) {
            aside.sidebar-transition {
                display: flex !important;
            }
        }
        
        /* Fix header and sidebar on scroll */
        .fixed-layout {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            z-index: 50;
        }
        
        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 40;
        }
        
        .scrollable-content {
            overflow-y: auto;
            max-height: calc(100vh - 64px); /* Adjust based on header height */
        }
        
        /* Fix layout on desktop - header and sidebar fixed */
        @media (min-width: 768px) {
            body {
                overflow: hidden;
            }
            
            aside.sidebar-transition {
                position: fixed !important;
                height: 100vh !important;
                overflow-y: auto !important;
            }
            
            .main-content-wrapper {
                margin-left: 256px;
            }
            
            header.sticky-header {
                position: sticky !important;
                top: 0 !important;
                z-index: 40 !important;
            }
            
            main.scrollable-main {
                max-height: calc(100vh - 64px) !important;
                overflow-y: auto !important;
            }
        }
    </style>
</head>
<body class="font-sans antialiased bg-gray-50">
    <div class="min-h-screen flex">
        <!-- Sidebar - Fixed on Desktop -->
        <aside 
            class="fixed w-64 md:flex md:flex-col top-0 left-0 h-screen bg-gradient-to-b from-slate-900 to-slate-800 text-white overflow-y-auto custom-scrollbar z-50 shadow-2xl">
            
            <div class="flex flex-col h-full">
                <!-- Logo Section -->
                <div class="p-4 border-b border-slate-700">
                    <div class="flex items-center justify-between">
                        <div x-show="sidebarOpen || window.innerWidth > 768" class="flex items-center space-x-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-700 rounded-lg flex items-center justify-center">
                                <i class="fas fa-graduation-cap text-xl"></i>
                            </div>
                            <div>
                                <h1 class="font-bold text-lg leading-tight">SAWMC</h1>
                                <p class="text-xs text-blue-300">Admin Panel</p>
                            </div>
                        </div>
                        <div x-show="!sidebarOpen" class="w-full flex justify-center">
                            <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-700 rounded-lg flex items-center justify-center">
                                <i class="fas fa-graduation-cap text-xl"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Navigation Menu -->
                <nav class="flex-1 p-4 space-y-2">
                    <!-- Dashboard -->
                    <a href="<?php echo e(route('dashboard')); ?>" 
                       class="flex items-center space-x-3 px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('dashboard') ? 'bg-blue-600 text-white shadow-lg' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                        <i class="fas fa-tachometer-alt w-5"></i>
                        <span x-show="sidebarOpen" class="font-medium">Dashboard</span>
                    </a>

                    <!-- Students Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('students.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('students.*') ? 'bg-slate-700 text-white' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-user-graduate w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Students</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('students.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('students.index') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-list w-4"></i>
                                <span>All Students</span>
                            </a>
                            <a href="<?php echo e(route('students.create')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('students.create') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-plus w-4"></i>
                                <span>Add New</span>
                            </a>
                        </div>
                    </div>

                    <!-- Subjects Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('subjects.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('subjects.*') ? 'bg-slate-700 text-white' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-book w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Subjects</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('subjects.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('subjects.index') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-list w-4"></i>
                                <span>All Subjects</span>
                            </a>
                            <a href="<?php echo e(route('subjects.create')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('subjects.create') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-plus w-4"></i>
                                <span>Add Subject</span>
                            </a>
                        </div>
                    </div>



                    <!-- Exams Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('exams.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('exams.*') ? 'bg-slate-700 text-white' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-graduation-cap w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Exams</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('exams.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('exams.index') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-list w-4"></i>
                                <span>All Exams</span>
                            </a>
                            <a href="<?php echo e(route('exams.create')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('exams.create') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-plus w-4"></i>
                                <span>Create Exam</span>
                            </a>
                        </div>
                    </div>

                    <!-- Exam Templates Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('exam-templates.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('exam-templates.*') ? 'bg-gradient-to-r from-orange-600 to-orange-700 text-white shadow-lg' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-clipboard-check w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Exam Templates</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('exam-templates.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('exam-templates.index') ? 'bg-orange-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-list w-4"></i>
                                <span>All Templates</span>
                            </a>
                            <a href="<?php echo e(route('exam-templates.create')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('exam-templates.create') ? 'bg-orange-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-plus w-4"></i>
                                <span>Create Template</span>
                            </a>
                        </div>
                    </div>

                    <!-- Result Management Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('result-management.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('result-management.*') ? 'bg-gradient-to-r from-purple-600 to-purple-700 text-white shadow-lg' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-clipboard-list w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Result System</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('result-management.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('result-management.index') ? 'bg-purple-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-home w-4"></i>
                                <span>Dashboard</span>
                            </a>
                        </div>
                    </div>

                    <!-- Divider -->
                    <div class="border-t border-slate-700 my-4"></div>

                    <!-- Website Settings Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('settings.*') || request()->routeIs('hero-slides.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e((request()->routeIs('settings.*') || request()->routeIs('hero-slides.*')) ? 'bg-slate-700 text-white' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-cog w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Website Settings</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('settings.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('settings.index') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-sliders-h w-4"></i>
                                <span>General</span>
                            </a>
                            <a href="<?php echo e(route('hero-slides.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('hero-slides.*') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-images w-4"></i>
                                <span>Hero Slides</span>
                            </a>
                        </div>
                    </div>

                    <!-- Notices Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('notices.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('notices.*') ? 'bg-slate-700 text-white' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-bell w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Notices</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('notices.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('notices.index') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-list w-4"></i>
                                <span>All Notices</span>
                            </a>
                            <a href="<?php echo e(route('notices.create')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('notices.create') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-plus w-4"></i>
                                <span>Create Notice</span>
                            </a>
                            <a href="<?php echo e(route('notice-categories.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('notice-categories.*') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-tags w-4"></i>
                                <span>Categories</span>
                            </a>
                        </div>
                    </div>

                    <!-- Teachers Section -->
                    <div x-data="{ open: <?php echo e(request()->routeIs('teachers.*') ? 'true' : 'false'); ?> }">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('teachers.*') ? 'bg-slate-700 text-white' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-chalkboard-teacher w-5"></i>
                                <span x-show="sidebarOpen" class="font-medium">Teachers</span>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-down' : 'fa-chevron-right'" class="fas text-xs"></i>
                        </button>
                        <div x-show="open && sidebarOpen" x-collapse class="ml-4 mt-2 space-y-1">
                            <a href="<?php echo e(route('teachers.index')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('teachers.index') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-list w-4"></i>
                                <span>All Teachers</span>
                            </a>
                            <a href="<?php echo e(route('teachers.create')); ?>" class="flex items-center space-x-2 px-4 py-2 rounded-lg text-sm <?php echo e(request()->routeIs('teachers.create') ? 'bg-blue-600 text-white' : 'text-gray-400 hover:bg-slate-700 hover:text-white'); ?>">
                                <i class="fas fa-plus w-4"></i>
                                <span>Add Teacher</span>
                            </a>
                        </div>
                    </div>

                    <!-- Divider -->
                    <div class="border-t border-slate-700 my-4"></div>

                    <!-- Settings -->
                    <a href="<?php echo e(route('profile.edit')); ?>" 
                       class="flex items-center space-x-3 px-4 py-3 rounded-lg transition-all duration-200 <?php echo e(request()->routeIs('profile.*') ? 'bg-blue-600 text-white shadow-lg' : 'text-gray-300 hover:bg-slate-700 hover:text-white'); ?>">
                        <i class="fas fa-user-cog w-5"></i>
                        <span x-show="sidebarOpen" class="font-medium">Profile</span>
                    </a>
                </nav>

                <!-- User Profile Section -->
                <div class="p-4 border-t border-slate-700">
                    <div x-data="{ open: false }" class="relative">
                        <button @click="open = !open" class="w-full flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-slate-700 transition-all duration-200">
                            <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-500 rounded-full flex items-center justify-center">
                                <span class="font-bold text-sm"><?php echo e(substr(Auth::user()->name, 0, 2)); ?></span>
                            </div>
                            <div x-show="sidebarOpen" class="flex-1 text-left">
                                <p class="font-medium text-sm"><?php echo e(Auth::user()->name); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e(Auth::user()->email); ?></p>
                            </div>
                            <i x-show="sidebarOpen" :class="open ? 'fa-chevron-up' : 'fa-chevron-down'" class="fas text-xs"></i>
                        </button>
                        
                        <div x-show="open && sidebarOpen" @click.away="open = false" 
                             x-transition
                             class="absolute bottom-full left-0 right-0 mb-2 bg-slate-700 rounded-lg shadow-lg overflow-hidden">
                            <a href="<?php echo e(route('profile.edit')); ?>" class="block px-4 py-3 hover:bg-slate-600 transition">
                                <i class="fas fa-user mr-2"></i>Profile
                            </a>
                            <form method="POST" action="<?php echo e(route('tyro-login.logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="w-full text-left px-4 py-3 hover:bg-slate-600 transition text-red-400">
                                    <i class="fas fa-sign-out-alt mr-2"></i>Logout
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </aside>

        

        <!-- Main Content -->
        <div class="flex-1 flex flex-col min-h-screen main-content-wrapper">
            <!-- Top Navigation - Sticky Header -->
            <header class="bg-white shadow-sm sticky-header sticky top-0 z-40">
                <div class="px-4 py-4 flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        
                        
        <?php if(isset($header)): ?>
                            <div class="hidden md:block">
                    <?php echo e($header); ?>

                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="flex items-center space-x-4">
                        <!-- Quick Actions -->
                        <a href="<?php echo e(url('/frontend')); ?>" target="_blank" 
                           class="hidden md:flex items-center space-x-2 px-4 py-2 bg-blue-50 text-blue-600 rounded-lg hover:bg-blue-100 transition">
                            <i class="fas fa-external-link-alt"></i>
                            <span class="text-sm font-medium">View Website</span>
                        </a>
                        
                        <!-- Notifications -->
                        <button class="relative p-2 rounded-lg hover:bg-gray-100 transition-colors">
                            <i class="fas fa-bell text-gray-600"></i>
                            <span class="absolute top-0 right-0 w-2 h-2 bg-red-500 rounded-full"></span>
                        </button>
                    </div>
                </div>
            </header>

            <!-- Page Content - Scrollable -->
            <main class="flex-1 overflow-y-auto bg-gray-50 scrollable-main">
                <div class="p-4 md:p-6 lg:p-8">
                    <!-- Mobile Header -->
                    <?php if(isset($header)): ?>
                        <div class="md:hidden mb-6">
                            <?php echo e($header); ?>

                        </div>
        <?php endif; ?>

                    <!-- Flash Messages -->
                <?php if(session('success')): ?>
                        <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg animate-slide-down">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-3"></i>
                                <span class="text-green-700"><?php echo e(session('success')); ?></span>
                            </div>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                        <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg animate-slide-down">
                            <div class="flex items-center">
                                <i class="fas fa-exclamation-circle text-red-500 mr-3"></i>
                                <span class="text-red-700"><?php echo e(session('error')); ?></span>
                            </div>
                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                        <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg animate-slide-down">
                            <div class="flex items-start">
                                <i class="fas fa-exclamation-triangle text-red-500 mr-3 mt-1"></i>
                                <div class="flex-1">
                                    <ul class="list-disc list-inside text-red-700 space-y-1">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                                </div>
                            </div>
                    </div>
                <?php endif; ?>

                    <!-- Main Content Slot -->
                <?php echo e($slot); ?>

            </div>
        </main>

            <!-- Footer -->
            <footer class="bg-white border-t border-gray-200 px-4 py-4">
                <div class="flex flex-col md:flex-row justify-between items-center text-sm text-gray-600">
                    <p>&copy; <?php echo e(date('Y')); ?> Sheikh Abdul Wohab Model College. All rights reserved.</p>
                    <p class="mt-2 md:mt-0">Powered by Laravel <?php echo e(app()->version()); ?></p>
                </div>
            </footer>
        </div>
    </div>
</body>
</html>
<?php /**PATH T:\Motiur\college\admin\resources\views/components/app-layout.blade.php ENDPATH**/ ?>