

<?php $__env->startSection('title', 'Subject Management'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Subjects</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('subjects.create')); ?>" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Add Subject
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Filter Card -->
<div class="card mb-4">
    <div class="card-body">
         <form method="GET" action="<?php echo e(route('subjects.index')); ?>" class="row g-3">
            <div class="col-md-5">
                <label class="form-label small text-muted fw-bold">Group</label>
                <select name="group" class="form-select">
                    <option value="">All Groups</option>
                    <option value="Core" <?php echo e(request('group') == 'Core' ? 'selected' : ''); ?>>Core</option>
                    <option value="Science" <?php echo e(request('group') == 'Science' ? 'selected' : ''); ?>>Science</option>
                    <option value="Arts" <?php echo e(request('group') == 'Arts' ? 'selected' : ''); ?>>Arts</option>
                    <option value="Commerce" <?php echo e(request('group') == 'Commerce' ? 'selected' : ''); ?>>Commerce</option>
                </select>
            </div>

            <div class="col-md-5">
                 <label class="form-label small text-muted fw-bold">Status</label>
                 <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                 </select>
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-dark w-100">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
            </div>
         </form>
    </div>
</div>

<!-- Subjects Table -->
<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted small text-uppercase">
                    <tr>
                        <th class="ps-4">Subject Info</th>
                        <th>Code</th>
                        <th>Configuration</th>
                        <th>Status</th>
                        <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar rounded-circle bg-primary bg-opacity-10 text-primary d-flex align-items-center justify-content-center fw-bold me-3" style="width: 40px; height: 40px;">
                                        <?php echo e(substr($subject->code, 0, 2)); ?>

                                    </div>
                                    <div>
                                        <h6 class="mb-0 text-dark fw-bold"><?php echo e($subject->name); ?></h6>
                                        <?php if($subject->is_4th_subject_eligible): ?>
                                            <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 mt-1">
                                                <i class="bi bi-star-fill me-1"></i> Optional Eligible
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark border font-monospace"><?php echo e($subject->code); ?></span>
                            </td>
                            <td>
                                <div class="d-flex flex-column gap-1 small">
                                    <?php if($subject->has_multiple_papers): ?>
                                        <div class="text-primary"><i class="bi bi-files me-1"></i> 2 Papers</div>
                                    <?php else: ?>
                                        <div class="text-secondary"><i class="bi bi-file-text me-1"></i> Single Paper</div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <?php if($subject->status === 'active'): ?>
                                    <span class="badge badge-soft-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-soft-danger">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-end pe-4">
                                <div class="btn-group">
                                    <a href="<?php echo e(route('subjects.show', $subject)); ?>" class="btn btn-sm btn-light text-primary" data-bs-toggle="tooltip" title="View details"><i class="bi bi-eye"></i></a>
                                    <a href="<?php echo e(route('subjects.edit', $subject)); ?>" class="btn btn-sm btn-light text-warning" data-bs-toggle="tooltip" title="Edit subject"><i class="bi bi-pencil-square"></i></a>
                                    
                                    <form action="<?php echo e(route('subjects.destroy', $subject)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this subject?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="py-5 text-center text-muted">
                                <div class="mb-3">
                                    <i class="bi bi-book fs-1 text-secondary opacity-50"></i>
                                </div>
                                <p class="mb-1">No subjects found.</p>
                                <a href="<?php echo e(route('subjects.create')); ?>" class="btn btn-sm btn-primary mt-2">Create First Subject</a>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($subjects->hasPages()): ?>
        <div class="card-footer bg-white border-top-0 py-3">
            <?php echo e($subjects->links('pagination::bootstrap-5')); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/subjects/index.blade.php ENDPATH**/ ?>