

<?php $__env->startSection('title', 'Select Batch for Exams'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('exams.create')); ?>" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Create Exam
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row g-4">
        <?php $__empty_1 = true; $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-6 col-lg-3">
                <a href="<?php echo e(route('exams.index', ['batch_id' => $batch->id])); ?>" class="text-decoration-none">
                    <div class="card shadow-sm border-0 h-100 hover-shadow transition-all">
                        <div class="card-body text-center p-4">
                            <div class="mb-3 text-danger opacity-75">
                                <i class="bi bi-journal-check display-1"></i>
                            </div>
                            <h5 class="fw-bold text-dark mb-1"><?php echo e($batch->name); ?></h5>
                            <p class="text-muted small mb-2"><?php echo e($batch->session); ?></p>

                            <span class="badge bg-danger-subtle text-danger rounded-pill px-3">
                                <?php echo e($batch->exams_count); ?> Exams
                            </span>
                        </div>
                    </div>
                </a>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12 text-center py-5">
                <div class="text-muted opacity-50 mb-3">
                    <i class="bi bi-inboxes display-1"></i>
                </div>
                <h4>No Batches Found</h4>
                <p class="text-muted">No exams created yet.</p>
            </div>
        <?php endif; ?>

        <!-- All Exams Option -->
        <div class="col-md-6 col-lg-3">
            <a href="<?php echo e(route('exams.index', ['search' => ' '])); ?>" class="text-decoration-none">
                <div class="card shadow-sm border-0 h-100 hover-shadow transition-all bg-light">
                    <div class="card-body text-center p-4">
                        <div class="mb-3 text-secondary opacity-50">
                            <i class="bi bi-collection display-1"></i>
                        </div>
                        <h5 class="fw-bold text-dark mb-1">All Exams</h5>
                        <p class="text-muted small mb-2">View Global Checklist</p>

                        <span class="badge bg-secondary rounded-pill px-3">
                            Global List
                        </span>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <style>
        .hover-shadow:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1) !important;
        }

        .transition-all {
            transition: all 0.3s ease;
        }
    </style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/exams/batches.blade.php ENDPATH**/ ?>